/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.app;

import java.io.File;
import java.io.IOException;
import java.util.function.BiConsumer;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.access.BasicInitializationData;
import org.cyclos.model.access.RemoteAddressBlockedException;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.contentmanagement.themes.ThemeType;
import org.cyclos.model.contentmanagement.themes.ThemeVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.languages.LanguageDetailedVO;
import org.cyclos.model.system.licensing.BasicLicenseVO;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.services.access.InitializationService;
import org.cyclos.services.contentmanagement.ThemeService;
import org.cyclos.services.system.LanguageService;
import org.cyclos.services.system.LicenseService;
import org.cyclos.utils.ContentType;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.app.AngularStaticContentResolver;
import org.cyclos.web.app.I18nContentResolver;
import org.cyclos.web.controllers.BaseController;
import org.cyclos.web.controllers.contentmanagement.CSSContentResolver;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

public abstract class AngularAppController
extends BaseController {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    protected ServletContext servletContext;
    @Autowired
    protected CyclosProperties cyclosProperties;
    @Autowired
    protected ThemeService themeService;
    @Autowired
    protected LanguageService languageService;
    @Autowired
    protected InitializationService initializationService;
    @Autowired
    protected LicenseService licenseService;
    @Autowired
    protected JsonConverter jsonConverter;
    protected File tempDir;

    public abstract ModelAndView index(HttpServletRequest var1, HttpServletResponse var2) throws IOException, ServletException;

    @PostConstruct
    public void initialize() {
        this.tempDir = new File(this.cyclosProperties.getTempDir(), this.getAppId());
    }

    @RequestMapping(value={"/**"})
    public ModelAndView staticFiles(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string = ServletHelper.getInternalUri(httpServletRequest);
        File file = new File(this.servletContext.getRealPath(string));
        if (file.exists()) {
            this.serveStatic(httpServletRequest, httpServletResponse);
            return null;
        }
        return this.index(httpServletRequest, httpServletResponse);
    }

    @RequestMapping(value={"/*.css"})
    public void style(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(name="id", required=false) Long l) throws IOException, ServletException {
        if (this.useAppStyle()) {
            ThemeVO themeVO = l == null ? this.themeService.getTheme(ThemeType.APP) : this.themeService.getVO(l);
            CSSContentResolver cSSContentResolver = new CSSContentResolver(this.cyclosProperties, this.themeService, themeVO, this.getTempDir("themes"));
            cSSContentResolver.write(httpServletRequest, httpServletResponse);
        } else {
            this.serveStatic(httpServletRequest, httpServletResponse);
        }
    }

    @RequestMapping(value={"/i18n/**"})
    public void translations(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = StringUtils.substringAfterLast((String)httpServletRequest.getRequestURI(), (int)47);
        String string2 = StringHelper.removeEnd((String)StringUtils.removeStart((String)string, (String)"i18n."), (String)".json");
        if (StringHelper.isBlank((Object)string2) || "json".equals(string2)) {
            string2 = "en";
        }
        LanguageDetailedVO languageDetailedVO = this.languageService.resolve(string2);
        new I18nContentResolver(this.cyclosProperties, this.internalTranslationMessageService, this.jsonConverter, languageDetailedVO, new File(this.tempDir, "i18n")).write(httpServletRequest, httpServletResponse);
    }

    protected String base(RequestData requestData) {
        String string = StringHelper.removeEnd((String)this.rootUrl(requestData), (String)"/");
        String string2 = StringHelper.removeEnd((String)requestData.getApiUrl(), (String)"/");
        return "\n<base href=\"" + string + "/\">\n<link rel=\"shortcut icon\" href=\"" + string2 + "/logos/frontend?width=128&height=128\">";
    }

    protected String errorMessage(Exception exception) {
        if (exception instanceof EntityNotFoundException) {
            EntityNotFoundException entityNotFoundException = (EntityNotFoundException)exception;
            if (StringHelper.isBlank((Object)entityNotFoundException.getEntityType())) {
                return this.message(GeneralKeys.Errors.NOT_FOUND, new Object[0]);
            }
            String string = (String)ObjectHelper.defaultValue((Object)StringHelper.trimToNull((Object)entityNotFoundException.getId()), (Object)entityNotFoundException.getKey());
            if (string == null) {
                return this.message(GeneralKeys.Errors.ENTITY_NOT_FOUND, entityNotFoundException.getEntityType());
            }
            return this.message(GeneralKeys.Errors.ENTITY_NOT_FOUND_KEY, entityNotFoundException.getEntityType(), string);
        }
        if (exception instanceof RemoteAddressBlockedException) {
            return this.message(GeneralKeys.Errors.REMOTE_ADDRESS_BLOCKED, new Object[0]);
        }
        return null;
    }

    protected String fontCssUrl(RequestData requestData) {
        return requestData.getBaseUrl() + "/fonts/roboto.css?";
    }

    protected abstract String getAppId();

    protected Logger logger() {
        return this.logger;
    }

    protected String meta() {
        BasicInitializationData basicInitializationData = this.initializationService.getBasicInitializationData();
        BasicLicenseVO basicLicenseVO = this.licenseService.getBasicLicense();
        StringBuilder stringBuilder = new StringBuilder();
        BiConsumer<String, String> biConsumer = (string, string2) -> {
            if (StringHelper.isNotBlank((Object)string2)) {
                stringBuilder.append("\n  <meta name=\"").append((String)string).append("\" content=\"").append(StringEscapeUtils.escapeHtml4((String)string2)).append("\">");
            }
        };
        biConsumer.accept("description", basicInitializationData.getApplicationDescription());
        biConsumer.accept("owner", basicLicenseVO.getOrganizationName());
        biConsumer.accept("copyright", String.format("Runs on Cyclos %s (revision %s) registered with key %s", basicInitializationData.getApplicationVersion(), basicInitializationData.getApplicationCommitId(), basicLicenseVO.getLicenseKey()));
        return stringBuilder.toString();
    }

    protected String rootUrl(RequestData requestData) {
        return requestData.getBaseUrl() + "/" + this.getAppId();
    }

    protected void serveStatic(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = ServletHelper.getInternalUri(httpServletRequest);
        File file = new File(this.servletContext.getRealPath(string));
        ContentType contentType = ContentType.getByFileName((String)string);
        new AngularStaticContentResolver(this.getAppId(), this.tempDir, file, string, contentType).write(httpServletRequest, httpServletResponse);
    }

    protected String styleUrl(RequestData requestData) {
        ThemeVO themeVO = this.themeService.getTheme(ThemeType.APP);
        return requestData.getBaseUrl() + "/ui/theme.css?id=" + themeVO.getId() + "&mod=" + themeVO.getLastModifiedInMillis() + "&_k=" + this.initializationService.getResourceCacheKey();
    }

    protected boolean useAppStyle() {
        return true;
    }
}

