/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.app;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.utils.ContentType;
import org.cyclos.web.controllers.StaticFileCompressingContentResolver;

class AngularStaticContentResolver
extends StaticFileCompressingContentResolver {
    private final String appId;
    private final String uri;
    private final ContentType contentType;
    private final File originalFile;
    private final File tempDir;

    public AngularStaticContentResolver(String string, File file, File file2, String string2, ContentType contentType) {
        this.appId = string;
        this.tempDir = file;
        this.originalFile = file2;
        this.uri = string2;
        this.contentType = contentType;
    }

    @Override
    protected ContentType resolveContentType(File file) throws IOException {
        return this.contentType;
    }

    @Override
    protected File resolveGZipFile(File file) {
        File file2 = new File(this.tempDir, StringUtils.removeStart((String)this.uri, (String)("/" + this.appId)) + ".gz");
        file2.getParentFile().mkdirs();
        return file2;
    }

    @Override
    protected File resolveOriginalFile() throws IOException {
        return this.originalFile;
    }

    @Override
    protected boolean useCache(File file) {
        return !file.getName().equals("index.html");
    }
}

