/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.app.pay;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.model.Property;
import org.cyclos.model.VersionedVO;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.transactions.PrepareEasyInvoiceData;
import org.cyclos.model.banking.transactions.PrepareEasyInvoiceParams;
import org.cyclos.model.banking.transactions.TicketData;
import org.cyclos.model.banking.transactions.TicketVO;
import org.cyclos.model.banking.transactions.TransactionData;
import org.cyclos.model.contentmanagement.GetVersionedDataParams;
import org.cyclos.model.contentmanagement.themes.ThemeType;
import org.cyclos.model.contentmanagement.themes.ThemeVO;
import org.cyclos.model.contentmanagement.translations.TranslationsData;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.model.contentmanagement.UiData;
import org.cyclos.services.banking.EasyInvoiceService;
import org.cyclos.services.banking.TicketService;
import org.cyclos.services.contentmanagement.InternalUiService;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.Submodule;
import org.cyclos.utils.coercion.CoercionHelper;
import org.cyclos.web.app.AngularAppController;
import org.cyclos.web.controllers.contentmanagement.CSSContentResolver;
import org.cyclos.web.rest.api.EasyInvoicesApi;
import org.cyclos.web.rest.helpers.EasyInvoicesApiHelper;
import org.cyclos.web.rest.helpers.TransactionsApiHelper;
import org.cyclos.web.rest.helpers.UiApiHelper;
import org.cyclos.web.rest.model.DataForEasyInvoice;
import org.cyclos.web.rest.model.DataForUi;
import org.cyclos.web.rest.model.TransactionView;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/pay"})
public class PayController
extends AngularAppController {
    public static final String APP_ID = "pay";
    static final Map<String, MessageKey> MESSAGE_KEYS = new HashMap<String, MessageKey>();
    private static final Set<Submodule> SUBMODULES = new HashSet<Submodule>();
    @Autowired
    private InternalUiService internalUiService;
    @Autowired
    private TicketService ticketService;
    @Autowired
    private EasyInvoiceService easyInvoiceService;
    @Autowired
    private EasyInvoicesApiHelper easyInvoicesApiHelper;
    @Autowired
    private UiApiHelper uiApiHelper;
    @Autowired
    private TransactionsApiHelper transactionsApiHelper;

    private static void register(MessageKey messageKey) {
        PayController.register(messageKey.key(), messageKey);
    }

    private static void register(String string, MessageKey messageKey) {
        if (MESSAGE_KEYS.put(string, messageKey) != null) {
            throw new IllegalStateException("The key " + string + " was already registered");
        }
        SUBMODULES.add(messageKey.submodule());
    }

    @Override
    public ModelAndView index(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        ServletHelper.forceGuest(httpServletRequest);
        ServletHelper.setNoCache(httpServletResponse);
        String string = httpServletRequest.getRequestURI();
        String string2 = StringUtils.substringAfterLast((String)string, (String)"/pay/");
        if (StringHelper.isBlank((Object)string2)) {
            return this.root(httpServletRequest, httpServletResponse, httpServletRequest.getParameter("to"), (BigDecimal)CoercionHelper.coerce(BigDecimal.class, (Object)httpServletRequest.getParameter("amount")), httpServletRequest.getParameter("type"), httpServletRequest.getParameter("currency"));
        }
        return this.ticket(string2);
    }

    @RequestMapping(value={"", "/"})
    public ModelAndView root(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(name="to", required=false) String string, @RequestParam(name="amount", required=false) BigDecimal bigDecimal, @RequestParam(name="type", required=false) String string2, @RequestParam(name="currency", required=false) String string3) throws IOException, ServletException {
        if (StringHelper.isNotBlank((Object)string)) {
            EasyInvoicesApi.DataForPerformEasyInvoiceParams dataForPerformEasyInvoiceParams = new EasyInvoicesApi.DataForPerformEasyInvoiceParams();
            dataForPerformEasyInvoiceParams.to = string;
            dataForPerformEasyInvoiceParams.amount = bigDecimal;
            dataForPerformEasyInvoiceParams.type = string2;
            dataForPerformEasyInvoiceParams.currency = string3;
            return this.easyInvoice(dataForPerformEasyInvoiceParams);
        }
        return this.ticket(null);
    }

    @Override
    @RequestMapping(value={"/*.css"})
    public void style(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(name="id", required=false) Long l) throws IOException, ServletException {
        ThemeVO themeVO = this.themeService.getTheme(ThemeType.PAY);
        CSSContentResolver cSSContentResolver = new CSSContentResolver(this.cyclosProperties, this.themeService, themeVO, this.getTempDir("themes"));
        cSSContentResolver.write(httpServletRequest, httpServletResponse);
    }

    @RequestMapping(value={"/translations.json"})
    @ResponseBody
    public Map<String, String> translations() {
        return this.getTranslations();
    }

    @Override
    protected String getAppId() {
        return APP_ID;
    }

    @Override
    protected String styleUrl(RequestData requestData) {
        return "styles.css?_k" + this.initializationService.getResourceCacheKey();
    }

    private ModelAndView easyInvoice(EasyInvoicesApi.DataForPerformEasyInvoiceParams dataForPerformEasyInvoiceParams) {
        DataForEasyInvoice dataForEasyInvoice;
        ServletHelper.setContentChannel(ServletHelper.getRequest(), BuiltInChannel.EASY_INVOICE);
        String string = null;
        try {
            PrepareEasyInvoiceParams prepareEasyInvoiceParams = this.easyInvoicesApiHelper.toPrepareEasyInvoiceParams(dataForPerformEasyInvoiceParams);
            PrepareEasyInvoiceData prepareEasyInvoiceData = this.easyInvoiceService.prepareEasyInvoice(prepareEasyInvoiceParams);
            dataForEasyInvoice = this.easyInvoicesApiHelper.toDataForEasyInvoice(prepareEasyInvoiceData);
        }
        catch (Exception exception) {
            dataForEasyInvoice = null;
            string = this.errorMessage(exception);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("meta", this.meta());
        hashMap.put("easyInvoice", dataForEasyInvoice);
        hashMap.put("error", string);
        return this.modelAndView(hashMap);
    }

    private Map<String, String> getTranslations() {
        TranslationsData translationsData = this.internalTranslationMessageService.getBySubmodules(SUBMODULES);
        Map map = translationsData.getTranslations();
        return MESSAGE_KEYS.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (String)map.get(((MessageKey)entry.getValue()).fullKey())));
    }

    private ModelAndView modelAndView(Map<String, Object> map) {
        RequestData requestData = ServletHelper.getRequestData();
        GetVersionedDataParams getVersionedDataParams = new GetVersionedDataParams();
        getVersionedDataParams.setTheme(new VersionedVO((Property)VersionedVO.FORCE, (Object)false));
        UiData uiData = this.internalUiService.getData(ThemeType.PAY, true, null, null, getVersionedDataParams);
        DataForUi dataForUi = this.uiApiHelper.toDataForUi(uiData);
        Map<String, String> map2 = this.getTranslations();
        return new ModelAndView(APP_ID).addObject("base", (Object)this.base(requestData)).addObject("rootUrl", (Object)this.rootUrl(requestData)).addObject("styleUrl", (Object)this.styleUrl(requestData)).addObject("cacheKey", (Object)dataForUi.getResourceCacheKey()).addObject("dataForUi", (Object)dataForUi).addObject("translations", map2).addObject("ticket", (Object)"null").addObject("easyInvoice", (Object)"null").addObject("to", (Object)"null").addAllObjects(map);
    }

    private ModelAndView ticket(String string) {
        ServletHelper.setContentChannel(ServletHelper.getRequest(), BuiltInChannel.TICKET);
        TransactionView transactionView = null;
        String string2 = null;
        try {
            if (string != null) {
                TicketData ticketData = this.ticketService.getData((TicketVO)ModelHelper.voFromString(TicketVO.class, (String)string));
                transactionView = this.transactionsApiHelper.toTransactionView((TransactionData)ticketData);
            }
        }
        catch (Exception exception) {
            string2 = this.errorMessage(exception);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("meta", this.meta());
        hashMap.put("ticket", transactionView);
        hashMap.put("error", string2);
        return this.modelAndView(hashMap);
    }

    static {
        PayController.register(BankingKeys.Pay.APPROVED_BY_LOGGED);
        PayController.register(BankingKeys.Pay.APPROVED);
        PayController.register(BankingKeys.Pay.CANCELED_BY_LOGGED);
        PayController.register(BankingKeys.Pay.CANCELED);
        PayController.register(BankingKeys.Pay.CONTINUE_WITH_APP);
        PayController.register(BankingKeys.Pay.CONTINUE_WITH_WEB);
        PayController.register(BankingKeys.Pay.INSTALL_MOBILE_APP);
        PayController.register(BankingKeys.Pay.INSTALL_MOBILE_APP_TEXT);
        PayController.register(BankingKeys.Pay.CLOSE_WINDOW);
        PayController.register(BankingKeys.Pay.EXPIRED);
        PayController.register(BankingKeys.Pay.LOGIN);
        PayController.register(BankingKeys.Pay.LOGIN_FOR_DETAILS);
        PayController.register(BankingKeys.Pay.PROCESSED_DONE);
        PayController.register(BankingKeys.Pay.PROCESSED_PENDING_AUTH);
        PayController.register(BankingKeys.Pay.SCAN);
        PayController.register(BankingKeys.Pay.SCAN_DESCRIPTION);
        PayController.register(BankingKeys.Pay.SCAN_DESCRIPTION_MOBILE_ONLY);
        PayController.register(BankingKeys.Pay.CANNOT_PAY_OWN_TICKET);
        PayController.register(BankingKeys.Pay.TITLE_BASE);
        PayController.register(BankingKeys.Pay.TITLE_CHOOSE_CONTINUE);
        PayController.register(BankingKeys.Pay.TITLE_CHOOSE_CONTINUE_MOBILE_ONLY);
        PayController.register(BankingKeys.Pay.TITLE_CONFIRM);
        PayController.register(BankingKeys.Pay.TITLE_DETAILS);
        PayController.register(BankingKeys.Pay.TITLE_FORM);
        PayController.register(BankingKeys.Pay.TITLE_LOGIN);
        PayController.register(BankingKeys.Pay.TITLE_METHOD);
        PayController.register(BankingKeys.Pay.TITLE_SCAN);
        PayController.register(BankingKeys.Pay.TITLE_CONFIRMATION_PASSWORD);
        PayController.register(GeneralKeys.Ui.CANCEL);
        PayController.register(GeneralKeys.Ui.ACCEPT);
        PayController.register(GeneralKeys.Ui.CONFIRM);
        PayController.register(GeneralKeys.Ui.CLOSE);
        PayController.register(GeneralKeys.Ui.NEXT);
        PayController.register(GeneralKeys.Ui.BACK);
        PayController.register(GeneralKeys.Ui.YES);
        PayController.register(GeneralKeys.Ui.NO);
        PayController.register(GeneralKeys.Ui.SEND_MEDIUM_EMAIL);
        PayController.register(GeneralKeys.Ui.SEND_MEDIUM_SMS);
        PayController.register(GeneralKeys.Ui.NEW_OTP_SENT_BY_EMAIL);
        PayController.register(GeneralKeys.Ui.NEW_OTP_SENT_BY_SMS);
        PayController.register("error.badRequest", GeneralKeys.Errors.BAD_REQUEST);
        PayController.register("error.password.temporarilyBlocked", GeneralKeys.Errors.BLOCKED_PASSWORD);
        PayController.register("error.password.indefinitelyBlocked", GeneralKeys.Errors.DISABLED_PASSWORD);
        PayController.register("error.password.expired", GeneralKeys.Errors.EXPIRED_PASSWORD);
        PayController.register("error.password.reset", GeneralKeys.Errors.RESET_PASSWORD);
        PayController.register("error.notFound", GeneralKeys.Errors.NOT_FOUND);
        PayController.register("error.entityNotFound", GeneralKeys.Errors.ENTITY_NOT_FOUND);
        PayController.register("error.entityNotFoundKey", GeneralKeys.Errors.ENTITY_NOT_FOUND_KEY);
        PayController.register("error.general", GeneralKeys.Errors.GENERAL);
        PayController.register("error.invalid", GeneralKeys.Errors.INVALID);
        PayController.register("error.illegalAction", GeneralKeys.Errors.ILLEGAL_ACTION);
        PayController.register("error.network", GeneralKeys.Errors.NETWORK_CONNECTION);
        PayController.register("error.permission", GeneralKeys.Errors.PERMISSION_DENIED);
        PayController.register("error.required", GeneralKeys.Errors.REQUIRED);
        PayController.register("error.sessionExpired", GeneralKeys.Errors.SESSION_EXPIRED);
        PayController.register("error.unauthorizedAddress", GeneralKeys.Errors.UNAUTHORIZED_ADDRESS);
        PayController.register("error.validation", GeneralKeys.Errors.VALIDATION);
        PayController.register(AccessKeys.Login.PASSWORD);
        PayController.register(AccessKeys.Login.PRINCIPAL);
        PayController.register("error.login", AccessKeys.Login.ERROR_INVALID);
        PayController.register("error.login.pendingAgreements", AccessKeys.Login.ERROR_USER_WITH_PENDING_AGREEMENTS);
        PayController.register("error.login.password.expired", AccessKeys.Login.ERROR_PASSWORD_EXPIRED);
        PayController.register("error.login.password.indefinitelyBlocked", AccessKeys.Login.ERROR_PASSWORD_INDEFINITELY_BLOCKED);
        PayController.register("error.login.password.temporarilyBlocked", AccessKeys.Login.ERROR_PASSWORD_TEMPORARILY_BLOCKED);
        PayController.register("error.login.password.reset", AccessKeys.Login.ERROR_PASSWORD_RESET);
        PayController.register(AccessKeys.PasswordTypes.CONFIRMATION_PASSWORD);
        PayController.register("error.canNot.send.sms", GeneralKeys.Errors.CAN_NOT_SEND_SMS);
        PayController.register(BankingKeys.Transactions.AMOUNT);
        PayController.register(BankingKeys.Transactions.TOTAL_AMOUNT);
        PayController.register(BankingKeys.Transactions.APPLIED_FEES);
        PayController.register(BankingKeys.Accounts.FROM);
        PayController.register("fromAccount", BankingKeys.Transactions.PAYMENT_FROM_ACCOUNT);
        PayController.register(BankingKeys.Accounts.TO);
        PayController.register(BankingKeys.Transactions.TYPE);
        PayController.register(GeneralKeys.Ui.DESCRIPTION);
        PayController.register("error.payment.balance", BankingKeys.Transfers.ERROR_INSUFFICIENT_BALANCE);
        PayController.register("error.payment.minTime", BankingKeys.Transfers.ERROR_MIN_TIME_BETWEEN_PAYMENTS_EXCEPTION);
        PayController.register("error.payment.max.amount", BankingKeys.Transfers.ERROR_MAX_AMOUNT_EXCEEDED);
        PayController.register("error.payment.day.amount", BankingKeys.Transfers.ERROR_MAX_AMOUNT_PER_DAY_EXCEEDED);
        PayController.register("error.payment.day.count", BankingKeys.Transfers.ERROR_MAX_PAYMENTS_PER_DAY_EXCEEDED);
        PayController.register("error.payment.week.amount", BankingKeys.Transfers.ERROR_MAX_AMOUNT_PER_WEEK_EXCEEDED);
        PayController.register("error.payment.week.count", BankingKeys.Transfers.ERROR_MAX_PAYMENTS_PER_WEEK_EXCEEDED);
        PayController.register("error.payment.month.count", BankingKeys.Transfers.ERROR_MAX_AMOUNT_PER_MONTH_EXCEEDED);
        PayController.register("error.payment.month.amount", BankingKeys.Transfers.ERROR_MAX_PAYMENTS_PER_MONTH_EXCEEDED);
        PayController.register("error.payment.upperCreditLimit", BankingKeys.Transfers.ERROR_UPPER_CREDIT_LIMIT_REACHED);
    }
}

