/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers;

import java.io.File;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.utils.NotificationLevel;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.services.access.InitializationService;
import org.cyclos.services.contentmanagement.InternalTranslationMessageService;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.MessageProducer;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.ValidationResult;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.ModelAndView;

public abstract class BaseController
implements MessageProducer {
    public static final String CONTENT = "/content";
    private static final String GWT_CODESVR = "gwt.codesvr";
    private Logger logger;
    @Autowired
    protected JsonConverter jsonConverter;
    @Autowired
    protected InternalTranslationMessageService internalTranslationMessageService;
    @Autowired
    protected InitializationService initializationService;
    @Autowired
    protected CyclosProperties cyclosProperties;

    public String message(MessageFormat messageFormat, MessageKey messageKey, Object ... objectArray) throws FrameworkException {
        return this.internalTranslationMessageService.message(messageFormat, messageKey, objectArray);
    }

    public String message(MessageKey messageKey, Object ... objectArray) throws FrameworkException {
        return this.internalTranslationMessageService.message(messageKey, objectArray);
    }

    protected String getHomeUrl(HttpServletRequest httpServletRequest) {
        RequestData requestData = ServletHelper.getRequestData();
        Object object = requestData.getBaseUrl();
        String string = httpServletRequest.getParameter(GWT_CODESVR);
        if (StringHelper.isNotBlank((Object)string)) {
            object = ((String)object).contains("?") ? (String)object + "&" : (String)object + "?";
            object = (String)object + "gwt.codesvr=" + string;
        }
        return object;
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = LogManager.getLogger(this.getClass());
        }
        return this.logger;
    }

    protected File getTempDir(String string) {
        File file = new File(this.cyclosProperties.getTempDir(), string);
        file.mkdirs();
        return file;
    }

    protected ModelAndView sendNotification(NotificationLevel notificationLevel, String string, boolean bl) {
        String string2;
        try {
            string2 = this.message(MessageFormat.HTML, GeneralKeys.Ui.BROWSER_NOT_SUPPORTED, new Object[0]);
        }
        catch (Exception exception) {
            string2 = "Your browser is not supported";
        }
        return ServletHelper.sendNotification(notificationLevel, string, string2, bl);
    }

    protected ModelAndView sendValidationError(ValidationException validationException) {
        ValidationResult validationResult = validationException.getValidation();
        return this.sendNotification(NotificationLevel.ERROR, validationResult.toHtmlString(this.message(GeneralKeys.Errors.VALIDATION, new Object[0])), true);
    }
}

