/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.LoggedOutException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.utils.ResponseException;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

@Component
public class HandlerExceptionResolverImpl
implements HandlerExceptionResolver {
    public ModelAndView resolveException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object, Exception exception) {
        if (exception instanceof MaxUploadSizeExceededException) {
            this.writeUploadFailure(httpServletRequest, httpServletResponse, (MaxUploadSizeExceededException)exception);
            return new ModelAndView();
        }
        if (StringHelper.trim((Object)httpServletRequest.getContentType()).toLowerCase().contains("multipart/form-data")) {
            try {
                ServletHelper.writeJsonErrorToResponse(httpServletRequest, httpServletResponse, exception);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return new ModelAndView();
        }
        if (exception instanceof ResponseException) {
            this.writeResponse(httpServletResponse, (ResponseException)exception);
            return new ModelAndView();
        }
        if (exception instanceof PermissionDeniedException) {
            return new ModelAndView("forward:/error?key=permissionDenied");
        }
        if (exception instanceof EntityNotFoundException) {
            return new ModelAndView("forward:/error?key=notFound");
        }
        if (exception instanceof IllegalActionException) {
            return new ModelAndView("forward:/error?key=illegalAction");
        }
        if (exception instanceof ValidationException) {
            return new ModelAndView("forward:/error?key=validation");
        }
        if (exception instanceof LoggedOutException) {
            return new ModelAndView("forward:/error?key=sessionExpired");
        }
        if (exception.getClass().getSimpleName().equals("ClientAbortException")) {
            return null;
        }
        return new ModelAndView("forward:/error?key=general");
    }

    private void writeResponse(HttpServletResponse httpServletResponse, ResponseException responseException) {
        try {
            ServletHelper.writeResponse(httpServletResponse, responseException.getResponse());
        }
        catch (IOException | ServletException throwable) {
            throwable.printStackTrace();
        }
    }

    private void writeUploadFailure(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, MaxUploadSizeExceededException maxUploadSizeExceededException) {
        try {
            ServletHelper.writeJsonErrorToResponse(httpServletRequest, httpServletResponse, (Throwable)maxUploadSizeExceededException);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

