/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers;

import com.google.common.util.concurrent.Striped;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.Lock;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.server.utils.IOHelper;
import org.cyclos.utils.ContentType;
import org.cyclos.web.utils.RequestHelper;
import org.cyclos.web.utils.ServletHelper;

public abstract class StaticFileCompressingContentResolver {
    private static Striped<Lock> LOCKS = Striped.lock((int)16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Lock lock;
        boolean bl;
        File file = this.resolveOriginalFile();
        if (!file.exists() || !file.isFile()) {
            httpServletResponse.sendError(404);
        }
        File file2 = this.resolveGZipFile(file);
        if (this.useCache(file) && httpServletResponse.getHeader("Cache-Control") == null) {
            ServletHelper.setUseCache(httpServletResponse);
        }
        long l = file.lastModified();
        boolean bl2 = bl = !file2.exists() || l > file2.lastModified();
        if (bl) {
            lock = (Lock)LOCKS.get((Object)file.getAbsolutePath());
            lock.lock();
            try {
                file2.getParentFile().mkdirs();
                IOHelper.copyAndClose((InputStream)new FileInputStream(file), (OutputStream)new GZIPOutputStream((OutputStream)new FileOutputStream(file2), 8192));
                if (file2.length() >= 9L) {
                    file2.setLastModified(l);
                } else {
                    file2.delete();
                }
            }
            finally {
                lock.unlock();
            }
        }
        if (bl || RequestHelper.wasModified(httpServletRequest, file.lastModified())) {
            lock = this.resolveContentType(file);
            ServletHelper.writeFileContents(httpServletRequest, httpServletResponse, (ContentType)lock, file, file2, null);
        } else {
            httpServletResponse.setStatus(304);
        }
    }

    protected ContentType resolveContentType(File file) throws IOException {
        return ContentType.getByFileName((String)file.getName());
    }

    protected abstract File resolveGZipFile(File var1);

    protected abstract File resolveOriginalFile() throws IOException;

    protected boolean useCache(File file) {
        return true;
    }
}

