/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers.banking;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.banking.transactions.InstallmentOverviewQuery;
import org.cyclos.model.banking.transactions.InstallmentQuery;
import org.cyclos.model.banking.transactions.TransactionOverviewQuery;
import org.cyclos.model.banking.transactions.TransactionQuery;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.services.banking.TransactionService;
import org.cyclos.web.controllers.BaseController;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class TransactionsController
extends BaseController {
    @Autowired
    private TransactionService transactionService;

    @PostMapping(value={"/content/transactions/exportInstallments/{format:.*}"})
    public void exportInstallments(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="format") String string, @RequestParam(value="query") String string2) throws IOException {
        InstallmentQuery installmentQuery = (InstallmentQuery)this.jsonConverter.readValue(string2, InstallmentQuery.class);
        ExportFormatVO exportFormatVO = new ExportFormatVO(ExportFormatVO.INTERNAL_NAME, (Object)string);
        FileInfo fileInfo = this.transactionService.exportInstallments(exportFormatVO, installmentQuery);
        ServletHelper.writeFileContent(httpServletRequest, httpServletResponse, fileInfo);
    }

    @PostMapping(value={"/content/transactions/exportInstallmentsOverview/{format:.*}"})
    public void exportInstallmentsOverview(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="format") String string, @RequestParam(value="query") String string2) throws IOException {
        InstallmentOverviewQuery installmentOverviewQuery = (InstallmentOverviewQuery)this.jsonConverter.readValue(string2, InstallmentOverviewQuery.class);
        ExportFormatVO exportFormatVO = new ExportFormatVO(ExportFormatVO.INTERNAL_NAME, (Object)string);
        FileInfo fileInfo = this.transactionService.exportInstallmentsOverview(exportFormatVO, installmentOverviewQuery);
        ServletHelper.writeFileContent(httpServletRequest, httpServletResponse, fileInfo);
    }

    @PostMapping(value={"/content/transactions/exportOverview/{format:.*}"})
    public void exportOverview(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="format") String string, @RequestParam(value="query") String string2) throws IOException {
        TransactionOverviewQuery transactionOverviewQuery = (TransactionOverviewQuery)this.jsonConverter.readValue(string2, TransactionOverviewQuery.class);
        ExportFormatVO exportFormatVO = new ExportFormatVO(ExportFormatVO.INTERNAL_NAME, (Object)string);
        FileInfo fileInfo = this.transactionService.exportOverview(exportFormatVO, transactionOverviewQuery);
        ServletHelper.writeFileContent(httpServletRequest, httpServletResponse, fileInfo);
    }

    @PostMapping(value={"/content/transactions/export/{id}/{format:.*}"})
    public void exportTransaction(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="id") Long l, @PathVariable(value="format") String string) throws IOException {
        TransactionVO transactionVO = new TransactionVO(l);
        ExportFormatVO exportFormatVO = new ExportFormatVO(ExportFormatVO.INTERNAL_NAME, (Object)string);
        FileInfo fileInfo = this.transactionService.exportTransaction(exportFormatVO, transactionVO);
        ServletHelper.writeFileContent(httpServletRequest, httpServletResponse, fileInfo);
    }

    @PostMapping(value={"/content/transactions/exportTransactions/{format:.*}"})
    public void exportTransactions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="format") String string, @RequestParam(value="query") String string2) throws IOException {
        TransactionQuery transactionQuery = (TransactionQuery)this.jsonConverter.readValue(string2, TransactionQuery.class);
        ExportFormatVO exportFormatVO = new ExportFormatVO(ExportFormatVO.INTERNAL_NAME, (Object)string);
        FileInfo fileInfo = this.transactionService.exportTransactions(exportFormatVO, transactionQuery);
        ServletHelper.writeFileContent(httpServletRequest, httpServletResponse, fileInfo);
    }
}

