/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers.banking;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.banking.vouchertemplates.NewVoucherTemplateImageParams;
import org.cyclos.model.banking.vouchertemplates.VoucherTemplateDTO;
import org.cyclos.model.banking.vouchertemplates.VoucherTemplateImageVO;
import org.cyclos.model.banking.vouchertypes.VoucherTypeVO;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.server.utils.IOHelper;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.server.utils.ServerImageHelper;
import org.cyclos.services.banking.VoucherTemplateImageService;
import org.cyclos.services.banking.VoucherTemplateService;
import org.cyclos.services.system.InternalImageService;
import org.cyclos.utils.ContentType;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.controllers.BaseController;
import org.cyclos.web.controllers.InlineCacheableContentResolver;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class VoucherTemplatesController
extends BaseController {
    private static final int THUMBNAIL_JPEG_QUALITY = 100;
    @Autowired
    private VoucherTemplateService voucherTemplateService;
    @Autowired
    private VoucherTemplateImageService voucherTemplateImageService;
    @Autowired
    private InternalImageService internalImageService;
    @Autowired
    private JsonConverter jsonConverter;

    @PostMapping(value={"/content/voucherTemplates/html"})
    public void exportHTML(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(value="dto") String string) throws IOException {
        VoucherTemplateDTO voucherTemplateDTO = (VoucherTemplateDTO)this.jsonConverter.readValue(string, VoucherTemplateDTO.class);
        FileInfo fileInfo = this.voucherTemplateService.exportHTML(voucherTemplateDTO);
        ServletHelper.writeFileContent(httpServletRequest, httpServletResponse, fileInfo);
    }

    @PostMapping(value={"/content/voucherTemplates/export/{id:.*}"})
    public void exportTemplate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="id") Long l) throws IOException {
        FileInfo fileInfo = this.voucherTemplateService.exportTemplate(l);
        ServletHelper.writeFileContent(httpServletRequest, httpServletResponse, fileInfo);
    }

    @GetMapping(value={"/content/voucherTemplates/{id}/image"})
    public void getImageContents(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="id") Long l, @RequestParam(value="name") String string, @RequestParam(name="width", required=false) Integer n, @RequestParam(name="height", required=false) Integer n2) throws IOException {
        ServletHelper.forceGuest(httpServletRequest);
        VoucherTemplateImageVO voucherTemplateImageVO = this.voucherTemplateImageService.getImageVO(l, string);
        try {
            new ImageContentResolver(l, voucherTemplateImageVO, n, n2).write(httpServletRequest, httpServletResponse);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    @PostMapping(value={"/content/voucherTemplates/import"})
    public void importTemplate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(value="file") MultipartFile multipartFile) throws IOException {
        try {
            Long l = this.voucherTemplateService.importTemplate(new SerializableInputStream(multipartFile.getInputStream()));
            ServletHelper.writeUploadSuccess(httpServletRequest, httpServletResponse, "id", l);
        }
        catch (Exception exception) {
            ServletHelper.writeJsonErrorToResponse(httpServletRequest, httpServletResponse, exception);
        }
    }

    @PostMapping(value={"/content/voucherTemplates/preview"})
    public void preview(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(value="type") Long l, @RequestParam(value="dto") String string) throws IOException {
        VoucherTemplateDTO voucherTemplateDTO = (VoucherTemplateDTO)this.jsonConverter.readValue(string, VoucherTemplateDTO.class);
        FileInfo fileInfo = new FileInfo();
        fileInfo.setContentType(ContentType.PDF.getMimeType());
        fileInfo.setName("preview.pdf");
        fileInfo.setContent(this.voucherTemplateService.preview(new VoucherTypeVO(l), voucherTemplateDTO));
        ServletHelper.writeFileContent(httpServletRequest, httpServletResponse, fileInfo);
    }

    @PostMapping(value={"/content/voucherTemplates/{id}/image"})
    public void saveImage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(value="file") MultipartFile multipartFile, @PathVariable(value="id") Long l, @RequestParam(name="name", required=false) String string) throws Exception {
        ServerImageHelper.ImageType imageType;
        if (StringHelper.isBlank((Object)string)) {
            string = multipartFile.getOriginalFilename();
        }
        try {
            imageType = ServerImageHelper.ImageType.getByContentType((String)multipartFile.getContentType());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ServletHelper.writeJsonErrorToResponse(httpServletRequest, httpServletResponse, illegalArgumentException);
            return;
        }
        NewVoucherTemplateImageParams newVoucherTemplateImageParams = new NewVoucherTemplateImageParams();
        newVoucherTemplateImageParams.setVoucherTemplateId(l);
        ImageVO imageVO = this.voucherTemplateImageService.save((Object)newVoucherTemplateImageParams, string, new SerializableInputStream(multipartFile.getInputStream()), imageType.getContentType());
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("id", imageVO.getId());
        ServletHelper.writeUploadSuccess(httpServletRequest, httpServletResponse, hashMap);
    }

    private class ImageContentResolver
    extends InlineCacheableContentResolver {
        private Long voucherTemplateId;
        private VoucherTemplateImageVO image;
        private Integer width;
        private Integer height;

        public ImageContentResolver(Long l, VoucherTemplateImageVO voucherTemplateImageVO, Integer n, Integer n2) {
            this.voucherTemplateId = l;
            this.image = voucherTemplateImageVO;
            Dimension dimension = new Dimension(voucherTemplateImageVO.getWidth(), voucherTemplateImageVO.getHeight());
            Dimension dimension2 = ServerImageHelper.getActualSize((Dimension)dimension, (Integer)n, (Integer)n2);
            if (!dimension.equals(dimension2)) {
                this.width = (int)dimension2.getWidth();
                this.height = (int)dimension2.getHeight();
            }
        }

        @Override
        protected ContentType resolveContentType() throws IOException {
            return ContentType.getByMimeType((String)this.image.getContentType());
        }

        @Override
        protected File resolveFile() throws IOException {
            String string = this.hasResizeDimensions() ? "_" + this.width + "x" + this.height : "";
            return new File(VoucherTemplatesController.this.getTempDir("images/VOUCHER_TEMPLATE"), this.voucherTemplateId + "/" + this.image.getName() + string);
        }

        @Override
        protected Long resolveLastModification() throws IOException {
            String string = this.image.getLastModifiedInMillis();
            return StringHelper.isBlank((Object)string) ? null : Long.valueOf(string);
        }

        @Override
        protected void writeContent(File file) throws IOException {
            SerializableInputStream serializableInputStream = VoucherTemplatesController.this.internalImageService.readVoucherTemplateImage(this.voucherTemplateId, this.image.getName());
            IOHelper.copyAndClose((InputStream)serializableInputStream, (File)file);
            if (this.hasResizeDimensions()) {
                BufferedImage bufferedImage = ImageIO.read(file);
                bufferedImage = ServerImageHelper.resize((BufferedImage)bufferedImage, (int)this.width, (int)this.height);
                ServerImageHelper.write((BufferedImage)bufferedImage, (ServerImageHelper.ImageType)ServerImageHelper.ImageType.getByContentType((String)this.image.getContentType()), (File)file, (int)100);
            }
        }

        private boolean hasResizeDimensions() {
            return this.width != null;
        }
    }
}

