/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers.banking;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.banking.vouchers.BasicVoucherQuery;
import org.cyclos.model.banking.vouchers.VoucherTransactionVO;
import org.cyclos.model.banking.vouchers.VoucherVO;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.services.banking.VoucherService;
import org.cyclos.web.controllers.BaseController;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class VouchersController
extends BaseController {
    @Autowired
    private VoucherService voucherService;

    @PostMapping(value={"/content/vouchers/export/{id}/{format:.*}"})
    public void exportVoucher(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="id") Long l, @PathVariable(value="format") String string) throws IOException {
        ExportFormatVO exportFormatVO = new ExportFormatVO(ExportFormatVO.INTERNAL_NAME, (Object)string);
        FileInfo fileInfo = this.voucherService.exportVoucher(exportFormatVO, new VoucherVO(l), true);
        ServletHelper.writeFileContent(httpServletRequest, httpServletResponse, fileInfo);
    }

    @PostMapping(value={"/content/vouchers/exportSearch/{format:.*}"})
    public void exportVouchers(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="format") String string, @RequestParam(value="query") String string2, @RequestParam(name="markAsPrinted", required=false) boolean bl) throws IOException {
        ExportFormatVO exportFormatVO = new ExportFormatVO(ExportFormatVO.INTERNAL_NAME, (Object)string);
        BasicVoucherQuery basicVoucherQuery = (BasicVoucherQuery)this.jsonConverter.readValue(string2, BasicVoucherQuery.class);
        FileInfo fileInfo = this.voucherService.exportVouchers(exportFormatVO, basicVoucherQuery, bl);
        ServletHelper.writeFileContent(httpServletRequest, httpServletResponse, fileInfo);
    }

    @PostMapping(value={"/content/voucher-transactions/export/{id}/{format:.*}"})
    public void exportVoucherTransaction(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="id") Long l, @PathVariable(value="format") String string) throws IOException {
        ExportFormatVO exportFormatVO = new ExportFormatVO(ExportFormatVO.INTERNAL_NAME, (Object)string);
        FileInfo fileInfo = this.voucherService.exportTransaction(exportFormatVO, new VoucherTransactionVO(l));
        ServletHelper.writeFileContent(httpServletRequest, httpServletResponse, fileInfo);
    }
}

