/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers.contentmanagement;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.model.CSSCompileException;
import org.cyclos.model.contentmanagement.themes.ThemeVO;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.services.contentmanagement.ThemeService;
import org.cyclos.utils.ContentType;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.controllers.InlineCacheableContentResolver;

public class CSSContentResolver
extends InlineCacheableContentResolver {
    private static final Logger LOG = LogManager.getLogger(CSSContentResolver.class);
    private final CyclosProperties cyclosProperties;
    private final ThemeService themeService;
    private final ThemeVO theme;
    private final File tempDir;

    public CSSContentResolver(CyclosProperties cyclosProperties, ThemeService themeService, ThemeVO themeVO, File file) {
        this.cyclosProperties = cyclosProperties;
        this.themeService = themeService;
        this.theme = themeVO;
        this.tempDir = file;
        this.setLongCache(true);
    }

    @Override
    protected ContentType resolveContentType() throws IOException {
        return ContentType.CSS;
    }

    @Override
    protected File resolveFile() throws IOException {
        return new File(this.tempDir, this.theme.getId() + "_" + this.theme.getVersion() + ".css");
    }

    @Override
    protected Long resolveLastModification() throws IOException {
        if (this.cyclosProperties.isDevelopment()) {
            return null;
        }
        return StringHelper.isBlank((Object)this.theme.getLastModifiedInMillis()) ? null : Long.valueOf(this.theme.getLastModifiedInMillis());
    }

    @Override
    protected void writeContent(File file) throws IOException {
        Object object;
        try {
            object = this.themeService.getCSS(this.theme.getId());
        }
        catch (CSSCompileException cSSCompileException) {
            LOG.warn("Error generating the theme CSS for " + this.theme.getName(), (Throwable)cSSCompileException);
            object = this.themeService.getFallbackCSS(this.theme.getType()) + "\nbody::before {\ncontent: \"There was an error generating the default theme. Please, login as administrator and ajust the selected theme.\"\n}";
        }
        FileUtils.writeStringToFile((File)file, (String)object, (Charset)StandardCharsets.UTF_8);
    }
}

