/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers.contentmanagement;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.contentmanagement.documents.DocumentVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.RawFileVO;
import org.cyclos.model.utils.StoredFileVO;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.contentmanagement.DocumentService;
import org.cyclos.web.controllers.BaseController;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class DocumentsController
extends BaseController {
    @Autowired
    private DocumentService documentService;

    @GetMapping(value={"/document/{id}"})
    public void document(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="id") String string) throws EntityNotFoundException, IOException {
        this.download(httpServletRequest, httpServletResponse, string);
    }

    @RequestMapping(value={"/content/document/{id}"})
    public void download(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="id") String string) throws EntityNotFoundException, IOException {
        DocumentVO documentVO = (DocumentVO)ModelHelper.voFromString(DocumentVO.class, (String)string);
        RawFileVO rawFileVO = this.documentService.getDocumentFile(documentVO);
        ServletHelper.setHeaders(httpServletResponse, (StoredFileVO)rawFileVO, "POST".equalsIgnoreCase(httpServletRequest.getMethod()));
        ServletHelper.writeContents(httpServletResponse, (InputStream)this.documentService.readContent(documentVO));
    }

    @PostMapping(value={"/content/document"})
    public void upload(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(value="file") MultipartFile multipartFile, @RequestParam(value="ownerId") Long l) throws IOException {
        this.documentService.saveFile(new DocumentVO(l), multipartFile.getContentType(), multipartFile.getOriginalFilename(), new SerializableInputStream(multipartFile.getInputStream()));
        ServletHelper.writeUploadSuccess(httpServletRequest, httpServletResponse, null);
    }
}

