/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers.sitemap;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.CyclosVersion;
import org.cyclos.model.access.BasicInitializationData;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.server.model.contentmanagement.contentitems.SitemapData;
import org.cyclos.server.model.contentmanagement.contentitems.SitemapIndexData;
import org.cyclos.server.model.contentmanagement.contentitems.SitemapIndexItemVO;
import org.cyclos.server.model.contentmanagement.contentitems.SitemapItemContentVO;
import org.cyclos.server.model.contentmanagement.contentitems.SitemapItemType;
import org.cyclos.server.model.contentmanagement.contentitems.SitemapItemVO;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.ReservedUris;
import org.cyclos.services.contentmanagement.SitemapService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ContentType;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionHelper;
import org.cyclos.web.controllers.BaseController;
import org.cyclos.web.controllers.InlineCacheableContentResolver;
import org.cyclos.web.rest.helpers.ImagesApiHelper;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SitemapController
extends BaseController {
    private static final DecimalFormat PRIORITY_FORMAT = new DecimalFormat("0.0##", new DecimalFormatSymbols(Locale.US));
    @Autowired
    private SitemapService sitemapService;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private ImagesApiHelper imagesApiHelper;

    @GetMapping(value={"/content/sitemaps/home"})
    public ModelAndView homePageContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (this.cyclosProperties.isDisableSearchEnginesIndexing()) {
            httpServletResponse.sendError(404);
            return null;
        }
        SitemapItemContentVO sitemapItemContentVO = this.sitemapService.getContent(SitemapItemType.HOME_PAGE, null);
        return this.contentModelAndView(sitemapItemContentVO);
    }

    @GetMapping(value={"/content/sitemaps/marketplace/{id:.*}"})
    public ModelAndView marketplaceContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="id") Long l) throws IOException {
        if (this.cyclosProperties.isDisableSearchEnginesIndexing()) {
            httpServletResponse.sendError(404);
            return null;
        }
        SitemapItemContentVO sitemapItemContentVO = this.sitemapService.getContent(SitemapItemType.AD, l);
        return this.contentModelAndView(sitemapItemContentVO);
    }

    @GetMapping(value={"/content/sitemaps/menu-item/{id:.*}"})
    public ModelAndView menuItemContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="id") Long l) throws IOException {
        if (this.cyclosProperties.isDisableSearchEnginesIndexing()) {
            httpServletResponse.sendError(404);
            return null;
        }
        SitemapItemContentVO sitemapItemContentVO = this.sitemapService.getContent(SitemapItemType.MENU_ITEM, l);
        return this.contentModelAndView(sitemapItemContentVO);
    }

    @GetMapping(value={"/robots.txt"})
    public void robots(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (!this.isRoot()) {
            httpServletResponse.sendError(404);
            return;
        }
        new RobotsContentResolver().write(httpServletRequest, httpServletResponse);
    }

    @GetMapping(value={"/sitemap.xml"})
    public void sitemap(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (this.cyclosProperties.isDisableSearchEnginesIndexing()) {
            httpServletResponse.sendError(404);
            return;
        }
        new SitemapContentResolver().write(httpServletRequest, httpServletResponse);
    }

    @GetMapping(value={"/sitemap-index.xml"})
    public void sitemapIndex(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (!this.isRoot() || this.cyclosProperties.isDisableSearchEnginesIndexing()) {
            httpServletResponse.sendError(404);
            return;
        }
        new SitemapIndexContentResolver().write(httpServletRequest, httpServletResponse);
    }

    @GetMapping(value={"/sitemap.xstl"})
    public ModelAndView style(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        URI uRI;
        if (this.cyclosProperties.isDisableSearchEnginesIndexing()) {
            httpServletResponse.sendError(404);
            return null;
        }
        RequestData requestData = ServletHelper.getRequestData();
        try {
            uRI = new URI(StringHelper.removeEnd((String)requestData.getRootUrl(), (String)"/") + "/sitemap-index.xml");
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException(uRISyntaxException);
        }
        BasicInitializationData basicInitializationData = this.initializationService.getBasicInitializationData();
        String string = this.imagesApiHelper.imageURL((ImageVO)basicInitializationData.getShortcutIcon());
        return new ModelAndView("sitemap-style").addObject("cyclosVersion", (Object)CyclosVersion.get()).addObject("cyclosCommitId", (Object)CyclosVersion.getCommitId()).addObject("resourceCacheKey", (Object)basicInitializationData.getResourceCacheKey()).addObject("initializationData", (Object)basicInitializationData).addObject("shortcutIconUrl", (Object)string).addObject("indexUrl", (Object)uRI.toString());
    }

    private ModelAndView contentModelAndView(SitemapItemContentVO sitemapItemContentVO) {
        Instant instant;
        RequestData requestData = ServletHelper.getRequestData();
        String string = this.resolvePrefix(requestData, requestData.getNetworkInternalName());
        Long l = (Long)CoercionHelper.coerce(Long.class, (Object)sitemapItemContentVO.getLastModifiedMillis());
        String string2 = null;
        if (l != null) {
            instant = Instant.ofEpochMilli(l);
            string2 = DateTimeFormatter.ISO_INSTANT.format(instant);
        }
        instant = this.initializationService.getBasicInitializationData();
        String string3 = this.imagesApiHelper.imageURL((ImageVO)instant.getShortcutIcon());
        return new ModelAndView("sitemap-item").addObject("item", (Object)sitemapItemContentVO).addObject("lastModified", (Object)string2).addObject("urlPrefix", (Object)("/" + string)).addObject("license", (Object)instant.getLicense()).addObject("cyclosVersion", (Object)CyclosVersion.get()).addObject("cyclosCommitId", (Object)CyclosVersion.getCommitId()).addObject("resourceCacheKey", (Object)instant.getResourceCacheKey()).addObject("reservedUris", (Object)ReservedUris.internal()).addObject("initializationData", (Object)instant).addObject("shortcutIconUrl", (Object)string3);
    }

    private File getTempDir(String string, String string2) {
        RequestData requestData = ServletHelper.getRequestData();
        String string3 = requestData.getBaseUrl();
        string3 = StringUtils.replaceChars((String)string3, (String)":/.", (String)"___");
        return new File(this.getTempDir("sitemap"), string + "_" + string3 + "." + string2);
    }

    private boolean isRoot() {
        RequestData requestData = ServletHelper.getRequestData();
        return StringHelper.isBlank((Object)requestData.getConsumedPath());
    }

    private String resolvePrefix(RequestData requestData, String string) {
        String string2 = (String)ObjectHelper.defaultValue((Object)string, (Object)"global");
        Object object = "";
        if (!requestData.isCustomUrl()) {
            object = string2;
        }
        List list = StringHelper.splitTrimming((String)StringUtils.strip((String)((String)ObjectHelper.defaultValue((Object)requestData.getConsumedPath(), (Object)""))), (String)"/");
        if (StringHelper.isNotBlank((Object)string2) && string2.equals(CollectionHelper.first((Iterable)list))) {
            list.remove(0);
        }
        if (!list.isEmpty()) {
            object = StringHelper.removeEnd((String)object, (String)"/") + "/" + StringHelper.join((Collection)list, (String)"/");
        }
        return object;
    }

    private void writeFooter(PrintWriter printWriter, String string) {
        printWriter.println("</" + string + ">");
    }

    private void writeHeader(PrintWriter printWriter, String string, String string2) {
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        String string3 = StringHelper.removeEnd((String)string, (String)"/") + "/sitemap.xstl";
        printWriter.println("<?xml-stylesheet type=\"text/xsl\" href=\"" + string3 + "\"?>");
        printWriter.println("<!-- Generated by Cyclos " + CyclosVersion.get() + " -->");
        printWriter.println("<" + string2);
        printWriter.println("    xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\"");
        printWriter.println("    xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\">");
    }

    private class RobotsContentResolver
    extends InlineCacheableContentResolver {
        private File file;
        private RequestData requestData = ServletHelper.getRequestData();

        public RobotsContentResolver() {
            this.file = SitemapController.this.getTempDir("robots", "txt");
        }

        @Override
        protected ContentType resolveContentType() throws IOException {
            return ContentType.TEXT;
        }

        @Override
        protected File resolveFile() throws IOException {
            return this.file;
        }

        @Override
        protected File resolveGZipFile(File file) {
            return null;
        }

        @Override
        protected Long resolveLastModification() throws IOException {
            if (this.file == null || !this.file.exists()) {
                return null;
            }
            long l = this.file.lastModified();
            long l2 = System.currentTimeMillis();
            return l2 - l < 3600000L ? l : l2;
        }

        @Override
        protected void writeContent(File file) throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            if (SitemapController.this.cyclosProperties.isDisableSearchEnginesIndexing()) {
                stringBuilder.append("User-agent: *\n");
                stringBuilder.append("Disallow: /\n");
            } else {
                stringBuilder.append("Sitemap: ").append(StringHelper.removeEnd((String)this.requestData.getBaseUrl(), (String)"/") + "/sitemap-index.xml");
            }
            FileUtils.write((File)file, (CharSequence)stringBuilder, (Charset)StandardCharsets.UTF_8);
        }
    }

    private class SitemapContentResolver
    extends InlineCacheableContentResolver {
        private RequestData requestData = ServletHelper.getRequestData();

        @Override
        protected ContentType resolveContentType() throws IOException {
            return ContentType.XML;
        }

        @Override
        protected File resolveFile() throws IOException {
            return SitemapController.this.getTempDir("sitemap", "xml");
        }

        @Override
        protected Long resolveLastModification() throws IOException {
            String string = SitemapController.this.sitemapService.getLastModifiedInMillis();
            return string == null ? null : Long.valueOf(Long.parseLong(string));
        }

        @Override
        protected void writeContent(File file) throws IOException {
            try (PrintWriter printWriter = new PrintWriter(file, StandardCharsets.UTF_8);){
                String string = "urlset";
                SitemapController.this.writeHeader(printWriter, this.requestData.getBaseUrl(), string);
                SitemapData sitemapData = SitemapController.this.sitemapService.getSitemapData();
                for (SitemapItemVO sitemapItemVO : sitemapData.getItems()) {
                    String string2 = this.resolvePath(sitemapData, sitemapItemVO);
                    this.writeUrl(printWriter, this.requestData.getBaseUrl(), string2, sitemapData.getConfigurationId(), sitemapItemVO.getLastModifiedMillis(), sitemapItemVO.getType(), sitemapItemVO.getImageKey());
                }
                SitemapController.this.writeFooter(printWriter, string);
            }
        }

        private String resolvePath(SitemapData sitemapData, SitemapItemVO sitemapItemVO) {
            Object object = "/content/sitemaps/";
            SitemapItemType sitemapItemType = sitemapItemVO.getType();
            switch (sitemapItemType) {
                case HOME_PAGE: {
                    object = (String)object + "home";
                    break;
                }
                case MENU_ITEM: {
                    object = (String)object + "menu-item/" + sitemapItemVO.getId();
                    break;
                }
                case AD: {
                    object = (String)object + "marketplace/" + sitemapItemVO.getId();
                }
            }
            return StringHelper.removeStart((String)object, (String)"/");
        }

        private void writeUrl(PrintWriter printWriter, String string, String string2, Long l, String string3, SitemapItemType sitemapItemType, String string4) throws IOException {
            Object object;
            String string5 = StringHelper.removeEnd((String)string, (String)"/") + "/" + string2;
            Object object2 = null;
            switch (sitemapItemType) {
                case HOME_PAGE: {
                    object2 = "currentConfiguration/SYSTEM_LOGO?id=" + l;
                    break;
                }
                case AD: {
                    if (!StringHelper.isNotBlank((Object)string4)) break;
                    object2 = string4;
                    break;
                }
            }
            printWriter.println("    <url>");
            printWriter.println("        <loc>" + string5 + "</loc>");
            if (string3 != null) {
                object = Instant.ofEpochMilli(Long.parseLong(string3));
                printWriter.println("        <lastmod>" + DateTimeFormatter.ISO_INSTANT.format((TemporalAccessor)object) + "</lastmod>");
            }
            printWriter.println("        <priority>" + PRIORITY_FORMAT.format(sitemapItemType.priority()) + "</priority>");
            if (object2 != null) {
                object = StringHelper.removeEnd((String)string, (String)"/") + "/content/images/" + (String)object2;
                printWriter.print("        <image:image>" + (String)object + "</image:image>");
            }
            printWriter.println("    </url>");
        }
    }

    private class SitemapIndexContentResolver
    extends InlineCacheableContentResolver {
        private File file;
        private RequestData requestData = ServletHelper.getRequestData();

        public SitemapIndexContentResolver() {
            this.file = SitemapController.this.getTempDir("sitemap-index", "xml");
        }

        @Override
        protected ContentType resolveContentType() throws IOException {
            return ContentType.XML;
        }

        @Override
        protected File resolveFile() throws IOException {
            return this.file;
        }

        @Override
        protected Long resolveLastModification() throws IOException {
            if (this.file == null || !this.file.exists()) {
                return null;
            }
            long l = this.file.lastModified();
            long l2 = System.currentTimeMillis();
            return l2 - l < 3600000L ? l : l2;
        }

        @Override
        protected void writeContent(File file) throws IOException {
            try (PrintWriter printWriter = new PrintWriter(file, StandardCharsets.UTF_8);){
                String string = "sitemapindex";
                SitemapController.this.writeHeader(printWriter, this.requestData.getBaseUrl(), string);
                SitemapIndexData sitemapIndexData = SitemapController.this.sitemapService.getIndexData();
                for (SitemapIndexItemVO sitemapIndexItemVO : sitemapIndexData.getItems()) {
                    String string2 = this.resolvePath(sitemapIndexData, sitemapIndexItemVO);
                    this.writeItem(printWriter, this.requestData.getBaseUrl(), string2, sitemapIndexItemVO.getLastModifiedMillis());
                }
                SitemapController.this.writeFooter(printWriter, string);
            }
        }

        private String resolvePath(SitemapIndexData sitemapIndexData, SitemapIndexItemVO sitemapIndexItemVO) {
            Object object = SitemapController.this.resolvePrefix(this.requestData, sitemapIndexItemVO.getNetworkInternalName());
            if (StringHelper.isNotBlank((Object)sitemapIndexItemVO.getConfigurationPath())) {
                object = (String)object + "/" + sitemapIndexItemVO.getConfigurationPath();
            }
            object = (String)object + "/sitemap.xml";
            return StringHelper.removeStart((String)object, (String)"/");
        }

        private void writeItem(PrintWriter printWriter, String string, String string2, String string3) throws IOException {
            String string4 = StringHelper.removeEnd((String)string, (String)"/") + "/" + string2;
            printWriter.println("    <sitemap>");
            printWriter.println("        <loc>" + string4 + "</loc>");
            if (string3 != null) {
                Instant instant = Instant.ofEpochMilli(Long.parseLong(string3));
                printWriter.println("        <lastmod>" + DateTimeFormatter.ISO_INSTANT.format(instant) + "</lastmod>");
            }
            printWriter.println("    </sitemap>");
        }
    }
}

