/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers.system;

import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.CyclosException;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.system.operations.RunCustomOperationDTO;
import org.cyclos.model.system.operations.RunCustomOperationResult;
import org.cyclos.model.system.operations.RunExternalRedirectCallbackParams;
import org.cyclos.services.system.CustomOperationService;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.controllers.BaseController;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class CustomOperationsController
extends BaseController {
    @Autowired
    private CustomOperationService customOperationService;

    @RequestMapping(value={"/external-redirect-callback/{id:.*}"})
    public ModelAndView externalRedirectCallback(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="id") Long l) throws Exception {
        return this.externalRedirectCallback(httpServletRequest, httpServletResponse, l, null);
    }

    @RequestMapping(value={"/external-redirect-callback/{id}/{token:.*}"})
    public ModelAndView externalRedirectCallback(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="id") Long l, @PathVariable(value="token") String string) throws Exception {
        RequestData requestData = ServletHelper.getRequestData();
        RunExternalRedirectCallbackParams runExternalRedirectCallbackParams = new RunExternalRedirectCallbackParams();
        runExternalRedirectCallbackParams.setId(l);
        runExternalRedirectCallbackParams.setToken(string);
        runExternalRedirectCallbackParams.setRequest(requestData.getRequestInfo());
        RunCustomOperationResult runCustomOperationResult = this.customOperationService.runExternalRedirectCallback(runExternalRedirectCallbackParams);
        String string2 = runCustomOperationResult.getNotification();
        string2 = StringHelper.convertNewLineToBr((String)string2);
        string2 = StringHelper.trim((Object)string2);
        return this.sendNotification(runCustomOperationResult.getNotificationLevel(), string2, false);
    }

    @PostMapping(value={"/content/customOperations/run"})
    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(value="params") String string, @RequestParam(name="file", required=false) MultipartFile multipartFile) throws Exception {
        try {
            RunCustomOperationDTO runCustomOperationDTO = (RunCustomOperationDTO)this.jsonConverter.readValue(string, RunCustomOperationDTO.class);
            runCustomOperationDTO.setFileUpload(ServletHelper.toFileInfo(multipartFile));
            RunCustomOperationResult runCustomOperationResult = this.customOperationService.run(runCustomOperationDTO);
            if (runCustomOperationResult.getFileDownload() != null) {
                ServletHelper.writeFileContent(httpServletRequest, httpServletResponse, runCustomOperationResult.getFileDownload());
            } else {
                ServletHelper.writeUploadSuccess(httpServletRequest, httpServletResponse, Collections.singletonMap("result", runCustomOperationResult));
            }
        }
        catch (CyclosException cyclosException) {
            ServletHelper.writeJsonErrorToResponse(httpServletRequest, httpServletResponse, cyclosException);
        }
    }
}

