/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers.system;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.wizards.CustomWizardVO;
import org.cyclos.model.system.wizards.RunExternalRedirectCallbackParams;
import org.cyclos.model.system.wizards.StartCustomWizardParams;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.NotificationLevel;
import org.cyclos.services.system.CustomWizardService;
import org.cyclos.web.controllers.BaseController;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class CustomWizardsController
extends BaseController {
    @Autowired
    private CustomWizardService customWizardService;

    @RequestMapping(value={"/wizard-external-callback/{key:.*}"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView externalRedirectCallback(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="key") String string) throws Exception {
        RequestData requestData = ServletHelper.getRequestData();
        RunExternalRedirectCallbackParams runExternalRedirectCallbackParams = new RunExternalRedirectCallbackParams();
        runExternalRedirectCallbackParams.setKey(string);
        runExternalRedirectCallbackParams.setRequest(requestData.getRequestInfo());
        try {
            this.customWizardService.runExternalRedirectCallback(runExternalRedirectCallbackParams);
            httpServletResponse.sendRedirect(requestData.getBaseUrl() + "#system.wizards.run!key=" + string);
            return null;
        }
        catch (ValidationException validationException) {
            return this.sendValidationError(validationException);
        }
        catch (Exception exception) {
            return this.sendNotification(NotificationLevel.ERROR, this.message(GeneralKeys.Errors.GENERAL, new Object[0]), false);
        }
    }

    @RequestMapping(value={"/start/{internalNameOrId:.*}"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView start(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="internalNameOrId") String string) throws Exception {
        StartCustomWizardParams startCustomWizardParams = new StartCustomWizardParams();
        startCustomWizardParams.setWizard((CustomWizardVO)ModelHelper.voFromString(CustomWizardVO.class, (String)string));
        RequestData requestData = ServletHelper.getRequestData();
        try {
            String string2 = this.customWizardService.start(startCustomWizardParams).getKey();
            httpServletResponse.sendRedirect(requestData.getBaseUrl() + "#system.wizards.run!key=" + string2);
            return null;
        }
        catch (ValidationException validationException) {
            return this.sendValidationError(validationException);
        }
        catch (Exception exception) {
            return this.sendNotification(NotificationLevel.ERROR, this.message(GeneralKeys.Errors.GENERAL, new Object[0]), false);
        }
    }
}

