/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers.users;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.InvalidSessionDataException;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.users.UserQuery;
import org.cyclos.model.users.users.UserValidationResult;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.NotificationLevel;
import org.cyclos.services.users.BasicUserService;
import org.cyclos.services.users.UserService;
import org.cyclos.utils.MessageProducer;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.controllers.BaseController;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class UsersController
extends BaseController {
    @Autowired
    private UserService userService;
    @Autowired
    private BasicUserService basicUserService;

    @PostMapping(value={"/content/users/export/{format:.*}"})
    public void exportUsers(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="format") String string, @RequestParam(value="userQuery") String string2) throws IOException {
        ExportFormatVO exportFormatVO = new ExportFormatVO(ExportFormatVO.INTERNAL_NAME, (Object)string);
        UserQuery userQuery = (UserQuery)this.jsonConverter.readValue(string2, UserQuery.class);
        FileInfo fileInfo = this.userService.exportUsers(exportFormatVO, userQuery);
        ServletHelper.writeFileContent(httpServletRequest, httpServletResponse, fileInfo);
    }

    @GetMapping(value={"/content/users/validateEmailChange"})
    public ModelAndView validateEmailChange(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(name="key", required=false) String string, @RequestParam(name="validationKey", required=false) String string2) throws IOException {
        if (StringHelper.isBlank((Object)string)) {
            string = string2;
        }
        if (StringHelper.isBlank((Object)string)) {
            ValidationException validationException = new ValidationException("Missing parameter: 'key'");
            return this.sendValidationError(validationException);
        }
        try {
            this.basicUserService.validateEmailChange(string);
            return this.sendNotification(NotificationLevel.INFORMATION, this.message(UsersKeys.Users.EMAIL_CHANGED, new Object[0]), false);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            httpServletResponse.sendError(404);
            return null;
        }
        catch (InvalidSessionDataException invalidSessionDataException) {
            ServletHelper.setSessionToken(httpServletRequest, httpServletResponse, null);
            return this.validateEmailChange(httpServletRequest, httpServletResponse, string, string);
        }
        catch (ValidationException validationException) {
            return this.sendValidationError(validationException);
        }
    }

    @GetMapping(value={"/content/users/validateRegistration"})
    public ModelAndView validateRegistration(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(name="key", required=false) String string, @RequestParam(name="validationKey", required=false) String string2) {
        if (StringHelper.isBlank((Object)string)) {
            string = string2;
        }
        if (StringHelper.isBlank((Object)string)) {
            ValidationException validationException = new ValidationException("Missing parameter: 'key'");
            return this.sendValidationError(validationException);
        }
        try {
            UserValidationResult userValidationResult = this.basicUserService.validateRegistration(string);
            return this.sendNotification(NotificationLevel.INFORMATION, ModelHelper.getEmailValidationMesssage((UserValidationResult)userValidationResult, (MessageProducer)this), false);
        }
        catch (ValidationException validationException) {
            return this.sendValidationError(validationException);
        }
        catch (InvalidSessionDataException invalidSessionDataException) {
            ServletHelper.setSessionToken(httpServletRequest, httpServletResponse, null);
            return this.validateRegistration(httpServletRequest, httpServletResponse, string, string);
        }
    }
}

