/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.filters;

import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.web.utils.GzipResponse;
import org.cyclos.web.utils.RequestHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component(value="wsGZipFilter")
public class WebServicesGzipFilter
extends OncePerRequestFilter {
    public static final String BEAN_NAME = "wsGZipFilter";
    public static final int IGNORE_GZIP_BELOW_BYTES = 4096;
    @Autowired
    private CyclosProperties cyclosProperties;
    private ObjectPool<byte[]> pool;

    @PostConstruct
    public void initialize() {
        BasePooledObjectFactory<byte[]> basePooledObjectFactory = new BasePooledObjectFactory<byte[]>(){

            public byte[] create() throws Exception {
                return new byte[4096];
            }

            public PooledObject<byte[]> wrap(byte[] byArray) {
                return new DefaultPooledObject((Object)byArray);
            }
        };
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        genericObjectPoolConfig.setJmxEnabled(false);
        genericObjectPoolConfig.setMaxTotal(1000);
        genericObjectPoolConfig.setMinIdle(10);
        genericObjectPoolConfig.setMaxIdle(50);
        this.pool = new GenericObjectPool((PooledObjectFactory)basePooledObjectFactory, genericObjectPoolConfig);
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (this.cyclosProperties.isWebServicesGzip() && RequestHelper.acceptsGzip(httpServletRequest)) {
            GzipResponse gzipResponse = new GzipResponse(httpServletResponse, this.pool);
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)gzipResponse);
            gzipResponse.finish();
            return;
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }
}

