/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import java.util.Set;
import org.cyclos.model.banking.accounts.UserAccountVisibilitySettingsData;
import org.cyclos.model.banking.accounttypes.UserAccountTypeVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.services.banking.UserAccountVisibilitySettingsService;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.helpers.AccountVisibilityApiHelper;
import org.cyclos.web.rest.model.DataForUserAccountVisibility;
import org.cyclos.web.rest.model.SaveUserAccountVisibilityAsVisibleParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class AccountVisibilityApiImpl
extends BaseApiImpl {
    @Autowired
    private UserAccountVisibilitySettingsService userAccountVisibilitySettingsService;
    @Autowired
    private AccountVisibilityApiHelper accountVisibilityApiHelper;

    public ResponseEntity<DataForUserAccountVisibility> getUserAccountVisibilityData(String string, List<String> list) {
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
        UserAccountVisibilitySettingsData userAccountVisibilitySettingsData = this.userAccountVisibilitySettingsService.getData(userLocatorVO);
        DataForUserAccountVisibility dataForUserAccountVisibility = this.accountVisibilityApiHelper.toDataForUserAccountVisibility(userAccountVisibilitySettingsData);
        return this.ok(dataForUserAccountVisibility);
    }

    public ResponseEntity<Void> saveUserAccountVisibility(String string, SaveUserAccountVisibilityAsVisibleParams saveUserAccountVisibilityAsVisibleParams) {
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
        Set<UserAccountTypeVO> set = this.accountVisibilityApiHelper.toAccountTypes(saveUserAccountVisibilityAsVisibleParams);
        this.userAccountVisibilitySettingsService.save(userLocatorVO, set);
        return this.okOrNoContent(null);
    }

    public ResponseEntity<Void> setUserAccountVisibilityAsHidden(String string, String string2) {
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
        UserAccountTypeVO userAccountTypeVO = (UserAccountTypeVO)ModelHelper.voFromString(UserAccountTypeVO.class, (String)string2);
        this.userAccountVisibilitySettingsService.setAsVisible(userLocatorVO, userAccountTypeVO, false);
        return this.okOrNoContent(null);
    }

    public ResponseEntity<Void> setUserAccountVisibilityAsVisible(String string, String string2) {
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
        UserAccountTypeVO userAccountTypeVO = (UserAccountTypeVO)ModelHelper.voFromString(UserAccountTypeVO.class, (String)string2);
        this.userAccountVisibilitySettingsService.setAsVisible(userLocatorVO, userAccountTypeVO, true);
        return this.okOrNoContent(null);
    }
}

