/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.utils.DateTime;
import org.cyclos.web.rest.api.AccountsApiImpl;
import org.cyclos.web.rest.model.AccountBalanceHistoryResult;
import org.cyclos.web.rest.model.AccountHistoryResult;
import org.cyclos.web.rest.model.AccountWithHistoryStatus;
import org.cyclos.web.rest.model.AccountWithStatus;
import org.cyclos.web.rest.model.DataForAccountHistory;
import org.cyclos.web.rest.model.DataForUserBalancesSearch;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.OwnerAccountsListData;
import org.cyclos.web.rest.model.TimeFieldEnum;
import org.cyclos.web.rest.model.TransOrderByEnum;
import org.cyclos.web.rest.model.TransferDirectionEnum;
import org.cyclos.web.rest.model.TransferKind;
import org.cyclos.web.rest.model.UserAddressResultEnum;
import org.cyclos.web.rest.model.UserStatusEnum;
import org.cyclos.web.rest.model.UserWithBalanceResult;
import org.cyclos.web.rest.model.UsersWithBalanceOrderByEnum;
import org.cyclos.web.rest.model.UsersWithBalanceSummary;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class AccountsApi {
    @Autowired
    private AccountsApiImpl impl;
    public static final String EXPORT_ACCOUNT_HISTORY = "/{owner}/accounts/{accountType}/export/{format}";
    public static final String EXPORT_USERS_WITH_BALANCES = "/accounts/{accountType}/user-balances/export/{format}";
    public static final String GET_ACCOUNT_BALANCE_HISTORY = "/{owner}/accounts/{accountType}/balances-history";
    public static final String GET_ACCOUNT_HISTORY_DATA_BY_OWNER_AND_TYPE = "/{owner}/accounts/{accountType}/data-for-history";
    public static final String GET_ACCOUNT_STATUS_BY_OWNER_AND_TYPE = "/{owner}/accounts/{accountType}";
    public static final String GET_OWNER_ACCOUNTS_LIST_DATA = "/{owner}/accounts/list-data";
    public static final String GET_USER_BALANCES_DATA = "/accounts/data-for-user-balances";
    public static final String GET_USER_BALANCES_SUMMARY = "/accounts/{accountType}/user-balances/summary";
    public static final String LIST_ACCOUNTS_BY_OWNER = "/{owner}/accounts";
    public static final String SEARCH_ACCOUNT_HISTORY = "/{owner}/accounts/{accountType}/history";
    public static final String SEARCH_USERS_WITH_BALANCES = "/accounts/{accountType}/user-balances";

    @RequestMapping(value={"/api/{owner:.*}/accounts/{accountType}/export/{format}"}, produces={"*/*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> exportAccountHistory(@PathVariable(value="owner") String string, @PathVariable(value="accountType") String string2, @PathVariable(value="format") String string3, @RequestParam(value="accessClients", required=false) List<String> list, @RequestParam(value="amountRange", required=false) List<BigDecimal> list2, @RequestParam(value="brokers", required=false) List<String> list3, @RequestParam(value="by", required=false) String string4, @RequestParam(value="channels", required=false) List<String> list4, @RequestParam(value="chargedBack", required=false) Boolean bl, @RequestParam(value="customFields", required=false) List<String> list5, @RequestParam(value="datePeriod", required=false) List<DateTime> list6, @RequestParam(value="description", required=false) String string5, @RequestParam(value="direction", required=false) TransferDirectionEnum transferDirectionEnum, @RequestParam(value="excludedIds", required=false) List<String> list7, @RequestParam(value="fromCurrentAccessClient", required=false) Boolean bl2, @RequestParam(value="groups", required=false) List<String> list8, @RequestParam(value="includeGeneratedByAccessClient", required=false) Boolean bl3, @RequestParam(value="kinds", required=false) List<TransferKind> list9, @RequestParam(value="orderBy", required=false) TransOrderByEnum transOrderByEnum, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl4, @RequestParam(value="statuses", required=false) List<String> list10, @RequestParam(value="transactionNumber", required=false) String string6, @RequestParam(value="transferFilters", required=false) List<String> list11, @RequestParam(value="transferTypes", required=false) List<String> list12, @RequestParam(value="user", required=false) String string7, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{owner}/accounts/{accountType}/export/{format}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        ExportAccountHistoryParams exportAccountHistoryParams = new ExportAccountHistoryParams();
        exportAccountHistoryParams.owner = string;
        exportAccountHistoryParams.accountType = string2;
        exportAccountHistoryParams.format = string3;
        exportAccountHistoryParams.accessClients = list;
        exportAccountHistoryParams.amountRange = list2;
        exportAccountHistoryParams.brokers = list3;
        exportAccountHistoryParams.by = string4;
        exportAccountHistoryParams.channels = list4;
        exportAccountHistoryParams.chargedBack = bl;
        exportAccountHistoryParams.customFields = list5;
        exportAccountHistoryParams.datePeriod = list6;
        exportAccountHistoryParams.description = string5;
        exportAccountHistoryParams.direction = transferDirectionEnum;
        exportAccountHistoryParams.excludedIds = list7;
        exportAccountHistoryParams.fromCurrentAccessClient = bl2;
        exportAccountHistoryParams.groups = list8;
        exportAccountHistoryParams.includeGeneratedByAccessClient = bl3;
        exportAccountHistoryParams.kinds = list9;
        exportAccountHistoryParams.orderBy = transOrderByEnum;
        exportAccountHistoryParams.page = n;
        exportAccountHistoryParams.pageSize = n2;
        exportAccountHistoryParams.skipTotalCount = bl4;
        exportAccountHistoryParams.statuses = list10;
        exportAccountHistoryParams.transactionNumber = string6;
        exportAccountHistoryParams.transferFilters = list11;
        exportAccountHistoryParams.transferTypes = list12;
        exportAccountHistoryParams.user = string7;
        return this.impl.exportAccountHistory(exportAccountHistoryParams);
    }

    @RequestMapping(value={"/api/accounts/{accountType}/user-balances/export/{format}"}, produces={"*/*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> exportUsersWithBalances(@PathVariable(value="format") String string, @PathVariable(value="accountType") String string2, @RequestParam(value="acceptedAgreements", required=false) List<String> list, @RequestParam(value="activationPeriod", required=false) List<DateTime> list2, @RequestParam(value="addressResult", required=false) UserAddressResultEnum userAddressResultEnum, @RequestParam(value="balanceRange", required=false) List<BigDecimal> list3, @RequestParam(value="brokers", required=false) List<String> list4, @RequestParam(value="creationPeriod", required=false) List<DateTime> list5, @RequestParam(value="groups", required=false) List<String> list6, @RequestParam(value="hasBroker", required=false) Boolean bl, @RequestParam(value="ignoreProfileFieldsInList", required=false) Boolean bl2, @RequestParam(value="includeGlobal", required=false) Boolean bl3, @RequestParam(value="includeGroup", required=false) Boolean bl4, @RequestParam(value="includeGroupSet", required=false) Boolean bl5, @RequestParam(value="invitedBy", required=false) String string3, @RequestParam(value="keywords", required=false) String string4, @RequestParam(value="lastLoginPeriod", required=false) List<DateTime> list7, @RequestParam(value="latitude", required=false) Double d, @RequestParam(value="longitude", required=false) Double d2, @RequestParam(value="mainBrokerOnly", required=false) Boolean bl6, @RequestParam(value="maxDistance", required=false) Double d3, @RequestParam(value="mediumBalanceRange", required=false) List<Integer> list8, @RequestParam(value="negativeSincePeriod", required=false) List<DateTime> list9, @RequestParam(value="notAcceptedAgreements", required=false) List<String> list10, @RequestParam(value="orderBy", required=false) UsersWithBalanceOrderByEnum usersWithBalanceOrderByEnum, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="products", required=false) List<String> list11, @RequestParam(value="productsIndividuallyAssigned", required=false) Boolean bl7, @RequestParam(value="profileFields", required=false) List<String> list12, @RequestParam(value="skipTotalCount", required=false) Boolean bl8, @RequestParam(value="statuses", required=false) List<UserStatusEnum> list13, @RequestParam(value="usersToExclude", required=false) List<String> list14, @RequestParam(value="usersToInclude", required=false) List<String> list15, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /accounts/{accountType}/user-balances/export/{format}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        ExportUsersWithBalancesParams exportUsersWithBalancesParams = new ExportUsersWithBalancesParams();
        exportUsersWithBalancesParams.format = string;
        exportUsersWithBalancesParams.accountType = string2;
        exportUsersWithBalancesParams.acceptedAgreements = list;
        exportUsersWithBalancesParams.activationPeriod = list2;
        exportUsersWithBalancesParams.addressResult = userAddressResultEnum;
        exportUsersWithBalancesParams.balanceRange = list3;
        exportUsersWithBalancesParams.brokers = list4;
        exportUsersWithBalancesParams.creationPeriod = list5;
        exportUsersWithBalancesParams.groups = list6;
        exportUsersWithBalancesParams.hasBroker = bl;
        exportUsersWithBalancesParams.ignoreProfileFieldsInList = bl2;
        exportUsersWithBalancesParams.includeGlobal = bl3;
        exportUsersWithBalancesParams.includeGroup = bl4;
        exportUsersWithBalancesParams.includeGroupSet = bl5;
        exportUsersWithBalancesParams.invitedBy = string3;
        exportUsersWithBalancesParams.keywords = string4;
        exportUsersWithBalancesParams.lastLoginPeriod = list7;
        exportUsersWithBalancesParams.latitude = d;
        exportUsersWithBalancesParams.longitude = d2;
        exportUsersWithBalancesParams.mainBrokerOnly = bl6;
        exportUsersWithBalancesParams.maxDistance = d3;
        exportUsersWithBalancesParams.mediumBalanceRange = list8;
        exportUsersWithBalancesParams.negativeSincePeriod = list9;
        exportUsersWithBalancesParams.notAcceptedAgreements = list10;
        exportUsersWithBalancesParams.orderBy = usersWithBalanceOrderByEnum;
        exportUsersWithBalancesParams.page = n;
        exportUsersWithBalancesParams.pageSize = n2;
        exportUsersWithBalancesParams.products = list11;
        exportUsersWithBalancesParams.productsIndividuallyAssigned = bl7;
        exportUsersWithBalancesParams.profileFields = list12;
        exportUsersWithBalancesParams.skipTotalCount = bl8;
        exportUsersWithBalancesParams.statuses = list13;
        exportUsersWithBalancesParams.usersToExclude = list14;
        exportUsersWithBalancesParams.usersToInclude = list15;
        return this.impl.exportUsersWithBalances(exportUsersWithBalancesParams);
    }

    @RequestMapping(value={"/api/{owner:.*}/accounts/{accountType}/balances-history"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<AccountBalanceHistoryResult> getAccountBalanceHistory(@PathVariable(value="owner") String string, @PathVariable(value="accountType") String string2, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="datePeriod", required=false) List<DateTime> list2, @RequestParam(value="intervalUnit", required=false) TimeFieldEnum timeFieldEnum, @RequestParam(value="intervalCount", required=false) Integer n, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{owner}/accounts/{accountType}/balances-history");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        GetAccountBalanceHistoryParams getAccountBalanceHistoryParams = new GetAccountBalanceHistoryParams();
        getAccountBalanceHistoryParams.owner = string;
        getAccountBalanceHistoryParams.accountType = string2;
        getAccountBalanceHistoryParams.fields = list;
        getAccountBalanceHistoryParams.datePeriod = list2;
        getAccountBalanceHistoryParams.intervalUnit = timeFieldEnum;
        getAccountBalanceHistoryParams.intervalCount = n;
        return this.impl.getAccountBalanceHistory(getAccountBalanceHistoryParams);
    }

    @RequestMapping(value={"/api/{owner:.*}/accounts/{accountType}/data-for-history"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForAccountHistory> getAccountHistoryDataByOwnerAndType(@PathVariable(value="owner") String string, @PathVariable(value="accountType") String string2, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{owner}/accounts/{accountType}/data-for-history");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getAccountHistoryDataByOwnerAndType(string, string2, list);
    }

    @RequestMapping(value={"/api/{owner:.*}/accounts/{accountType}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<AccountWithHistoryStatus> getAccountStatusByOwnerAndType(@PathVariable(value="owner") String string, @PathVariable(value="accountType") String string2, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="accessClients", required=false) List<String> list2, @RequestParam(value="amountRange", required=false) List<BigDecimal> list3, @RequestParam(value="brokers", required=false) List<String> list4, @RequestParam(value="by", required=false) String string3, @RequestParam(value="channels", required=false) List<String> list5, @RequestParam(value="chargedBack", required=false) Boolean bl, @RequestParam(value="customFields", required=false) List<String> list6, @RequestParam(value="datePeriod", required=false) List<DateTime> list7, @RequestParam(value="description", required=false) String string4, @RequestParam(value="direction", required=false) TransferDirectionEnum transferDirectionEnum, @RequestParam(value="excludedIds", required=false) List<String> list8, @RequestParam(value="fromCurrentAccessClient", required=false) Boolean bl2, @RequestParam(value="groups", required=false) List<String> list9, @RequestParam(value="includeGeneratedByAccessClient", required=false) Boolean bl3, @RequestParam(value="kinds", required=false) List<TransferKind> list10, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl4, @RequestParam(value="statuses", required=false) List<String> list11, @RequestParam(value="transactionNumber", required=false) String string5, @RequestParam(value="transferFilters", required=false) List<String> list12, @RequestParam(value="transferTypes", required=false) List<String> list13, @RequestParam(value="user", required=false) String string6, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{owner}/accounts/{accountType}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        GetAccountStatusByOwnerAndTypeParams getAccountStatusByOwnerAndTypeParams = new GetAccountStatusByOwnerAndTypeParams();
        getAccountStatusByOwnerAndTypeParams.owner = string;
        getAccountStatusByOwnerAndTypeParams.accountType = string2;
        getAccountStatusByOwnerAndTypeParams.fields = list;
        getAccountStatusByOwnerAndTypeParams.accessClients = list2;
        getAccountStatusByOwnerAndTypeParams.amountRange = list3;
        getAccountStatusByOwnerAndTypeParams.brokers = list4;
        getAccountStatusByOwnerAndTypeParams.by = string3;
        getAccountStatusByOwnerAndTypeParams.channels = list5;
        getAccountStatusByOwnerAndTypeParams.chargedBack = bl;
        getAccountStatusByOwnerAndTypeParams.customFields = list6;
        getAccountStatusByOwnerAndTypeParams.datePeriod = list7;
        getAccountStatusByOwnerAndTypeParams.description = string4;
        getAccountStatusByOwnerAndTypeParams.direction = transferDirectionEnum;
        getAccountStatusByOwnerAndTypeParams.excludedIds = list8;
        getAccountStatusByOwnerAndTypeParams.fromCurrentAccessClient = bl2;
        getAccountStatusByOwnerAndTypeParams.groups = list9;
        getAccountStatusByOwnerAndTypeParams.includeGeneratedByAccessClient = bl3;
        getAccountStatusByOwnerAndTypeParams.kinds = list10;
        getAccountStatusByOwnerAndTypeParams.page = n;
        getAccountStatusByOwnerAndTypeParams.pageSize = n2;
        getAccountStatusByOwnerAndTypeParams.skipTotalCount = bl4;
        getAccountStatusByOwnerAndTypeParams.statuses = list11;
        getAccountStatusByOwnerAndTypeParams.transactionNumber = string5;
        getAccountStatusByOwnerAndTypeParams.transferFilters = list12;
        getAccountStatusByOwnerAndTypeParams.transferTypes = list13;
        getAccountStatusByOwnerAndTypeParams.user = string6;
        return this.impl.getAccountStatusByOwnerAndType(getAccountStatusByOwnerAndTypeParams);
    }

    @RequestMapping(value={"/api/{owner:.*}/accounts/list-data"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<OwnerAccountsListData> getOwnerAccountsListData(@PathVariable(value="owner") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{owner}/accounts/list-data");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getOwnerAccountsListData(string, list);
    }

    @RequestMapping(value={"/api/accounts/data-for-user-balances"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForUserBalancesSearch> getUserBalancesData(@RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /accounts/data-for-user-balances");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserBalancesData(list);
    }

    @RequestMapping(value={"/api/accounts/{accountType}/user-balances/summary"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UsersWithBalanceSummary> getUserBalancesSummary(@PathVariable(value="accountType") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="acceptedAgreements", required=false) List<String> list2, @RequestParam(value="activationPeriod", required=false) List<DateTime> list3, @RequestParam(value="addressResult", required=false) UserAddressResultEnum userAddressResultEnum, @RequestParam(value="balanceRange", required=false) List<BigDecimal> list4, @RequestParam(value="brokers", required=false) List<String> list5, @RequestParam(value="creationPeriod", required=false) List<DateTime> list6, @RequestParam(value="groups", required=false) List<String> list7, @RequestParam(value="hasBroker", required=false) Boolean bl, @RequestParam(value="ignoreProfileFieldsInList", required=false) Boolean bl2, @RequestParam(value="includeGlobal", required=false) Boolean bl3, @RequestParam(value="includeGroup", required=false) Boolean bl4, @RequestParam(value="includeGroupSet", required=false) Boolean bl5, @RequestParam(value="invitedBy", required=false) String string2, @RequestParam(value="keywords", required=false) String string3, @RequestParam(value="lastLoginPeriod", required=false) List<DateTime> list8, @RequestParam(value="latitude", required=false) Double d, @RequestParam(value="longitude", required=false) Double d2, @RequestParam(value="mainBrokerOnly", required=false) Boolean bl6, @RequestParam(value="maxDistance", required=false) Double d3, @RequestParam(value="mediumBalanceRange", required=false) List<Integer> list9, @RequestParam(value="negativeSincePeriod", required=false) List<DateTime> list10, @RequestParam(value="notAcceptedAgreements", required=false) List<String> list11, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="products", required=false) List<String> list12, @RequestParam(value="productsIndividuallyAssigned", required=false) Boolean bl7, @RequestParam(value="profileFields", required=false) List<String> list13, @RequestParam(value="skipTotalCount", required=false) Boolean bl8, @RequestParam(value="statuses", required=false) List<UserStatusEnum> list14, @RequestParam(value="usersToExclude", required=false) List<String> list15, @RequestParam(value="usersToInclude", required=false) List<String> list16, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /accounts/{accountType}/user-balances/summary");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        GetUserBalancesSummaryParams getUserBalancesSummaryParams = new GetUserBalancesSummaryParams();
        getUserBalancesSummaryParams.accountType = string;
        getUserBalancesSummaryParams.fields = list;
        getUserBalancesSummaryParams.acceptedAgreements = list2;
        getUserBalancesSummaryParams.activationPeriod = list3;
        getUserBalancesSummaryParams.addressResult = userAddressResultEnum;
        getUserBalancesSummaryParams.balanceRange = list4;
        getUserBalancesSummaryParams.brokers = list5;
        getUserBalancesSummaryParams.creationPeriod = list6;
        getUserBalancesSummaryParams.groups = list7;
        getUserBalancesSummaryParams.hasBroker = bl;
        getUserBalancesSummaryParams.ignoreProfileFieldsInList = bl2;
        getUserBalancesSummaryParams.includeGlobal = bl3;
        getUserBalancesSummaryParams.includeGroup = bl4;
        getUserBalancesSummaryParams.includeGroupSet = bl5;
        getUserBalancesSummaryParams.invitedBy = string2;
        getUserBalancesSummaryParams.keywords = string3;
        getUserBalancesSummaryParams.lastLoginPeriod = list8;
        getUserBalancesSummaryParams.latitude = d;
        getUserBalancesSummaryParams.longitude = d2;
        getUserBalancesSummaryParams.mainBrokerOnly = bl6;
        getUserBalancesSummaryParams.maxDistance = d3;
        getUserBalancesSummaryParams.mediumBalanceRange = list9;
        getUserBalancesSummaryParams.negativeSincePeriod = list10;
        getUserBalancesSummaryParams.notAcceptedAgreements = list11;
        getUserBalancesSummaryParams.page = n;
        getUserBalancesSummaryParams.pageSize = n2;
        getUserBalancesSummaryParams.products = list12;
        getUserBalancesSummaryParams.productsIndividuallyAssigned = bl7;
        getUserBalancesSummaryParams.profileFields = list13;
        getUserBalancesSummaryParams.skipTotalCount = bl8;
        getUserBalancesSummaryParams.statuses = list14;
        getUserBalancesSummaryParams.usersToExclude = list15;
        getUserBalancesSummaryParams.usersToInclude = list16;
        return this.impl.getUserBalancesSummary(getUserBalancesSummaryParams);
    }

    @RequestMapping(value={"/api/{owner:.*}/accounts"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<AccountWithStatus>> listAccountsByOwner(@PathVariable(value="owner") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{owner}/accounts");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.listAccountsByOwner(string, list);
    }

    @RequestMapping(value={"/api/{owner:.*}/accounts/{accountType}/history"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<AccountHistoryResult>> searchAccountHistory(@PathVariable(value="owner") String string, @PathVariable(value="accountType") String string2, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="accessClients", required=false) List<String> list2, @RequestParam(value="amountRange", required=false) List<BigDecimal> list3, @RequestParam(value="brokers", required=false) List<String> list4, @RequestParam(value="by", required=false) String string3, @RequestParam(value="channels", required=false) List<String> list5, @RequestParam(value="chargedBack", required=false) Boolean bl, @RequestParam(value="customFields", required=false) List<String> list6, @RequestParam(value="datePeriod", required=false) List<DateTime> list7, @RequestParam(value="description", required=false) String string4, @RequestParam(value="direction", required=false) TransferDirectionEnum transferDirectionEnum, @RequestParam(value="excludedIds", required=false) List<String> list8, @RequestParam(value="fromCurrentAccessClient", required=false) Boolean bl2, @RequestParam(value="groups", required=false) List<String> list9, @RequestParam(value="includeGeneratedByAccessClient", required=false) Boolean bl3, @RequestParam(value="kinds", required=false) List<TransferKind> list10, @RequestParam(value="orderBy", required=false) TransOrderByEnum transOrderByEnum, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl4, @RequestParam(value="statuses", required=false) List<String> list11, @RequestParam(value="transactionNumber", required=false) String string5, @RequestParam(value="transferFilters", required=false) List<String> list12, @RequestParam(value="transferTypes", required=false) List<String> list13, @RequestParam(value="user", required=false) String string6, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{owner}/accounts/{accountType}/history");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchAccountHistoryParams searchAccountHistoryParams = new SearchAccountHistoryParams();
        searchAccountHistoryParams.owner = string;
        searchAccountHistoryParams.accountType = string2;
        searchAccountHistoryParams.fields = list;
        searchAccountHistoryParams.accessClients = list2;
        searchAccountHistoryParams.amountRange = list3;
        searchAccountHistoryParams.brokers = list4;
        searchAccountHistoryParams.by = string3;
        searchAccountHistoryParams.channels = list5;
        searchAccountHistoryParams.chargedBack = bl;
        searchAccountHistoryParams.customFields = list6;
        searchAccountHistoryParams.datePeriod = list7;
        searchAccountHistoryParams.description = string4;
        searchAccountHistoryParams.direction = transferDirectionEnum;
        searchAccountHistoryParams.excludedIds = list8;
        searchAccountHistoryParams.fromCurrentAccessClient = bl2;
        searchAccountHistoryParams.groups = list9;
        searchAccountHistoryParams.includeGeneratedByAccessClient = bl3;
        searchAccountHistoryParams.kinds = list10;
        searchAccountHistoryParams.orderBy = transOrderByEnum;
        searchAccountHistoryParams.page = n;
        searchAccountHistoryParams.pageSize = n2;
        searchAccountHistoryParams.skipTotalCount = bl4;
        searchAccountHistoryParams.statuses = list11;
        searchAccountHistoryParams.transactionNumber = string5;
        searchAccountHistoryParams.transferFilters = list12;
        searchAccountHistoryParams.transferTypes = list13;
        searchAccountHistoryParams.user = string6;
        return this.impl.searchAccountHistory(searchAccountHistoryParams);
    }

    @RequestMapping(value={"/api/accounts/{accountType}/user-balances"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<UserWithBalanceResult>> searchUsersWithBalances(@PathVariable(value="accountType") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="acceptedAgreements", required=false) List<String> list2, @RequestParam(value="activationPeriod", required=false) List<DateTime> list3, @RequestParam(value="addressResult", required=false) UserAddressResultEnum userAddressResultEnum, @RequestParam(value="balanceRange", required=false) List<BigDecimal> list4, @RequestParam(value="brokers", required=false) List<String> list5, @RequestParam(value="creationPeriod", required=false) List<DateTime> list6, @RequestParam(value="groups", required=false) List<String> list7, @RequestParam(value="hasBroker", required=false) Boolean bl, @RequestParam(value="ignoreProfileFieldsInList", required=false) Boolean bl2, @RequestParam(value="includeGlobal", required=false) Boolean bl3, @RequestParam(value="includeGroup", required=false) Boolean bl4, @RequestParam(value="includeGroupSet", required=false) Boolean bl5, @RequestParam(value="invitedBy", required=false) String string2, @RequestParam(value="keywords", required=false) String string3, @RequestParam(value="lastLoginPeriod", required=false) List<DateTime> list8, @RequestParam(value="latitude", required=false) Double d, @RequestParam(value="longitude", required=false) Double d2, @RequestParam(value="mainBrokerOnly", required=false) Boolean bl6, @RequestParam(value="maxDistance", required=false) Double d3, @RequestParam(value="mediumBalanceRange", required=false) List<Integer> list9, @RequestParam(value="negativeSincePeriod", required=false) List<DateTime> list10, @RequestParam(value="notAcceptedAgreements", required=false) List<String> list11, @RequestParam(value="orderBy", required=false) UsersWithBalanceOrderByEnum usersWithBalanceOrderByEnum, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="products", required=false) List<String> list12, @RequestParam(value="productsIndividuallyAssigned", required=false) Boolean bl7, @RequestParam(value="profileFields", required=false) List<String> list13, @RequestParam(value="skipTotalCount", required=false) Boolean bl8, @RequestParam(value="statuses", required=false) List<UserStatusEnum> list14, @RequestParam(value="usersToExclude", required=false) List<String> list15, @RequestParam(value="usersToInclude", required=false) List<String> list16, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /accounts/{accountType}/user-balances");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchUsersWithBalancesParams searchUsersWithBalancesParams = new SearchUsersWithBalancesParams();
        searchUsersWithBalancesParams.accountType = string;
        searchUsersWithBalancesParams.fields = list;
        searchUsersWithBalancesParams.acceptedAgreements = list2;
        searchUsersWithBalancesParams.activationPeriod = list3;
        searchUsersWithBalancesParams.addressResult = userAddressResultEnum;
        searchUsersWithBalancesParams.balanceRange = list4;
        searchUsersWithBalancesParams.brokers = list5;
        searchUsersWithBalancesParams.creationPeriod = list6;
        searchUsersWithBalancesParams.groups = list7;
        searchUsersWithBalancesParams.hasBroker = bl;
        searchUsersWithBalancesParams.ignoreProfileFieldsInList = bl2;
        searchUsersWithBalancesParams.includeGlobal = bl3;
        searchUsersWithBalancesParams.includeGroup = bl4;
        searchUsersWithBalancesParams.includeGroupSet = bl5;
        searchUsersWithBalancesParams.invitedBy = string2;
        searchUsersWithBalancesParams.keywords = string3;
        searchUsersWithBalancesParams.lastLoginPeriod = list8;
        searchUsersWithBalancesParams.latitude = d;
        searchUsersWithBalancesParams.longitude = d2;
        searchUsersWithBalancesParams.mainBrokerOnly = bl6;
        searchUsersWithBalancesParams.maxDistance = d3;
        searchUsersWithBalancesParams.mediumBalanceRange = list9;
        searchUsersWithBalancesParams.negativeSincePeriod = list10;
        searchUsersWithBalancesParams.notAcceptedAgreements = list11;
        searchUsersWithBalancesParams.orderBy = usersWithBalanceOrderByEnum;
        searchUsersWithBalancesParams.page = n;
        searchUsersWithBalancesParams.pageSize = n2;
        searchUsersWithBalancesParams.products = list12;
        searchUsersWithBalancesParams.productsIndividuallyAssigned = bl7;
        searchUsersWithBalancesParams.profileFields = list13;
        searchUsersWithBalancesParams.skipTotalCount = bl8;
        searchUsersWithBalancesParams.statuses = list14;
        searchUsersWithBalancesParams.usersToExclude = list15;
        searchUsersWithBalancesParams.usersToInclude = list16;
        return this.impl.searchUsersWithBalances(searchUsersWithBalancesParams);
    }

    public static class ExportAccountHistoryParams {
        public String owner;
        public static final String OWNER = "owner";
        public String accountType;
        public static final String ACCOUNT_TYPE = "accountType";
        public String format;
        public static final String FORMAT = "format";
        public List<String> accessClients;
        public static final String ACCESS_CLIENTS = "accessClients";
        public List<BigDecimal> amountRange;
        public static final String AMOUNT_RANGE = "amountRange";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String by;
        public static final String BY = "by";
        public List<String> channels;
        public static final String CHANNELS = "channels";
        public Boolean chargedBack;
        public static final String CHARGED_BACK = "chargedBack";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public List<DateTime> datePeriod;
        public static final String DATE_PERIOD = "datePeriod";
        public String description;
        public static final String DESCRIPTION = "description";
        public TransferDirectionEnum direction;
        public static final String DIRECTION = "direction";
        public List<String> excludedIds;
        public static final String EXCLUDED_IDS = "excludedIds";
        public Boolean fromCurrentAccessClient;
        public static final String FROM_CURRENT_ACCESS_CLIENT = "fromCurrentAccessClient";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Boolean includeGeneratedByAccessClient;
        public static final String INCLUDE_GENERATED_BY_ACCESS_CLIENT = "includeGeneratedByAccessClient";
        public List<TransferKind> kinds;
        public static final String KINDS = "kinds";
        public TransOrderByEnum orderBy;
        public static final String ORDER_BY = "orderBy";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<String> statuses;
        public static final String STATUSES = "statuses";
        public String transactionNumber;
        public static final String TRANSACTION_NUMBER = "transactionNumber";
        public List<String> transferFilters;
        public static final String TRANSFER_FILTERS = "transferFilters";
        public List<String> transferTypes;
        public static final String TRANSFER_TYPES = "transferTypes";
        public String user;
        public static final String USER = "user";
    }

    public static class ExportUsersWithBalancesParams {
        public String format;
        public static final String FORMAT = "format";
        public String accountType;
        public static final String ACCOUNT_TYPE = "accountType";
        public List<String> acceptedAgreements;
        public static final String ACCEPTED_AGREEMENTS = "acceptedAgreements";
        public List<DateTime> activationPeriod;
        public static final String ACTIVATION_PERIOD = "activationPeriod";
        public UserAddressResultEnum addressResult;
        public static final String ADDRESS_RESULT = "addressResult";
        public List<BigDecimal> balanceRange;
        public static final String BALANCE_RANGE = "balanceRange";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public List<DateTime> creationPeriod;
        public static final String CREATION_PERIOD = "creationPeriod";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Boolean hasBroker;
        public static final String HAS_BROKER = "hasBroker";
        public Boolean ignoreProfileFieldsInList;
        public static final String IGNORE_PROFILE_FIELDS_IN_LIST = "ignoreProfileFieldsInList";
        public Boolean includeGlobal;
        public static final String INCLUDE_GLOBAL = "includeGlobal";
        public Boolean includeGroup;
        public static final String INCLUDE_GROUP = "includeGroup";
        public Boolean includeGroupSet;
        public static final String INCLUDE_GROUP_SET = "includeGroupSet";
        public String invitedBy;
        public static final String INVITED_BY = "invitedBy";
        public String keywords;
        public static final String KEYWORDS = "keywords";
        public List<DateTime> lastLoginPeriod;
        public static final String LAST_LOGIN_PERIOD = "lastLoginPeriod";
        public Double latitude;
        public static final String LATITUDE = "latitude";
        public Double longitude;
        public static final String LONGITUDE = "longitude";
        public Boolean mainBrokerOnly;
        public static final String MAIN_BROKER_ONLY = "mainBrokerOnly";
        public Double maxDistance;
        public static final String MAX_DISTANCE = "maxDistance";
        public List<Integer> mediumBalanceRange;
        public static final String MEDIUM_BALANCE_RANGE = "mediumBalanceRange";
        public List<DateTime> negativeSincePeriod;
        public static final String NEGATIVE_SINCE_PERIOD = "negativeSincePeriod";
        public List<String> notAcceptedAgreements;
        public static final String NOT_ACCEPTED_AGREEMENTS = "notAcceptedAgreements";
        public UsersWithBalanceOrderByEnum orderBy;
        public static final String ORDER_BY = "orderBy";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public List<String> products;
        public static final String PRODUCTS = "products";
        public Boolean productsIndividuallyAssigned;
        public static final String PRODUCTS_INDIVIDUALLY_ASSIGNED = "productsIndividuallyAssigned";
        public List<String> profileFields;
        public static final String PROFILE_FIELDS = "profileFields";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<UserStatusEnum> statuses;
        public static final String STATUSES = "statuses";
        public List<String> usersToExclude;
        public static final String USERS_TO_EXCLUDE = "usersToExclude";
        public List<String> usersToInclude;
        public static final String USERS_TO_INCLUDE = "usersToInclude";
    }

    public static class GetAccountBalanceHistoryParams {
        public String owner;
        public static final String OWNER = "owner";
        public String accountType;
        public static final String ACCOUNT_TYPE = "accountType";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<DateTime> datePeriod;
        public static final String DATE_PERIOD = "datePeriod";
        public TimeFieldEnum intervalUnit;
        public static final String INTERVAL_UNIT = "intervalUnit";
        public Integer intervalCount;
        public static final String INTERVAL_COUNT = "intervalCount";
    }

    public static class GetAccountStatusByOwnerAndTypeParams {
        public String owner;
        public static final String OWNER = "owner";
        public String accountType;
        public static final String ACCOUNT_TYPE = "accountType";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<String> accessClients;
        public static final String ACCESS_CLIENTS = "accessClients";
        public List<BigDecimal> amountRange;
        public static final String AMOUNT_RANGE = "amountRange";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String by;
        public static final String BY = "by";
        public List<String> channels;
        public static final String CHANNELS = "channels";
        public Boolean chargedBack;
        public static final String CHARGED_BACK = "chargedBack";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public List<DateTime> datePeriod;
        public static final String DATE_PERIOD = "datePeriod";
        public String description;
        public static final String DESCRIPTION = "description";
        public TransferDirectionEnum direction;
        public static final String DIRECTION = "direction";
        public List<String> excludedIds;
        public static final String EXCLUDED_IDS = "excludedIds";
        public Boolean fromCurrentAccessClient;
        public static final String FROM_CURRENT_ACCESS_CLIENT = "fromCurrentAccessClient";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Boolean includeGeneratedByAccessClient;
        public static final String INCLUDE_GENERATED_BY_ACCESS_CLIENT = "includeGeneratedByAccessClient";
        public List<TransferKind> kinds;
        public static final String KINDS = "kinds";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<String> statuses;
        public static final String STATUSES = "statuses";
        public String transactionNumber;
        public static final String TRANSACTION_NUMBER = "transactionNumber";
        public List<String> transferFilters;
        public static final String TRANSFER_FILTERS = "transferFilters";
        public List<String> transferTypes;
        public static final String TRANSFER_TYPES = "transferTypes";
        public String user;
        public static final String USER = "user";
    }

    public static class GetUserBalancesSummaryParams {
        public String accountType;
        public static final String ACCOUNT_TYPE = "accountType";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<String> acceptedAgreements;
        public static final String ACCEPTED_AGREEMENTS = "acceptedAgreements";
        public List<DateTime> activationPeriod;
        public static final String ACTIVATION_PERIOD = "activationPeriod";
        public UserAddressResultEnum addressResult;
        public static final String ADDRESS_RESULT = "addressResult";
        public List<BigDecimal> balanceRange;
        public static final String BALANCE_RANGE = "balanceRange";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public List<DateTime> creationPeriod;
        public static final String CREATION_PERIOD = "creationPeriod";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Boolean hasBroker;
        public static final String HAS_BROKER = "hasBroker";
        public Boolean ignoreProfileFieldsInList;
        public static final String IGNORE_PROFILE_FIELDS_IN_LIST = "ignoreProfileFieldsInList";
        public Boolean includeGlobal;
        public static final String INCLUDE_GLOBAL = "includeGlobal";
        public Boolean includeGroup;
        public static final String INCLUDE_GROUP = "includeGroup";
        public Boolean includeGroupSet;
        public static final String INCLUDE_GROUP_SET = "includeGroupSet";
        public String invitedBy;
        public static final String INVITED_BY = "invitedBy";
        public String keywords;
        public static final String KEYWORDS = "keywords";
        public List<DateTime> lastLoginPeriod;
        public static final String LAST_LOGIN_PERIOD = "lastLoginPeriod";
        public Double latitude;
        public static final String LATITUDE = "latitude";
        public Double longitude;
        public static final String LONGITUDE = "longitude";
        public Boolean mainBrokerOnly;
        public static final String MAIN_BROKER_ONLY = "mainBrokerOnly";
        public Double maxDistance;
        public static final String MAX_DISTANCE = "maxDistance";
        public List<Integer> mediumBalanceRange;
        public static final String MEDIUM_BALANCE_RANGE = "mediumBalanceRange";
        public List<DateTime> negativeSincePeriod;
        public static final String NEGATIVE_SINCE_PERIOD = "negativeSincePeriod";
        public List<String> notAcceptedAgreements;
        public static final String NOT_ACCEPTED_AGREEMENTS = "notAcceptedAgreements";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public List<String> products;
        public static final String PRODUCTS = "products";
        public Boolean productsIndividuallyAssigned;
        public static final String PRODUCTS_INDIVIDUALLY_ASSIGNED = "productsIndividuallyAssigned";
        public List<String> profileFields;
        public static final String PROFILE_FIELDS = "profileFields";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<UserStatusEnum> statuses;
        public static final String STATUSES = "statuses";
        public List<String> usersToExclude;
        public static final String USERS_TO_EXCLUDE = "usersToExclude";
        public List<String> usersToInclude;
        public static final String USERS_TO_INCLUDE = "usersToInclude";
    }

    public static class SearchAccountHistoryParams {
        public String owner;
        public static final String OWNER = "owner";
        public String accountType;
        public static final String ACCOUNT_TYPE = "accountType";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<String> accessClients;
        public static final String ACCESS_CLIENTS = "accessClients";
        public List<BigDecimal> amountRange;
        public static final String AMOUNT_RANGE = "amountRange";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String by;
        public static final String BY = "by";
        public List<String> channels;
        public static final String CHANNELS = "channels";
        public Boolean chargedBack;
        public static final String CHARGED_BACK = "chargedBack";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public List<DateTime> datePeriod;
        public static final String DATE_PERIOD = "datePeriod";
        public String description;
        public static final String DESCRIPTION = "description";
        public TransferDirectionEnum direction;
        public static final String DIRECTION = "direction";
        public List<String> excludedIds;
        public static final String EXCLUDED_IDS = "excludedIds";
        public Boolean fromCurrentAccessClient;
        public static final String FROM_CURRENT_ACCESS_CLIENT = "fromCurrentAccessClient";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Boolean includeGeneratedByAccessClient;
        public static final String INCLUDE_GENERATED_BY_ACCESS_CLIENT = "includeGeneratedByAccessClient";
        public List<TransferKind> kinds;
        public static final String KINDS = "kinds";
        public TransOrderByEnum orderBy;
        public static final String ORDER_BY = "orderBy";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<String> statuses;
        public static final String STATUSES = "statuses";
        public String transactionNumber;
        public static final String TRANSACTION_NUMBER = "transactionNumber";
        public List<String> transferFilters;
        public static final String TRANSFER_FILTERS = "transferFilters";
        public List<String> transferTypes;
        public static final String TRANSFER_TYPES = "transferTypes";
        public String user;
        public static final String USER = "user";
    }

    public static class SearchUsersWithBalancesParams {
        public String accountType;
        public static final String ACCOUNT_TYPE = "accountType";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<String> acceptedAgreements;
        public static final String ACCEPTED_AGREEMENTS = "acceptedAgreements";
        public List<DateTime> activationPeriod;
        public static final String ACTIVATION_PERIOD = "activationPeriod";
        public UserAddressResultEnum addressResult;
        public static final String ADDRESS_RESULT = "addressResult";
        public List<BigDecimal> balanceRange;
        public static final String BALANCE_RANGE = "balanceRange";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public List<DateTime> creationPeriod;
        public static final String CREATION_PERIOD = "creationPeriod";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Boolean hasBroker;
        public static final String HAS_BROKER = "hasBroker";
        public Boolean ignoreProfileFieldsInList;
        public static final String IGNORE_PROFILE_FIELDS_IN_LIST = "ignoreProfileFieldsInList";
        public Boolean includeGlobal;
        public static final String INCLUDE_GLOBAL = "includeGlobal";
        public Boolean includeGroup;
        public static final String INCLUDE_GROUP = "includeGroup";
        public Boolean includeGroupSet;
        public static final String INCLUDE_GROUP_SET = "includeGroupSet";
        public String invitedBy;
        public static final String INVITED_BY = "invitedBy";
        public String keywords;
        public static final String KEYWORDS = "keywords";
        public List<DateTime> lastLoginPeriod;
        public static final String LAST_LOGIN_PERIOD = "lastLoginPeriod";
        public Double latitude;
        public static final String LATITUDE = "latitude";
        public Double longitude;
        public static final String LONGITUDE = "longitude";
        public Boolean mainBrokerOnly;
        public static final String MAIN_BROKER_ONLY = "mainBrokerOnly";
        public Double maxDistance;
        public static final String MAX_DISTANCE = "maxDistance";
        public List<Integer> mediumBalanceRange;
        public static final String MEDIUM_BALANCE_RANGE = "mediumBalanceRange";
        public List<DateTime> negativeSincePeriod;
        public static final String NEGATIVE_SINCE_PERIOD = "negativeSincePeriod";
        public List<String> notAcceptedAgreements;
        public static final String NOT_ACCEPTED_AGREEMENTS = "notAcceptedAgreements";
        public UsersWithBalanceOrderByEnum orderBy;
        public static final String ORDER_BY = "orderBy";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public List<String> products;
        public static final String PRODUCTS = "products";
        public Boolean productsIndividuallyAssigned;
        public static final String PRODUCTS_INDIVIDUALLY_ASSIGNED = "productsIndividuallyAssigned";
        public List<String> profileFields;
        public static final String PROFILE_FIELDS = "profileFields";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<UserStatusEnum> statuses;
        public static final String STATUSES = "statuses";
        public List<String> usersToExclude;
        public static final String USERS_TO_EXCLUDE = "usersToExclude";
        public List<String> usersToInclude;
        public static final String USERS_TO_INCLUDE = "usersToInclude";
    }
}

