/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.model.banking.accounts.AccountBalanceHistoryParams;
import org.cyclos.model.banking.accounts.AccountBalanceHistoryVO;
import org.cyclos.model.banking.accounts.AccountHistoryData;
import org.cyclos.model.banking.accounts.AccountHistoryQuery;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.AccountWithHistoryStatusVO;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.UserWithBalanceQuery;
import org.cyclos.model.banking.accounts.UserWithBalanceSearchData;
import org.cyclos.model.banking.accounts.UsersWithBalancesOverview;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.services.banking.AccountService;
import org.cyclos.utils.Page;
import org.cyclos.web.rest.api.AccountsApi;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.model.AccountBalanceHistoryResult;
import org.cyclos.web.rest.model.AccountHistoryQueryFilters;
import org.cyclos.web.rest.model.AccountHistoryResult;
import org.cyclos.web.rest.model.AccountWithHistoryStatus;
import org.cyclos.web.rest.model.AccountWithStatus;
import org.cyclos.web.rest.model.DataForAccountHistory;
import org.cyclos.web.rest.model.DataForUserBalancesSearch;
import org.cyclos.web.rest.model.OwnerAccountsListData;
import org.cyclos.web.rest.model.UserWithBalanceResult;
import org.cyclos.web.rest.model.UsersWithBalanceQueryFilters;
import org.cyclos.web.rest.model.UsersWithBalanceSummary;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class AccountsApiImpl
extends BaseApiImpl {
    @Autowired
    private AccountService accountService;
    @Autowired
    private AccountsApiHelper accountsApiHelper;

    public ResponseEntity<InputStream> exportAccountHistory(AccountsApi.ExportAccountHistoryParams exportAccountHistoryParams) {
        AccountHistoryQueryFilters accountHistoryQueryFilters = (AccountHistoryQueryFilters)ClassHelper.convert((Object)exportAccountHistoryParams, AccountHistoryQueryFilters.class);
        AccountHistoryQuery accountHistoryQuery = this.accountsApiHelper.toAccountHistoryQuery(exportAccountHistoryParams.owner, exportAccountHistoryParams.accountType, accountHistoryQueryFilters);
        accountHistoryQuery.setUsersWithImage(true);
        ExportFormatVO exportFormatVO = (ExportFormatVO)ModelHelper.voFromString(ExportFormatVO.class, (String)exportAccountHistoryParams.format);
        FileInfo fileInfo = this.accountService.exportAccountHistory(exportFormatVO, accountHistoryQuery);
        return this.writeFile(fileInfo);
    }

    public ResponseEntity<InputStream> exportUsersWithBalances(AccountsApi.ExportUsersWithBalancesParams exportUsersWithBalancesParams) {
        UsersWithBalanceQueryFilters usersWithBalanceQueryFilters = (UsersWithBalanceQueryFilters)ClassHelper.convert((Object)exportUsersWithBalancesParams, UsersWithBalanceQueryFilters.class);
        UserWithBalanceQuery userWithBalanceQuery = this.accountsApiHelper.toUserWithBalanceQuery(usersWithBalanceQueryFilters);
        ExportFormatVO exportFormatVO = (ExportFormatVO)ModelHelper.voFromString(ExportFormatVO.class, (String)exportUsersWithBalancesParams.format);
        FileInfo fileInfo = this.accountService.exportUsersWithBalances(exportFormatVO, userWithBalanceQuery);
        return this.writeFile(fileInfo);
    }

    public ResponseEntity<AccountBalanceHistoryResult> getAccountBalanceHistory(AccountsApi.GetAccountBalanceHistoryParams getAccountBalanceHistoryParams) {
        AccountBalanceHistoryParams accountBalanceHistoryParams = this.accountsApiHelper.toAccountBalanceHistoryParams(getAccountBalanceHistoryParams);
        AccountBalanceHistoryVO accountBalanceHistoryVO = this.accountService.getAccountBalanceHistory(accountBalanceHistoryParams);
        return this.ok(this.accountsApiHelper.toAccountBalanceHistoryResult(accountBalanceHistoryVO));
    }

    public ResponseEntity<DataForAccountHistory> getAccountHistoryDataByOwnerAndType(String string, String string2, List<String> list) {
        AccountVO accountVO = this.accountsApiHelper.toAccountVO(string, string2);
        AccountHistoryData accountHistoryData = this.accountService.getAccountHistoryData(accountVO, null);
        return this.ok(this.accountsApiHelper.toDataForAccountHistory(accountHistoryData));
    }

    public ResponseEntity<AccountWithHistoryStatus> getAccountStatusByOwnerAndType(AccountsApi.GetAccountStatusByOwnerAndTypeParams getAccountStatusByOwnerAndTypeParams) {
        AccountHistoryQueryFilters accountHistoryQueryFilters = (AccountHistoryQueryFilters)ClassHelper.convert((Object)getAccountStatusByOwnerAndTypeParams, AccountHistoryQueryFilters.class);
        AccountHistoryQuery accountHistoryQuery = this.accountsApiHelper.toAccountHistoryQuery(getAccountStatusByOwnerAndTypeParams.owner, getAccountStatusByOwnerAndTypeParams.accountType, accountHistoryQueryFilters);
        AccountWithHistoryStatusVO accountWithHistoryStatusVO = this.accountService.getAccountHistoryStatus(accountHistoryQuery);
        AccountWithHistoryStatus accountWithHistoryStatus = this.accountsApiHelper.toAccountWithHistoryStatus(accountWithHistoryStatusVO);
        return this.ok(accountWithHistoryStatus);
    }

    public ResponseEntity<OwnerAccountsListData> getOwnerAccountsListData(String string, List<String> list) {
        InternalAccountOwner internalAccountOwner = ModelHelper.accountOwner((String)string);
        List list2 = this.accountService.getAccountsSummary(internalAccountOwner, null);
        OwnerAccountsListData ownerAccountsListData = this.accountsApiHelper.toOwnerAccountsListData(list2);
        return this.ok(ownerAccountsListData);
    }

    public ResponseEntity<DataForUserBalancesSearch> getUserBalancesData(List<String> list) {
        UserWithBalanceSearchData userWithBalanceSearchData = this.accountService.getUserWithBalanceSearchData();
        DataForUserBalancesSearch dataForUserBalancesSearch = this.accountsApiHelper.toDataForUserBalancesSearch(userWithBalanceSearchData);
        return this.ok(dataForUserBalancesSearch);
    }

    public ResponseEntity<UsersWithBalanceSummary> getUserBalancesSummary(AccountsApi.GetUserBalancesSummaryParams getUserBalancesSummaryParams) {
        UsersWithBalanceQueryFilters usersWithBalanceQueryFilters = (UsersWithBalanceQueryFilters)ClassHelper.convert((Object)getUserBalancesSummaryParams, UsersWithBalanceQueryFilters.class);
        UserWithBalanceQuery userWithBalanceQuery = this.accountsApiHelper.toUserWithBalanceQuery(usersWithBalanceQueryFilters);
        UsersWithBalancesOverview usersWithBalancesOverview = this.accountService.getUsersWithBalancesOverview(userWithBalanceQuery);
        UsersWithBalanceSummary usersWithBalanceSummary = this.accountsApiHelper.toUsersWithBalanceSummary(usersWithBalancesOverview);
        return this.ok(usersWithBalanceSummary);
    }

    public ResponseEntity<List<AccountWithStatus>> listAccountsByOwner(String string, List<String> list) {
        InternalAccountOwner internalAccountOwner = ModelHelper.accountOwner((String)string);
        List list2 = this.accountService.getAccountsSummary(internalAccountOwner, null);
        List list3 = list2.stream().map(this.accountsApiHelper::toAccountWithStatus).collect(Collectors.toList());
        return this.ok(list3);
    }

    public ResponseEntity<List<AccountHistoryResult>> searchAccountHistory(AccountsApi.SearchAccountHistoryParams searchAccountHistoryParams) {
        AccountHistoryQueryFilters accountHistoryQueryFilters = (AccountHistoryQueryFilters)ClassHelper.convert((Object)searchAccountHistoryParams, AccountHistoryQueryFilters.class);
        AccountHistoryQuery accountHistoryQuery = this.accountsApiHelper.toAccountHistoryQuery(searchAccountHistoryParams.owner, searchAccountHistoryParams.accountType, accountHistoryQueryFilters);
        accountHistoryQuery.setUsersWithImage(true);
        Page page = this.accountService.searchAccountHistory(accountHistoryQuery);
        return this.pageResponse(page, this.accountsApiHelper::toAccountHistoryResult);
    }

    public ResponseEntity<List<UserWithBalanceResult>> searchUsersWithBalances(AccountsApi.SearchUsersWithBalancesParams searchUsersWithBalancesParams) {
        UsersWithBalanceQueryFilters usersWithBalanceQueryFilters = (UsersWithBalanceQueryFilters)ClassHelper.convert((Object)searchUsersWithBalancesParams, UsersWithBalanceQueryFilters.class);
        UserWithBalanceQuery userWithBalanceQuery = this.accountsApiHelper.toUserWithBalanceQuery(usersWithBalanceQueryFilters);
        Page page = this.accountService.searchUsersWithBalances(userWithBalanceQuery);
        return this.pageResponse(page, this.accountsApiHelper::toUserWithBalanceResult);
    }
}

