/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.AddressesApiImpl;
import org.cyclos.web.rest.model.Address;
import org.cyclos.web.rest.model.AddressDataForEdit;
import org.cyclos.web.rest.model.AddressDataForNew;
import org.cyclos.web.rest.model.AddressEdit;
import org.cyclos.web.rest.model.AddressNew;
import org.cyclos.web.rest.model.AddressResult;
import org.cyclos.web.rest.model.AddressView;
import org.cyclos.web.rest.model.Country;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.PasswordInput;
import org.cyclos.web.rest.model.UserAddressesListData;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class AddressesApi {
    @Autowired
    private AddressesApiImpl impl;
    public static final String CREATE_ADDRESS = "/{user}/addresses";
    public static final String DELETE_ADDRESS = "/addresses/{id}";
    public static final String GET_ADDRESS_DATA_FOR_EDIT = "/addresses/{id}/data-for-edit";
    public static final String GET_ADDRESS_DATA_FOR_NEW = "/{user}/addresses/data-for-new";
    public static final String GET_PASSWORD_INPUT_FOR_REMOVE_ADDRESS = "/addresses/{id}/password-for-remove";
    public static final String GET_USER_ADDRESSES_LIST_DATA = "/{user}/addresses/list-data";
    public static final String GET_USER_PRIMARY_ADDRESS = "/{user}/addresses/primary";
    public static final String LIST_ADDRESSES_BY_USER = "/{user}/addresses";
    public static final String LIST_COUNTRIES = "/addresses/countries";
    public static final String UPDATE_ADDRESS = "/addresses/{id}";
    public static final String VIEW_ADDRESS = "/addresses/{id}";

    @RequestMapping(value={"/api/{user:.*}/addresses"}, produces={"text/plain", "application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> createAddress(@PathVariable(value="user") String string, @RequestBody(required=true) AddressNew addressNew, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/addresses");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.createAddress(string, addressNew, string2);
    }

    @RequestMapping(value={"/api/addresses/{id}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteAddress(@PathVariable(value="id") String string, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /addresses/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.deleteAddress(string, string2);
    }

    @RequestMapping(value={"/api/addresses/{id}/data-for-edit"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<AddressDataForEdit> getAddressDataForEdit(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /addresses/{id}/data-for-edit");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getAddressDataForEdit(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/addresses/data-for-new"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<AddressDataForNew> getAddressDataForNew(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/addresses/data-for-new");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getAddressDataForNew(string, list);
    }

    @RequestMapping(value={"/api/addresses/{id}/password-for-remove"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<PasswordInput> getPasswordInputForRemoveAddress(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /addresses/{id}/password-for-remove");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getPasswordInputForRemoveAddress(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/addresses/list-data"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UserAddressesListData> getUserAddressesListData(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/addresses/list-data");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserAddressesListData(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/addresses/primary"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<Address> getUserPrimaryAddress(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/addresses/primary");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserPrimaryAddress(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/addresses"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<AddressResult>> listAddressesByUser(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/addresses");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.listAddressesByUser(string, list);
    }

    @RequestMapping(value={"/api/addresses/countries"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Country>> listCountries(HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /addresses/countries");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.listCountries();
    }

    @RequestMapping(value={"/api/addresses/{id}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> updateAddress(@PathVariable(value="id") String string, @RequestBody(required=true) AddressEdit addressEdit, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /addresses/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.updateAddress(string, addressEdit, string2);
    }

    @RequestMapping(value={"/api/addresses/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<AddressView> viewAddress(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /addresses/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.viewAddress(string, list);
    }
}

