/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.users.addresses.UserAddressDTO;
import org.cyclos.model.users.addresses.UserAddressData;
import org.cyclos.model.users.addresses.UserAddressDataParams;
import org.cyclos.model.users.addresses.UserAddressListData;
import org.cyclos.model.users.addresses.UserAddressVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.services.system.LocalizationService;
import org.cyclos.services.users.UserAddressService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.helpers.AddressesApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.model.Address;
import org.cyclos.web.rest.model.AddressDataForEdit;
import org.cyclos.web.rest.model.AddressDataForNew;
import org.cyclos.web.rest.model.AddressEdit;
import org.cyclos.web.rest.model.AddressNew;
import org.cyclos.web.rest.model.AddressResult;
import org.cyclos.web.rest.model.AddressView;
import org.cyclos.web.rest.model.Country;
import org.cyclos.web.rest.model.PasswordInput;
import org.cyclos.web.rest.model.UserAddressesListData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class AddressesApiImpl
extends BaseApiImpl {
    @Autowired
    private UserAddressService addressService;
    @Autowired
    private AddressesApiHelper addressesApiHelper;
    @Autowired
    private LocalizationService localizationService;
    @Autowired
    private AuthApiHelper authApiHelper;

    public ResponseEntity<String> createAddress(String string, AddressNew addressNew, String string2) {
        UserAddressDTO userAddressDTO = this.addressesApiHelper.toAddressDTO(addressNew);
        userAddressDTO.setUser((UserVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        String string3 = ApiHelper.toId(this.addressService.saveWithConfirmationPassword((EntityDTO)userAddressDTO, string2));
        return this.created(this.apiHelper.uriFromApi("addresses", string3), string3);
    }

    public ResponseEntity<Void> deleteAddress(String string, String string2) {
        this.addressService.removeWithConfirmationPassword(this.apiHelper.fromId(string), string2);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<AddressDataForEdit> getAddressDataForEdit(String string, List<String> list) {
        UserAddressData userAddressData = (UserAddressData)this.addressService.getData(this.apiHelper.fromId(string));
        return this.ok(this.addressesApiHelper.toDataForEdit(userAddressData));
    }

    public ResponseEntity<AddressDataForNew> getAddressDataForNew(String string, List<String> list) {
        UserAddressDataParams userAddressDataParams = new UserAddressDataParams();
        userAddressDataParams.setUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        userAddressDataParams.setSuggestAddressName(true);
        UserAddressData userAddressData = (UserAddressData)this.addressService.getDataForNew((Object)userAddressDataParams);
        return this.ok(this.addressesApiHelper.toDataForNew(userAddressData));
    }

    public ResponseEntity<PasswordInput> getPasswordInputForRemoveAddress(String string, List<String> list) {
        CredentialInputDTO credentialInputDTO = this.addressService.getConfirmationPasswordInputForRemove(this.apiHelper.fromId(string));
        PasswordInput passwordInput = this.authApiHelper.toPasswordInput((ICredentialInputDTO)credentialInputDTO);
        return this.ok(passwordInput);
    }

    public ResponseEntity<UserAddressesListData> getUserAddressesListData(String string, List<String> list) {
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
        UserAddressListData userAddressListData = this.addressService.getAddressListData(userLocatorVO);
        UserAddressesListData userAddressesListData = this.addressesApiHelper.toUserAddressesListData(userAddressListData);
        return this.ok(userAddressesListData);
    }

    public ResponseEntity<Address> getUserPrimaryAddress(String string, List<String> list) {
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
        UserAddressListData userAddressListData = this.addressService.getAddressListData(userLocatorVO);
        Optional<Address> optional = userAddressListData.getAddresses().stream().filter(geoLocatedAddressVO -> ((UserAddressVO)geoLocatedAddressVO).isDefaultAddress()).map(this.addressesApiHelper::toAddress).findFirst();
        return this.okOrNoContent(optional);
    }

    public ResponseEntity<List<AddressResult>> listAddressesByUser(String string, List<String> list) {
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
        UserAddressListData userAddressListData = this.addressService.getAddressListData(userLocatorVO);
        UserAddressesListData userAddressesListData = this.addressesApiHelper.toUserAddressesListData(userAddressListData);
        return this.ok(userAddressesListData.getAddresses());
    }

    public ResponseEntity<List<Country>> listCountries() {
        List list = CollectionHelper.orEmpty((List)this.localizationService.listCountries()).stream().map(this.addressesApiHelper::toCountry).collect(Collectors.toList());
        return this.ok(list);
    }

    public ResponseEntity<Void> updateAddress(String string, AddressEdit addressEdit, String string2) {
        UserAddressDTO userAddressDTO = this.addressesApiHelper.toAddressDTO(addressEdit);
        userAddressDTO.setId(this.apiHelper.fromId(string));
        this.addressService.saveWithConfirmationPassword((EntityDTO)userAddressDTO, string2);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<AddressView> viewAddress(String string, List<String> list) {
        UserAddressData userAddressData = (UserAddressData)this.addressService.getData(this.apiHelper.fromId(string));
        return this.ok(this.addressesApiHelper.toAddressView(userAddressData));
    }
}

