/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.AgreementsApiImpl;
import org.cyclos.web.rest.model.Agreement;
import org.cyclos.web.rest.model.AgreementContent;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.UserAgreementsData;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class AgreementsApi {
    @Autowired
    private AgreementsApiImpl impl;
    public static final String ACCEPT_OPTIONAL_AGREEMENTS = "/agreements/optional";
    public static final String ACCEPT_PENDING_AGREEMENT = "/agreements/accept";
    public static final String GET_AGREEMENT_CONTENT = "/agreements/{key}/content";
    public static final String GET_USER_AGREEMENTS = "/{user}/agreements";
    public static final String LIST_PENDING_AGREEMENTS = "/agreements/pending";

    @RequestMapping(value={"/api/agreements/optional"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> acceptOptionalAgreements(@RequestParam(value="agreements", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /agreements/optional");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.acceptOptionalAgreements(list);
    }

    @RequestMapping(value={"/api/agreements/accept"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> acceptPendingAgreement(@RequestParam(value="agreements", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /agreements/accept");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.acceptPendingAgreement(list);
    }

    @RequestMapping(value={"/api/agreements/{key}/content"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<AgreementContent> getAgreementContent(@PathVariable(value="key") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="version", required=false) Integer n, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /agreements/{key}/content");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getAgreementContent(string, list, n);
    }

    @RequestMapping(value={"/api/{user:.*}/agreements"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UserAgreementsData> getUserAgreements(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/agreements");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserAgreements(string, list);
    }

    @RequestMapping(value={"/api/agreements/pending"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Agreement>> listPendingAgreements(@RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /agreements/pending");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.listPendingAgreements(list);
    }
}

