/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.access.agreements.AgreementContentVO;
import org.cyclos.model.access.agreements.AgreementVO;
import org.cyclos.model.access.agreements.UserAgreementsData;
import org.cyclos.model.access.agreements.UserOptionalAgreementsDTO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.services.access.AgreementLogService;
import org.cyclos.services.access.AgreementService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.helpers.AgreementsApiHelper;
import org.cyclos.web.rest.model.Agreement;
import org.cyclos.web.rest.model.AgreementContent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class AgreementsApiImpl
extends BaseApiImpl {
    @Autowired
    private AgreementService agreementService;
    @Autowired
    private AgreementLogService agreementLogService;
    @Autowired
    private AgreementsApiHelper agreementsApiHelper;

    public ResponseEntity<Void> acceptOptionalAgreements(List<String> list) {
        Set set = CollectionHelper.orEmpty(list).stream().map(string -> (AgreementVO)ModelHelper.voFromString(AgreementVO.class, (String)string)).collect(Collectors.toSet());
        UserOptionalAgreementsDTO userOptionalAgreementsDTO = new UserOptionalAgreementsDTO();
        userOptionalAgreementsDTO.setAgreements(set);
        this.agreementLogService.saveOptional(userOptionalAgreementsDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> acceptPendingAgreement(List<String> list) {
        Set set = ModelHelper.vosFromString(AgreementVO.class, list);
        this.agreementLogService.acceptPending(set);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<AgreementContent> getAgreementContent(String string, List<String> list, Integer n) {
        AgreementVO agreementVO = (AgreementVO)ModelHelper.voFromString(AgreementVO.class, (String)string);
        AgreementContentVO agreementContentVO = this.agreementService.getContent(agreementVO, n, null);
        AgreementContent agreementContent = this.agreementsApiHelper.toAgreementContent(agreementContentVO);
        return this.ok(agreementContent);
    }

    public ResponseEntity<org.cyclos.web.rest.model.UserAgreementsData> getUserAgreements(String string, List<String> list) {
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
        UserAgreementsData userAgreementsData = this.agreementLogService.getData(userLocatorVO);
        org.cyclos.web.rest.model.UserAgreementsData userAgreementsData2 = this.agreementsApiHelper.toUserAgreementsData(userAgreementsData);
        return this.ok(userAgreementsData2);
    }

    public ResponseEntity<List<Agreement>> listPendingAgreements(List<String> list) {
        UserAgreementsData userAgreementsData = this.agreementLogService.getData(null);
        List list2 = CollectionHelper.sort((Collection)userAgreementsData.getPending());
        List list3 = list2.stream().map(this.agreementsApiHelper::toAgreement).collect(Collectors.toList());
        return this.ok(list3);
    }
}

