/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.utils.DateTime;
import org.cyclos.web.rest.api.AlertsApiImpl;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.UserAlert;
import org.cyclos.web.rest.model.UserAlertDataForSearch;
import org.cyclos.web.rest.model.UserAlertTypeEnum;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class AlertsApi {
    @Autowired
    private AlertsApiImpl impl;
    public static final String GET_USER_ALERT_DATA_FOR_SEARCH = "/alerts/user/data-for-search";
    public static final String SEARCH_USER_ALERTS = "/alerts/user";

    @RequestMapping(value={"/api/alerts/user/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UserAlertDataForSearch> getUserAlertDataForSearch(@RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /alerts/user/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserAlertDataForSearch(list);
    }

    @RequestMapping(value={"/api/alerts/user"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<UserAlert>> searchUserAlerts(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="brokers", required=false) List<String> list2, @RequestParam(value="datePeriod", required=false) List<DateTime> list3, @RequestParam(value="groups", required=false) List<String> list4, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl, @RequestParam(value="types", required=false) List<UserAlertTypeEnum> list5, @RequestParam(value="user", required=false) String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /alerts/user");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchUserAlertsParams searchUserAlertsParams = new SearchUserAlertsParams();
        searchUserAlertsParams.fields = list;
        searchUserAlertsParams.brokers = list2;
        searchUserAlertsParams.datePeriod = list3;
        searchUserAlertsParams.groups = list4;
        searchUserAlertsParams.page = n;
        searchUserAlertsParams.pageSize = n2;
        searchUserAlertsParams.skipTotalCount = bl;
        searchUserAlertsParams.types = list5;
        searchUserAlertsParams.user = string;
        return this.impl.searchUserAlerts(searchUserAlertsParams);
    }

    public static class SearchUserAlertsParams {
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public List<DateTime> datePeriod;
        public static final String DATE_PERIOD = "datePeriod";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<UserAlertTypeEnum> types;
        public static final String TYPES = "types";
        public String user;
        public static final String USER = "user";
    }
}

