/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.BalanceLimitsApiImpl;
import org.cyclos.web.rest.model.AccountBalanceLimitsData;
import org.cyclos.web.rest.model.DataForBalanceLimitsSearch;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.GeneralAccountBalanceLimitsResult;
import org.cyclos.web.rest.model.SetAccountBalanceLimits;
import org.cyclos.web.rest.model.UserAccountBalanceLimitsListData;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class BalanceLimitsApi {
    @Autowired
    private BalanceLimitsApiImpl impl;
    public static final String EXPORT_ACCOUNT_BALANCE_LIMITS = "/accounts/balance-limits/export/{format}";
    public static final String GET_ACCOUNT_BALANCE_LIMITS = "/{user}/accounts/{accountType}/balance-limits";
    public static final String GET_ACCOUNT_BALANCE_LIMITS_DATA = "/accounts/data-for-balance-limits";
    public static final String GET_DATA_FOR_USER_BALANCE_LIMITS = "/{user}/accounts/data-for-balance-limits";
    public static final String SEARCH_ACCOUNT_BALANCE_LIMITS = "/accounts/balance-limits";
    public static final String SET_ACCOUNT_BALANCE_LIMITS = "/{user}/accounts/{accountType}/balance-limits";

    @RequestMapping(value={"/api/accounts/balance-limits/export/{format}"}, produces={"*/*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> exportAccountBalanceLimits(@PathVariable(value="format") String string, @RequestParam(value="accountType", required=false) String string2, @RequestParam(value="brokers", required=false) List<String> list, @RequestParam(value="by", required=false) String string3, @RequestParam(value="currency", required=false) String string4, @RequestParam(value="customLimit", required=false) Boolean bl, @RequestParam(value="customLimitRange", required=false) List<BigDecimal> list2, @RequestParam(value="customUpperLimit", required=false) Boolean bl2, @RequestParam(value="customUpperLimitRange", required=false) List<BigDecimal> list3, @RequestParam(value="groups", required=false) List<String> list4, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl3, @RequestParam(value="user", required=false) String string5, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /accounts/balance-limits/export/{format}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        ExportAccountBalanceLimitsParams exportAccountBalanceLimitsParams = new ExportAccountBalanceLimitsParams();
        exportAccountBalanceLimitsParams.format = string;
        exportAccountBalanceLimitsParams.accountType = string2;
        exportAccountBalanceLimitsParams.brokers = list;
        exportAccountBalanceLimitsParams.by = string3;
        exportAccountBalanceLimitsParams.currency = string4;
        exportAccountBalanceLimitsParams.customLimit = bl;
        exportAccountBalanceLimitsParams.customLimitRange = list2;
        exportAccountBalanceLimitsParams.customUpperLimit = bl2;
        exportAccountBalanceLimitsParams.customUpperLimitRange = list3;
        exportAccountBalanceLimitsParams.groups = list4;
        exportAccountBalanceLimitsParams.page = n;
        exportAccountBalanceLimitsParams.pageSize = n2;
        exportAccountBalanceLimitsParams.skipTotalCount = bl3;
        exportAccountBalanceLimitsParams.user = string5;
        return this.impl.exportAccountBalanceLimits(exportAccountBalanceLimitsParams);
    }

    @RequestMapping(value={"/api/{user:.*}/accounts/{accountType}/balance-limits"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<AccountBalanceLimitsData> getAccountBalanceLimits(@PathVariable(value="user") String string, @PathVariable(value="accountType") String string2, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/accounts/{accountType}/balance-limits");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getAccountBalanceLimits(string, string2, list);
    }

    @RequestMapping(value={"/api/accounts/data-for-balance-limits"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForBalanceLimitsSearch> getAccountBalanceLimitsData(@RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /accounts/data-for-balance-limits");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getAccountBalanceLimitsData(list);
    }

    @RequestMapping(value={"/api/{user:.*}/accounts/data-for-balance-limits"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UserAccountBalanceLimitsListData> getDataForUserBalanceLimits(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/accounts/data-for-balance-limits");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getDataForUserBalanceLimits(string, list);
    }

    @RequestMapping(value={"/api/accounts/balance-limits"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<GeneralAccountBalanceLimitsResult>> searchAccountBalanceLimits(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="accountType", required=false) String string, @RequestParam(value="brokers", required=false) List<String> list2, @RequestParam(value="by", required=false) String string2, @RequestParam(value="currency", required=false) String string3, @RequestParam(value="customLimit", required=false) Boolean bl, @RequestParam(value="customLimitRange", required=false) List<BigDecimal> list3, @RequestParam(value="customUpperLimit", required=false) Boolean bl2, @RequestParam(value="customUpperLimitRange", required=false) List<BigDecimal> list4, @RequestParam(value="groups", required=false) List<String> list5, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl3, @RequestParam(value="user", required=false) String string4, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /accounts/balance-limits");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchAccountBalanceLimitsParams searchAccountBalanceLimitsParams = new SearchAccountBalanceLimitsParams();
        searchAccountBalanceLimitsParams.fields = list;
        searchAccountBalanceLimitsParams.accountType = string;
        searchAccountBalanceLimitsParams.brokers = list2;
        searchAccountBalanceLimitsParams.by = string2;
        searchAccountBalanceLimitsParams.currency = string3;
        searchAccountBalanceLimitsParams.customLimit = bl;
        searchAccountBalanceLimitsParams.customLimitRange = list3;
        searchAccountBalanceLimitsParams.customUpperLimit = bl2;
        searchAccountBalanceLimitsParams.customUpperLimitRange = list4;
        searchAccountBalanceLimitsParams.groups = list5;
        searchAccountBalanceLimitsParams.page = n;
        searchAccountBalanceLimitsParams.pageSize = n2;
        searchAccountBalanceLimitsParams.skipTotalCount = bl3;
        searchAccountBalanceLimitsParams.user = string4;
        return this.impl.searchAccountBalanceLimits(searchAccountBalanceLimitsParams);
    }

    @RequestMapping(value={"/api/{user:.*}/accounts/{accountType}/balance-limits"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> setAccountBalanceLimits(@PathVariable(value="user") String string, @PathVariable(value="accountType") String string2, @RequestHeader(value="confirmationPassword", required=false) String string3, @RequestBody(required=false) SetAccountBalanceLimits setAccountBalanceLimits, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /{user}/accounts/{accountType}/balance-limits");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SetAccountBalanceLimitsParams setAccountBalanceLimitsParams = new SetAccountBalanceLimitsParams();
        setAccountBalanceLimitsParams.user = string;
        setAccountBalanceLimitsParams.accountType = string2;
        setAccountBalanceLimitsParams.confirmationPassword = string3;
        setAccountBalanceLimitsParams.setAccountBalanceLimits = setAccountBalanceLimits;
        return this.impl.setAccountBalanceLimits(setAccountBalanceLimitsParams);
    }

    public static class ExportAccountBalanceLimitsParams {
        public String format;
        public static final String FORMAT = "format";
        public String accountType;
        public static final String ACCOUNT_TYPE = "accountType";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String by;
        public static final String BY = "by";
        public String currency;
        public static final String CURRENCY = "currency";
        public Boolean customLimit;
        public static final String CUSTOM_LIMIT = "customLimit";
        public List<BigDecimal> customLimitRange;
        public static final String CUSTOM_LIMIT_RANGE = "customLimitRange";
        public Boolean customUpperLimit;
        public static final String CUSTOM_UPPER_LIMIT = "customUpperLimit";
        public List<BigDecimal> customUpperLimitRange;
        public static final String CUSTOM_UPPER_LIMIT_RANGE = "customUpperLimitRange";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public String user;
        public static final String USER = "user";
    }

    public static class SearchAccountBalanceLimitsParams {
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String accountType;
        public static final String ACCOUNT_TYPE = "accountType";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String by;
        public static final String BY = "by";
        public String currency;
        public static final String CURRENCY = "currency";
        public Boolean customLimit;
        public static final String CUSTOM_LIMIT = "customLimit";
        public List<BigDecimal> customLimitRange;
        public static final String CUSTOM_LIMIT_RANGE = "customLimitRange";
        public Boolean customUpperLimit;
        public static final String CUSTOM_UPPER_LIMIT = "customUpperLimit";
        public List<BigDecimal> customUpperLimitRange;
        public static final String CUSTOM_UPPER_LIMIT_RANGE = "customUpperLimitRange";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public String user;
        public static final String USER = "user";
    }

    public static class SetAccountBalanceLimitsParams {
        public String user;
        public static final String USER = "user";
        public String accountType;
        public static final String ACCOUNT_TYPE = "accountType";
        public String confirmationPassword;
        public static final String CONFIRMATION_PASSWORD = "confirmationPassword";
        public SetAccountBalanceLimits setAccountBalanceLimits;
        public static final String SET_ACCOUNT_BALANCE_LIMITS = "setAccountBalanceLimits";
    }
}

