/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.BrokeringApiImpl;
import org.cyclos.web.rest.model.BrokerDataForAdd;
import org.cyclos.web.rest.model.BrokeringView;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.UserBrokersData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class BrokeringApi {
    @Autowired
    private BrokeringApiImpl impl;
    public static final String ADD_BROKER = "/{user}/brokers/{broker}";
    public static final String GET_BROKER_DATA_FOR_ADD = "/{user}/brokers/data-for-add";
    public static final String GET_USER_BROKERS_DATA = "/{user}/brokers";
    public static final String REMOVE_BROKER = "/{user}/brokers/{broker}";
    public static final String SET_MAIN_BROKER = "/{user}/brokers/{broker}/set-main";
    public static final String VIEW_BROKERING = "/{user}/brokers/{broker}";

    @RequestMapping(value={"/api/{user:.*}/brokers/{broker}"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> addBroker(@PathVariable(value="user") String string, @PathVariable(value="broker") String string2, @RequestParam(value="main", required=false) Boolean bl, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/brokers/{broker}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.addBroker(string, string2, bl);
    }

    @RequestMapping(value={"/api/{user:.*}/brokers/data-for-add"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<BrokerDataForAdd> getBrokerDataForAdd(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/brokers/data-for-add");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getBrokerDataForAdd(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/brokers"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UserBrokersData> getUserBrokersData(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/brokers");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getUserBrokersData(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/brokers/{broker}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> removeBroker(@PathVariable(value="user") String string, @PathVariable(value="broker") String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /{user}/brokers/{broker}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.removeBroker(string, string2);
    }

    @RequestMapping(value={"/api/{user:.*}/brokers/{broker}/set-main"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> setMainBroker(@PathVariable(value="user") String string, @PathVariable(value="broker") String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/brokers/{broker}/set-main");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.setMainBroker(string, string2);
    }

    @RequestMapping(value={"/api/{user:.*}/brokers/{broker}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<BrokeringView> viewBrokering(@PathVariable(value="user") String string, @PathVariable(value="broker") String string2, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/brokers/{broker}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.viewBrokering(string, string2, list);
    }
}

