/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.users.contactinfos.ContactInfoDTO;
import org.cyclos.model.users.contactinfos.ContactInfoData;
import org.cyclos.model.users.contactinfos.ContactInfoListData;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.services.users.ContactInfoService;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.ContactInfosApiHelper;
import org.cyclos.web.rest.model.ContactInfoDataForEdit;
import org.cyclos.web.rest.model.ContactInfoDataForNew;
import org.cyclos.web.rest.model.ContactInfoEdit;
import org.cyclos.web.rest.model.ContactInfoNew;
import org.cyclos.web.rest.model.ContactInfoResult;
import org.cyclos.web.rest.model.ContactInfoView;
import org.cyclos.web.rest.model.PasswordInput;
import org.cyclos.web.rest.model.UserContactInfosListData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class ContactInfosApiImpl
extends BaseApiImpl {
    @Autowired
    private ContactInfoService contactInfoService;
    @Autowired
    private ContactInfosApiHelper contactInfosApiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;

    public ResponseEntity<String> createContactInfo(String string, ContactInfoNew contactInfoNew, String string2) {
        ContactInfoDTO contactInfoDTO = this.contactInfosApiHelper.toContactInfoDTO(contactInfoNew);
        contactInfoDTO.setUser((UserVO)ModelHelper.voFromString(UserVO.class, (String)string));
        Long l = this.contactInfoService.saveWithConfirmationPassword((EntityDTO)contactInfoDTO, string2);
        return this.created(this.apiHelper.uriFromApi("contact-infos", l), l);
    }

    public ResponseEntity<Void> deleteContactInfo(String string, String string2) {
        this.contactInfoService.removeWithConfirmationPassword(this.apiHelper.fromId(string), string2);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<ContactInfoDataForEdit> getContactInfoDataForEdit(String string, List<String> list) {
        ContactInfoData contactInfoData = (ContactInfoData)this.contactInfoService.getData(this.apiHelper.fromId(string));
        ContactInfoDataForEdit contactInfoDataForEdit = this.contactInfosApiHelper.toContactInfoDataForEdit(contactInfoData);
        return this.ok(contactInfoDataForEdit);
    }

    public ResponseEntity<ContactInfoDataForNew> getContactInfoDataForNew(String string, List<String> list) {
        ContactInfoData contactInfoData = (ContactInfoData)this.contactInfoService.getDataForNew((Object)((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string)));
        ContactInfoDataForNew contactInfoDataForNew = this.contactInfosApiHelper.toContactInfoDataForNew(contactInfoData);
        return this.ok(contactInfoDataForNew);
    }

    public ResponseEntity<PasswordInput> getPasswordInputForRemoveContactInfo(String string, List<String> list) {
        CredentialInputDTO credentialInputDTO = this.contactInfoService.getConfirmationPasswordInputForRemove(this.apiHelper.fromId(string));
        PasswordInput passwordInput = this.authApiHelper.toPasswordInput((ICredentialInputDTO)credentialInputDTO);
        return this.ok(passwordInput);
    }

    public ResponseEntity<UserContactInfosListData> getUserContactInfosListData(String string, List<String> list) {
        ContactInfoListData contactInfoListData = this.contactInfoService.getContactInfoListData((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string), false);
        UserContactInfosListData userContactInfosListData = this.contactInfosApiHelper.toUserContactInfosListData(contactInfoListData);
        return this.ok(userContactInfosListData);
    }

    public ResponseEntity<List<ContactInfoResult>> listContactInfosByUser(String string, List<String> list) {
        ContactInfoListData contactInfoListData = this.contactInfoService.getContactInfoListData((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string), false);
        UserContactInfosListData userContactInfosListData = this.contactInfosApiHelper.toUserContactInfosListData(contactInfoListData);
        return this.ok(userContactInfosListData.getContactInfos());
    }

    public ResponseEntity<Void> updateContactInfo(String string, ContactInfoEdit contactInfoEdit, String string2) {
        ContactInfoDTO contactInfoDTO = this.contactInfosApiHelper.toContactInfoDTO(contactInfoEdit);
        contactInfoDTO.setId(this.apiHelper.fromId(string));
        this.contactInfoService.saveWithConfirmationPassword((EntityDTO)contactInfoDTO, string2);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<ContactInfoView> viewContactInfo(String string, List<String> list) {
        ContactInfoData contactInfoData = (ContactInfoData)this.contactInfoService.getData(this.apiHelper.fromId(string));
        ContactInfoView contactInfoView = this.contactInfosApiHelper.toContactInfoView(contactInfoData);
        return this.ok(contactInfoView);
    }
}

