/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.ContactsApiImpl;
import org.cyclos.web.rest.model.ContactDataForEdit;
import org.cyclos.web.rest.model.ContactDataForNew;
import org.cyclos.web.rest.model.ContactEdit;
import org.cyclos.web.rest.model.ContactListDataForSearch;
import org.cyclos.web.rest.model.ContactNew;
import org.cyclos.web.rest.model.ContactOrderByEnum;
import org.cyclos.web.rest.model.ContactResult;
import org.cyclos.web.rest.model.ContactView;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.UserResult;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class ContactsApi {
    @Autowired
    private ContactsApiImpl impl;
    public static final String CREATE_CONTACT = "/{user}/contact-list";
    public static final String DELETE_CONTACT = "/contact-list/{id}";
    public static final String GET_CONTACT_DATA_FOR_EDIT = "/contact-list/{id}/data-for-edit";
    public static final String GET_CONTACT_LIST_DATA_FOR_NEW = "/{user}/contact-list/data-for-new";
    public static final String GET_CONTACT_LIST_DATA_FOR_SEARCH = "/{user}/contact-list/data-for-search";
    public static final String SEARCH_CONTACT_LIST = "/{user}/contact-list";
    public static final String SEARCH_CONTACTS = "/{user}/contacts";
    public static final String UPDATE_CONTACT = "/contact-list/{id}";
    public static final String VIEW_CONTACT = "/contact-list/{id}";

    @RequestMapping(value={"/api/{user:.*}/contact-list"}, produces={"text/plain", "application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> createContact(@PathVariable(value="user") String string, @RequestBody(required=true) ContactNew contactNew, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/contact-list");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.createContact(string, contactNew);
    }

    @RequestMapping(value={"/api/contact-list/{id}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteContact(@PathVariable(value="id") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /contact-list/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.deleteContact(string);
    }

    @RequestMapping(value={"/api/contact-list/{id}/data-for-edit"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ContactDataForEdit> getContactDataForEdit(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /contact-list/{id}/data-for-edit");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getContactDataForEdit(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/contact-list/data-for-new"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ContactDataForNew> getContactListDataForNew(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="contactUser", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/contact-list/data-for-new");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getContactListDataForNew(string, list, string2);
    }

    @RequestMapping(value={"/api/{user:.*}/contact-list/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ContactListDataForSearch> getContactListDataForSearch(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/contact-list/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getContactListDataForSearch(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/contact-list"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<ContactResult>> searchContactList(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="customFields", required=false) List<String> list2, @RequestParam(value="keywords", required=false) String string2, @RequestParam(value="orderBy", required=false) ContactOrderByEnum contactOrderByEnum, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl, @RequestParam(value="usersToExclude", required=false) List<String> list3, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/contact-list");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchContactListParams searchContactListParams = new SearchContactListParams();
        searchContactListParams.user = string;
        searchContactListParams.fields = list;
        searchContactListParams.customFields = list2;
        searchContactListParams.keywords = string2;
        searchContactListParams.orderBy = contactOrderByEnum;
        searchContactListParams.page = n;
        searchContactListParams.pageSize = n2;
        searchContactListParams.skipTotalCount = bl;
        searchContactListParams.usersToExclude = list3;
        return this.impl.searchContactList(searchContactListParams);
    }

    @RequestMapping(value={"/api/{user:.*}/contacts"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<UserResult>> searchContacts(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="ignoreProfileFieldsInList", required=false) Boolean bl, @RequestParam(value="includeGroup", required=false) Boolean bl2, @RequestParam(value="includeGroupSet", required=false) Boolean bl3, @RequestParam(value="keywords", required=false) String string2, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="profileFields", required=false) List<String> list2, @RequestParam(value="skipTotalCount", required=false) Boolean bl4, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/contacts");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchContactsParams searchContactsParams = new SearchContactsParams();
        searchContactsParams.user = string;
        searchContactsParams.fields = list;
        searchContactsParams.ignoreProfileFieldsInList = bl;
        searchContactsParams.includeGroup = bl2;
        searchContactsParams.includeGroupSet = bl3;
        searchContactsParams.keywords = string2;
        searchContactsParams.page = n;
        searchContactsParams.pageSize = n2;
        searchContactsParams.profileFields = list2;
        searchContactsParams.skipTotalCount = bl4;
        return this.impl.searchContacts(searchContactsParams);
    }

    @RequestMapping(value={"/api/contact-list/{id}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> updateContact(@PathVariable(value="id") String string, @RequestBody(required=true) ContactEdit contactEdit, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /contact-list/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.updateContact(string, contactEdit);
    }

    @RequestMapping(value={"/api/contact-list/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ContactView> viewContact(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /contact-list/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.viewContact(string, list);
    }

    public static class SearchContactListParams {
        public String user;
        public static final String USER = "user";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public String keywords;
        public static final String KEYWORDS = "keywords";
        public ContactOrderByEnum orderBy;
        public static final String ORDER_BY = "orderBy";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<String> usersToExclude;
        public static final String USERS_TO_EXCLUDE = "usersToExclude";
    }

    public static class SearchContactsParams {
        public String user;
        public static final String USER = "user";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public Boolean ignoreProfileFieldsInList;
        public static final String IGNORE_PROFILE_FIELDS_IN_LIST = "ignoreProfileFieldsInList";
        public Boolean includeGroup;
        public static final String INCLUDE_GROUP = "includeGroup";
        public Boolean includeGroupSet;
        public static final String INCLUDE_GROUP_SET = "includeGroupSet";
        public String keywords;
        public static final String KEYWORDS = "keywords";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public List<String> profileFields;
        public static final String PROFILE_FIELDS = "profileFields";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
    }
}

