/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.DeviceConfirmationsApiImpl;
import org.cyclos.web.rest.model.CreateDeviceConfirmation;
import org.cyclos.web.rest.model.DataForDeviceConfirmationApproval;
import org.cyclos.web.rest.model.DeviceConfirmationActionParams;
import org.cyclos.web.rest.model.DeviceConfirmationView;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.ImageSizeEnum;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class DeviceConfirmationsApi {
    @Autowired
    private DeviceConfirmationsApiImpl impl;
    public static final String APPROVE_DEVICE_CONFIRMATION = "/device-confirmations/{id}/approve";
    public static final String CREATE_DEVICE_CONFIRMATION = "/device-confirmations";
    public static final String DATA_FOR_DEVICE_CONFIRMATION_APPROVAL = "/device-confirmations/data-for-approval";
    public static final String DELETE_DEVICE_CONFIRMATION = "/device-confirmations/{id}";
    public static final String GET_DEVICE_CONFIRMATION_QR_CODE = "/device-confirmations/{id}/qr-code";
    public static final String REJECT_DEVICE_CONFIRMATION = "/device-confirmations/{id}/reject";
    public static final String VIEW_DEVICE_CONFIRMATION = "/device-confirmations/{id}";

    @RequestMapping(value={"/api/device-confirmations/{id}/approve"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> approveDeviceConfirmation(@PathVariable(value="id") String string, @RequestBody(required=true) DeviceConfirmationActionParams deviceConfirmationActionParams, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /device-confirmations/{id}/approve");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.approveDeviceConfirmation(string, deviceConfirmationActionParams);
    }

    @RequestMapping(value={"/api/device-confirmations"}, produces={"text/plain", "application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> createDeviceConfirmation(@RequestBody(required=true) CreateDeviceConfirmation createDeviceConfirmation, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /device-confirmations");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.createDeviceConfirmation(createDeviceConfirmation);
    }

    @RequestMapping(value={"/api/device-confirmations/data-for-approval"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForDeviceConfirmationApproval> dataForDeviceConfirmationApproval(@RequestParam(value="deviceId", required=true) String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /device-confirmations/data-for-approval");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.dataForDeviceConfirmationApproval(string);
    }

    @RequestMapping(value={"/api/device-confirmations/{id}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteDeviceConfirmation(@PathVariable(value="id") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /device-confirmations/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.deleteDeviceConfirmation(string);
    }

    @RequestMapping(value={"/api/device-confirmations/{id}/qr-code"}, produces={"image/png", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> getDeviceConfirmationQrCode(@PathVariable(value="id") String string, @RequestParam(value="size", required=false) ImageSizeEnum imageSizeEnum, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /device-confirmations/{id}/qr-code");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getDeviceConfirmationQrCode(string, imageSizeEnum);
    }

    @RequestMapping(value={"/api/device-confirmations/{id}/reject"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> rejectDeviceConfirmation(@PathVariable(value="id") String string, @RequestBody(required=true) DeviceConfirmationActionParams deviceConfirmationActionParams, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /device-confirmations/{id}/reject");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.rejectDeviceConfirmation(string, deviceConfirmationActionParams);
    }

    @RequestMapping(value={"/api/device-confirmations/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DeviceConfirmationView> viewDeviceConfirmation(@PathVariable(value="id") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /device-confirmations/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.viewDeviceConfirmation(string);
    }
}

