/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.DevicePinsApiImpl;
import org.cyclos.web.rest.model.CreateDevicePin;
import org.cyclos.web.rest.model.CreateDevicePinResult;
import org.cyclos.web.rest.model.DevicePin;
import org.cyclos.web.rest.model.DevicePinDataForEdit;
import org.cyclos.web.rest.model.DevicePinEdit;
import org.cyclos.web.rest.model.DevicePinRemoveParams;
import org.cyclos.web.rest.model.DevicePinView;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.InputError;
import org.cyclos.web.rest.model.PasswordInput;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class DevicePinsApi {
    @Autowired
    private DevicePinsApiImpl impl;
    public static final String DELETE_DEVICE_PIN = "/device-pins/{key}";
    public static final String GET_DEVICE_PIN_DATA_FOR_EDIT = "/device-pins/{key}/data-for-edit";
    public static final String GET_PASSWORD_INPUT_FOR_CREATE_PIN = "/device-pins/password-for-create";
    public static final String LIST_DEVICE_PINS = "/{user}/device-pins";
    public static final String SET_DEVICE_PIN = "/device-pins";
    public static final String UPDATE_DEVICE_PIN = "/device-pins/{key}";
    public static final String VALIDATE_DEVICE_PIN_VALUE = "/device-pins/validate";
    public static final String VIEW_DEVICE_PIN = "/device-pins/{key}";

    @RequestMapping(value={"/api/device-pins/{key}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteDevicePin(@PathVariable(value="key") String string, @RequestBody(required=true) DevicePinRemoveParams devicePinRemoveParams, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /device-pins/{key}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.deleteDevicePin(string, devicePinRemoveParams);
    }

    @RequestMapping(value={"/api/device-pins/{key}/data-for-edit"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DevicePinDataForEdit> getDevicePinDataForEdit(@PathVariable(value="key") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /device-pins/{key}/data-for-edit");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getDevicePinDataForEdit(string, list);
    }

    @RequestMapping(value={"/api/device-pins/password-for-create"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<PasswordInput> getPasswordInputForCreatePin(@RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /device-pins/password-for-create");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getPasswordInputForCreatePin(list);
    }

    @RequestMapping(value={"/api/{user:.*}/device-pins"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<DevicePin>> listDevicePins(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/device-pins");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.listDevicePins(string, list);
    }

    @RequestMapping(value={"/api/device-pins"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<CreateDevicePinResult> setDevicePin(@RequestBody(required=true) CreateDevicePin createDevicePin, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /device-pins");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.setDevicePin(createDevicePin);
    }

    @RequestMapping(value={"/api/device-pins/{key}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> updateDevicePin(@PathVariable(value="key") String string, @RequestBody(required=true) DevicePinEdit devicePinEdit, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /device-pins/{key}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.updateDevicePin(string, devicePinEdit);
    }

    @RequestMapping(value={"/api/device-pins/validate"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputError> validateDevicePinValue(@RequestParam(value="value", required=true) String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /device-pins/validate");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.validateDevicePinValue(string);
    }

    @RequestMapping(value={"/api/device-pins/{key}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DevicePinView> viewDevicePin(@PathVariable(value="key") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /device-pins/{key}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.viewDevicePin(string, list);
    }
}

