/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.DocumentsApiImpl;
import org.cyclos.web.rest.model.DataForDynamicDocument;
import org.cyclos.web.rest.model.Document;
import org.cyclos.web.rest.model.DocumentDataForEdit;
import org.cyclos.web.rest.model.DocumentDataForNew;
import org.cyclos.web.rest.model.DocumentDataForSearch;
import org.cyclos.web.rest.model.DocumentEdit;
import org.cyclos.web.rest.model.DocumentNew;
import org.cyclos.web.rest.model.DocumentRangeEnum;
import org.cyclos.web.rest.model.DocumentResult;
import org.cyclos.web.rest.model.DocumentView;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.ProcessDynamicDocument;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(produces={"application/json"})
public class DocumentsApi {
    @Autowired
    private DocumentsApiImpl impl;
    public static final String CREATE_SHARED_DOCUMENT = "/documents";
    public static final String CREATE_SHARED_DOCUMENT_WITH_UPLOAD = "/documents/upload";
    public static final String CREATE_USER_DOCUMENT = "/{user}/documents";
    public static final String CREATE_USER_DOCUMENT_WITH_UPLOAD = "/{user}/documents/upload";
    public static final String DELETE_DOCUMENT = "/documents/{id}";
    public static final String DOWNLOAD_DOCUMENT_FILE = "/documents/{id}/file";
    public static final String GET_DATA_FOR_DYNAMIC_DOCUMENT = "/documents/{id}/dynamic/{user}";
    public static final String GET_DOCUMENT_DATA_FOR_EDIT = "/documents/{id}/data-for-edit";
    public static final String GET_DOCUMENTS_DATA_FOR_SEARCH = "/documents/data-for-search";
    public static final String GET_SHARED_DOCUMENT_DATA_FOR_NEW = "/documents/data-for-new";
    public static final String GET_USER_DOCUMENT_DATA_FOR_NEW = "/{user}/documents/data-for-new";
    public static final String LIST_USER_DOCUMENTS = "/{user}/documents";
    public static final String PROCESS_DYNAMIC_DOCUMENT = "/documents/{id}/dynamic/{user}";
    public static final String SEARCH_DOCUMENTS = "/documents";
    public static final String UPDATE_DOCUMENT = "/documents/{id}";
    public static final String UPDATE_DOCUMENT_WITH_UPLOAD = "/documents/{id}/upload";
    public static final String UPLOAD_DOCUMENT_FILE = "/documents/{id}/file";
    public static final String VIEW_DOCUMENT = "/documents/{id}";

    @RequestMapping(value={"/api/documents"}, produces={"text/plain", "application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> createSharedDocument(@RequestBody(required=true) DocumentNew documentNew, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /documents");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.createSharedDocument(documentNew);
    }

    @RequestMapping(value={"/api/documents/upload"}, produces={"text/plain", "application/json"}, consumes={"multipart/form-data"}, method={RequestMethod.POST})
    public ResponseEntity<String> createSharedDocumentWithUpload(@RequestPart(value="file", required=true) MultipartFile multipartFile, @RequestPart(value="document", required=false) DocumentNew documentNew, @RequestPart(value="fileName", required=false) String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /documents/upload");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.createSharedDocumentWithUpload(multipartFile, documentNew, string);
    }

    @RequestMapping(value={"/api/{user:.*}/documents"}, produces={"text/plain", "application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> createUserDocument(@PathVariable(value="user") String string, @RequestBody(required=true) DocumentNew documentNew, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/documents");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.createUserDocument(string, documentNew);
    }

    @RequestMapping(value={"/api/{user:.*}/documents/upload"}, produces={"text/plain", "application/json"}, consumes={"multipart/form-data"}, method={RequestMethod.POST})
    public ResponseEntity<String> createUserDocumentWithUpload(@PathVariable(value="user") String string, @RequestPart(value="file", required=true) MultipartFile multipartFile, @RequestPart(value="document", required=false) DocumentNew documentNew, @RequestPart(value="fileName", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/documents/upload");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        CreateUserDocumentWithUploadParams createUserDocumentWithUploadParams = new CreateUserDocumentWithUploadParams();
        createUserDocumentWithUploadParams.user = string;
        createUserDocumentWithUploadParams.file = multipartFile;
        createUserDocumentWithUploadParams.document = documentNew;
        createUserDocumentWithUploadParams.fileName = string2;
        return this.impl.createUserDocumentWithUpload(createUserDocumentWithUploadParams);
    }

    @RequestMapping(value={"/api/documents/{id}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteDocument(@PathVariable(value="id") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /documents/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.deleteDocument(string);
    }

    @RequestMapping(value={"/api/documents/{id}/file"}, produces={"*/*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> downloadDocumentFile(@PathVariable(value="id") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /documents/{id}/file");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.downloadDocumentFile(string);
    }

    @RequestMapping(value={"/api/documents/{id}/dynamic/{user:.*}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForDynamicDocument> getDataForDynamicDocument(@PathVariable(value="id") String string, @PathVariable(value="user") String string2, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /documents/{id}/dynamic/{user}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getDataForDynamicDocument(string, string2, list);
    }

    @RequestMapping(value={"/api/documents/{id}/data-for-edit"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DocumentDataForEdit> getDocumentDataForEdit(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /documents/{id}/data-for-edit");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getDocumentDataForEdit(string, list);
    }

    @RequestMapping(value={"/api/documents/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DocumentDataForSearch> getDocumentsDataForSearch(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="user", required=false) String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /documents/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getDocumentsDataForSearch(list, string);
    }

    @RequestMapping(value={"/api/documents/data-for-new"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DocumentDataForNew> getSharedDocumentDataForNew(@RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /documents/data-for-new");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getSharedDocumentDataForNew(list);
    }

    @RequestMapping(value={"/api/{user:.*}/documents/data-for-new"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DocumentDataForNew> getUserDocumentDataForNew(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/documents/data-for-new");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserDocumentDataForNew(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/documents"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Document>> listUserDocuments(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/documents");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.listUserDocuments(string, list);
    }

    @RequestMapping(value={"/api/documents/{id}/dynamic/{user:.*}"}, produces={"text/html", "application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> processDynamicDocument(@PathVariable(value="id") String string, @PathVariable(value="user") String string2, @RequestBody(required=false) ProcessDynamicDocument processDynamicDocument, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /documents/{id}/dynamic/{user}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.processDynamicDocument(string, string2, processDynamicDocument);
    }

    @RequestMapping(value={"/api/documents"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<DocumentResult>> searchDocuments(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="brokers", required=false) List<String> list2, @RequestParam(value="categories", required=false) List<String> list3, @RequestParam(value="enabled", required=false) Boolean bl, @RequestParam(value="groups", required=false) List<String> list4, @RequestParam(value="keywords", required=false) String string, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="range", required=false) DocumentRangeEnum documentRangeEnum, @RequestParam(value="skipTotalCount", required=false) Boolean bl2, @RequestParam(value="user", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /documents");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchDocumentsParams searchDocumentsParams = new SearchDocumentsParams();
        searchDocumentsParams.fields = list;
        searchDocumentsParams.brokers = list2;
        searchDocumentsParams.categories = list3;
        searchDocumentsParams.enabled = bl;
        searchDocumentsParams.groups = list4;
        searchDocumentsParams.keywords = string;
        searchDocumentsParams.page = n;
        searchDocumentsParams.pageSize = n2;
        searchDocumentsParams.range = documentRangeEnum;
        searchDocumentsParams.skipTotalCount = bl2;
        searchDocumentsParams.user = string2;
        return this.impl.searchDocuments(searchDocumentsParams);
    }

    @RequestMapping(value={"/api/documents/{id}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> updateDocument(@PathVariable(value="id") String string, @RequestBody(required=true) DocumentEdit documentEdit, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /documents/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.updateDocument(string, documentEdit);
    }

    @RequestMapping(value={"/api/documents/{id}/upload"}, produces={"application/json"}, consumes={"multipart/form-data"}, method={RequestMethod.POST})
    public ResponseEntity<Void> updateDocumentWithUpload(@PathVariable(value="id") String string, @RequestPart(value="file", required=true) MultipartFile multipartFile, @RequestPart(value="document", required=false) DocumentEdit documentEdit, @RequestPart(value="fileName", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /documents/{id}/upload");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        UpdateDocumentWithUploadParams updateDocumentWithUploadParams = new UpdateDocumentWithUploadParams();
        updateDocumentWithUploadParams.id = string;
        updateDocumentWithUploadParams.file = multipartFile;
        updateDocumentWithUploadParams.document = documentEdit;
        updateDocumentWithUploadParams.fileName = string2;
        return this.impl.updateDocumentWithUpload(updateDocumentWithUploadParams);
    }

    @RequestMapping(value={"/api/documents/{id}/file"}, produces={"application/json"}, consumes={"multipart/form-data"}, method={RequestMethod.POST})
    public ResponseEntity<Void> uploadDocumentFile(@PathVariable(value="id") String string, @RequestPart(value="file", required=true) MultipartFile multipartFile, @RequestParam(value="name", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /documents/{id}/file");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.uploadDocumentFile(string, multipartFile, string2);
    }

    @RequestMapping(value={"/api/documents/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DocumentView> viewDocument(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /documents/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.viewDocument(string, list);
    }

    public static class CreateUserDocumentWithUploadParams {
        public String user;
        public static final String USER = "user";
        public MultipartFile file;
        public static final String FILE = "file";
        public DocumentNew document;
        public static final String DOCUMENT = "document";
        public String fileName;
        public static final String FILE_NAME = "fileName";
    }

    public static class SearchDocumentsParams {
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public List<String> categories;
        public static final String CATEGORIES = "categories";
        public Boolean enabled;
        public static final String ENABLED = "enabled";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public String keywords;
        public static final String KEYWORDS = "keywords";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public DocumentRangeEnum range;
        public static final String RANGE = "range";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public String user;
        public static final String USER = "user";
    }

    public static class UpdateDocumentWithUploadParams {
        public String id;
        public static final String ID = "id";
        public MultipartFile file;
        public static final String FILE = "file";
        public DocumentEdit document;
        public static final String DOCUMENT = "document";
        public String fileName;
        public static final String FILE_NAME = "fileName";
    }
}

