/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.banking.transactions.BaseInternalPaymentPreviewVO;
import org.cyclos.model.banking.transactions.EasyInvoiceBarcodeParams;
import org.cyclos.model.banking.transactions.PaymentPreviewVO;
import org.cyclos.model.banking.transactions.PaymentVO;
import org.cyclos.model.banking.transactions.PerformPaymentDTO;
import org.cyclos.model.banking.transactions.PrepareEasyInvoiceData;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.banking.EasyInvoiceService;
import org.cyclos.utils.ContentType;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.EasyInvoicesApi;
import org.cyclos.web.rest.helpers.EasyInvoicesApiHelper;
import org.cyclos.web.rest.helpers.PaymentsApiHelper;
import org.cyclos.web.rest.helpers.TransactionsApiHelper;
import org.cyclos.web.rest.model.DataForEasyInvoice;
import org.cyclos.web.rest.model.PaymentPreview;
import org.cyclos.web.rest.model.PerformPayment;
import org.cyclos.web.rest.model.Transaction;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class EasyInvoicesApiImpl
extends BaseApiImpl {
    @Autowired
    private EasyInvoiceService easyInvoiceService;
    @Autowired
    private EasyInvoicesApiHelper easyInvoicesApiHelper;
    @Autowired
    private PaymentsApiHelper paymentsApiHelper;
    @Autowired
    private TransactionsApiHelper transactionsApiHelper;

    public ResponseEntity<DataForEasyInvoice> dataForPerformEasyInvoice(EasyInvoicesApi.DataForPerformEasyInvoiceParams dataForPerformEasyInvoiceParams) {
        PrepareEasyInvoiceData prepareEasyInvoiceData;
        Object object;
        if (this.apiHelper.isGuest()) {
            object = this.easyInvoicesApiHelper.toPrepareEasyInvoiceParams(dataForPerformEasyInvoiceParams);
            prepareEasyInvoiceData = this.easyInvoiceService.prepareEasyInvoice(object);
        } else {
            object = this.easyInvoicesApiHelper.toPerformPaymentDTO(dataForPerformEasyInvoiceParams);
            prepareEasyInvoiceData = this.easyInvoiceService.getEasyInvoiceData((PerformPaymentDTO)object);
        }
        object = this.easyInvoicesApiHelper.toDataForEasyInvoice(prepareEasyInvoiceData);
        return this.ok(object);
    }

    public ResponseEntity<InputStream> getEasyInvoiceQrCode(EasyInvoicesApi.GetEasyInvoiceQrCodeParams getEasyInvoiceQrCodeParams) throws IOException {
        EasyInvoiceBarcodeParams easyInvoiceBarcodeParams = this.easyInvoicesApiHelper.toEasyInvoiceBarcodeParamsDTO(getEasyInvoiceQrCodeParams);
        SerializableInputStream serializableInputStream = this.easyInvoiceService.barcode(easyInvoiceBarcodeParams);
        HttpServletResponse httpServletResponse = ServletHelper.getResponse();
        ServletHelper.setContentType(httpServletResponse, ContentType.PNG);
        ServletHelper.writeContents(httpServletResponse, (InputStream)serializableInputStream);
        httpServletResponse.flushBuffer();
        return null;
    }

    public ResponseEntity<Transaction> performEasyInvoice(PerformPayment performPayment, List<String> list, String string) {
        PerformPaymentDTO performPaymentDTO = (PerformPaymentDTO)this.paymentsApiHelper.toPerformDTO("self", string, performPayment);
        PaymentVO paymentVO = this.easyInvoiceService.perform(performPaymentDTO);
        return this.transactionsApiHelper.toResponseTransaction((TransactionVO)paymentVO);
    }

    public ResponseEntity<PaymentPreview> previewEasyInvoice(PerformPayment performPayment, List<String> list) {
        PerformPaymentDTO performPaymentDTO = (PerformPaymentDTO)this.paymentsApiHelper.toPerformDTO("self", null, performPayment);
        PaymentPreviewVO paymentPreviewVO = this.easyInvoiceService.preview(performPaymentDTO);
        PaymentPreview paymentPreview = this.paymentsApiHelper.toPaymentPreview((BaseInternalPaymentPreviewVO)paymentPreviewVO, performPayment.getSubject());
        return this.ok(paymentPreview);
    }
}

