/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.utils.RawFileVO;
import org.cyclos.model.utils.StoredFileVO;
import org.cyclos.server.utils.IOHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.system.RawFileService;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.FilesApi;
import org.cyclos.web.rest.helpers.FilesApiHelper;
import org.cyclos.web.rest.model.StoredFile;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FilesApiImpl
extends BaseApiImpl {
    @Autowired
    private FilesApiHelper filesApiHelper;
    @Autowired
    private RawFileService rawFileService;

    public ResponseEntity<Void> deleteRawFile(String string) {
        this.rawFileService.remove(this.apiHelper.fromId(string));
        return null;
    }

    public ResponseEntity<InputStream> getRawFileContent(String string) throws IOException {
        HttpServletResponse httpServletResponse = ServletHelper.getResponse();
        Long l = this.apiHelper.fromId(string);
        RawFileVO rawFileVO = this.rawFileService.load(l);
        SerializableInputStream serializableInputStream = this.rawFileService.readContent(l);
        ServletHelper.setFileName(httpServletResponse, rawFileVO.getName(), false);
        httpServletResponse.setContentType(rawFileVO.getContentType());
        httpServletResponse.setContentLength(rawFileVO.getLength());
        IOHelper.copyAndClose((InputStream)serializableInputStream, (OutputStream)httpServletResponse.getOutputStream());
        return null;
    }

    public ResponseEntity<List<StoredFile>> listTempFiles(FilesApi.ListTempFilesParams listTempFilesParams) {
        CustomFieldVO customFieldVO = this.apiHelper.toCustomFieldVO(listTempFilesParams.customField, listTempFilesParams.customFieldKind);
        List list = this.rawFileService.listTemp(listTempFilesParams.guestKey, customFieldVO);
        List list2 = list.stream().map(this.filesApiHelper::toStoredFile).collect(Collectors.toList());
        return this.ok(list2);
    }

    public ResponseEntity<String> uploadTempFile(FilesApi.UploadTempFileParams uploadTempFileParams) throws IOException {
        MultipartFile multipartFile = uploadTempFileParams.file;
        String string = uploadTempFileParams.name;
        CustomFieldVO customFieldVO = this.apiHelper.toCustomFieldVO(uploadTempFileParams.customField, uploadTempFileParams.customFieldKind);
        try (SerializableInputStream serializableInputStream = new SerializableInputStream(multipartFile.getInputStream());){
            string = (String)ObjectHelper.defaultValue((Object)StringHelper.trimToNull((Object)string), (Object)multipartFile.getOriginalFilename());
            RawFileVO rawFileVO = this.rawFileService.saveTemp(uploadTempFileParams.guestKey, customFieldVO, string, multipartFile.getContentType(), serializableInputStream);
            ResponseEntity<String> responseEntity = this.created(this.filesApiHelper.fileURI(rawFileVO), rawFileVO.getId());
            return responseEntity;
        }
    }

    public ResponseEntity<StoredFile> viewRawFile(String string, List<String> list) {
        RawFileVO rawFileVO = this.rawFileService.load(this.apiHelper.fromId(string));
        StoredFile storedFile = this.filesApiHelper.toStoredFile((StoredFileVO)rawFileVO);
        return this.ok(storedFile);
    }
}

