/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.utils.ContentType;
import org.cyclos.web.controllers.InlineCacheableContentResolver;
import org.cyclos.web.utils.IconHandler;
import org.springframework.util.DigestUtils;

public class IconsContentResolver
extends InlineCacheableContentResolver {
    private CyclosProperties cyclosProperties;
    private JsonConverter jsonConverter;
    private IconHandler iconHandler;
    private SortedSet<String> names;

    public IconsContentResolver(CyclosProperties cyclosProperties, JsonConverter jsonConverter, IconHandler iconHandler, Collection<String> collection) {
        this.cyclosProperties = cyclosProperties;
        this.jsonConverter = jsonConverter;
        this.iconHandler = iconHandler;
        this.names = new TreeSet<String>();
        if (collection != null) {
            this.names.addAll(collection);
        }
        this.setLongCache(true);
    }

    @Override
    protected ContentType resolveContentType() throws IOException {
        return ContentType.JSON;
    }

    @Override
    protected File resolveFile() throws IOException {
        return new File(this.iconsDir(), DigestUtils.md5DigestAsHex((byte[])this.names.toString().getBytes()) + ".json");
    }

    @Override
    protected Long resolveLastModification() throws IOException {
        return null;
    }

    @Override
    protected void writeContent(File file) throws IOException {
        this.jsonConverter.writeValue(file, this.iconHandler.icons(this.names));
    }

    private File iconsDir() {
        File file = new File(this.cyclosProperties.getTempDir(), "icons");
        file.mkdirs();
        return file;
    }
}

