/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.IdentityProvidersApiImpl;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.IdentityProviderRequestResult;
import org.cyclos.web.rest.model.UserIdentityProvidersListData;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(produces={"application/json"})
public class IdentityProvidersApi {
    @Autowired
    private IdentityProvidersApiImpl impl;
    public static final String DELETE_USER_IDENTITY_PROVIDER = "/{user}/identity-providers/{identityProvider}";
    public static final String GET_USER_IDENTITY_PROVIDERS_LIST_DATA = "/{user}/identity-providers/list-data";
    public static final String IDENTITY_PROVIDER_CALLBACK = "/identity-providers/callback";
    public static final String IDENTITY_PROVIDER_REDIRECT = "/identity-providers/redirect/{requestId}";
    public static final String PREPARE_IDENTITY_PROVIDER_LINK = "/identity-providers/{identityProvider}/link";
    public static final String PREPARE_IDENTITY_PROVIDER_LOGIN = "/identity-providers/{identityProvider}/login";
    public static final String PREPARE_IDENTITY_PROVIDER_REGISTRATION = "/identity-providers/{identityProvider}/register";
    public static final String PREPARE_IDENTITY_PROVIDER_WIZARD = "/identity-providers/{identityProvider}/wizard";

    @RequestMapping(value={"/api/{user:.*}/identity-providers/{identityProvider}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteUserIdentityProvider(@PathVariable(value="user") String string, @PathVariable(value="identityProvider") String string2, @RequestParam(value="disable", required=false) Boolean bl, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /{user}/identity-providers/{identityProvider}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.deleteUserIdentityProvider(string, string2, bl);
    }

    @RequestMapping(value={"/api/{user:.*}/identity-providers/list-data"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UserIdentityProvidersListData> getUserIdentityProvidersListData(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/identity-providers/list-data");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserIdentityProvidersListData(string, list);
    }

    @RequestMapping(value={"/api/identity-providers/callback"}, produces={"text/html", "application/json"}, method={RequestMethod.GET})
    public ModelAndView identityProviderCallback(HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /identity-providers/callback");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.identityProviderCallback();
    }

    @RequestMapping(value={"/api/identity-providers/redirect/{requestId}"}, produces={"text/html", "application/json"}, method={RequestMethod.GET})
    public ModelAndView identityProviderRedirect(@PathVariable(value="requestId") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /identity-providers/redirect/{requestId}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.identityProviderRedirect(string);
    }

    @RequestMapping(value={"/api/identity-providers/{identityProvider}/link"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<IdentityProviderRequestResult> prepareIdentityProviderLink(@PathVariable(value="identityProvider") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /identity-providers/{identityProvider}/link");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.prepareIdentityProviderLink(string);
    }

    @RequestMapping(value={"/api/identity-providers/{identityProvider}/login"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<IdentityProviderRequestResult> prepareIdentityProviderLogin(@PathVariable(value="identityProvider") String string, @RequestParam(value="userAgentId", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /identity-providers/{identityProvider}/login");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.prepareIdentityProviderLogin(string, string2);
    }

    @RequestMapping(value={"/api/identity-providers/{identityProvider}/register"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<IdentityProviderRequestResult> prepareIdentityProviderRegistration(@PathVariable(value="identityProvider") String string, @RequestParam(value="group", required=true) String string2, @RequestParam(value="userAgentId", required=false) String string3, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /identity-providers/{identityProvider}/register");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.prepareIdentityProviderRegistration(string, string2, string3);
    }

    @RequestMapping(value={"/api/identity-providers/{identityProvider}/wizard"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<IdentityProviderRequestResult> prepareIdentityProviderWizard(@PathVariable(value="identityProvider") String string, @RequestParam(value="key", required=true) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /identity-providers/{identityProvider}/wizard");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.prepareIdentityProviderWizard(string, string2);
    }
}

