/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.EntityVO;
import org.cyclos.model.IEntity;
import org.cyclos.model.contentmanagement.imagecategories.SystemImageCategoryVO;
import org.cyclos.model.contentmanagement.themes.ThemeImageVO;
import org.cyclos.model.marketplace.advertisements.BasicAdVO;
import org.cyclos.model.system.configurations.ConfigurationImageVO;
import org.cyclos.model.system.images.FullSystemImagesListData;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.system.images.ImagesListData;
import org.cyclos.model.system.images.NewTempImageParams;
import org.cyclos.model.users.contactinfos.ContactInfoVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.contentmanagement.SystemCustomImageService;
import org.cyclos.services.contentmanagement.UserCustomImageService;
import org.cyclos.services.marketplace.AdImageService;
import org.cyclos.services.system.InternalImageService;
import org.cyclos.services.system.TempImageService;
import org.cyclos.services.users.ContactInfoImageService;
import org.cyclos.services.users.UserImageService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.controllers.contentmanagement.ThemeImageContentResolver;
import org.cyclos.web.controllers.system.ConfigurationImageContentResolver;
import org.cyclos.web.controllers.system.ImageContentResolver;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.IconsContentResolver;
import org.cyclos.web.rest.api.ImagesApi;
import org.cyclos.web.rest.helpers.ImagesApiHelper;
import org.cyclos.web.rest.model.Image;
import org.cyclos.web.rest.model.ImageView;
import org.cyclos.web.rest.model.LogoKind;
import org.cyclos.web.rest.model.SystemImagesListData;
import org.cyclos.web.rest.model.UserImageKind;
import org.cyclos.web.utils.IconHandler;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class ImagesApiImpl
extends BaseApiImpl {
    @Autowired
    private ImagesApiHelper imagesApiHelper;
    @Autowired
    private UserImageService userImageService;
    @Autowired
    private AdImageService adImageService;
    @Autowired
    private ContactInfoImageService contactInfoImageService;
    @Autowired
    private InternalImageService internalImageService;
    @Autowired
    private UserCustomImageService userCustomImageService;
    @Autowired
    private SystemCustomImageService systemCustomImageService;
    @Autowired
    private JsonConverter jsonConverter;
    @Autowired
    private IconHandler iconHandler;
    @Autowired
    private TempImageService tempImageService;

    public ResponseEntity<Void> deleteImage(String string) {
        Long l = this.apiHelper.fromId(string);
        if (l == null) {
            this.internalImageService.removeByKey(string);
        } else {
            this.internalImageService.remove(l);
        }
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<org.cyclos.web.rest.model.ImagesListData> getAdImagesListData(String string, List<String> list) {
        ImagesListData imagesListData = this.adImageService.getListData((IEntity)((BasicAdVO)ModelHelper.voFromString(BasicAdVO.class, (String)string)));
        org.cyclos.web.rest.model.ImagesListData imagesListData2 = this.imagesApiHelper.toImagesListData(imagesListData);
        return this.ok(imagesListData2);
    }

    public ResponseEntity<InputStream> getConfigurationLogoContent(ImagesApi.GetConfigurationLogoContentParams getConfigurationLogoContentParams) throws IOException {
        HttpServletRequest httpServletRequest = ServletHelper.getRequest();
        HttpServletResponse httpServletResponse = ServletHelper.getResponse();
        ServletHelper.forceGuest(httpServletRequest);
        ConfigurationImageVO configurationImageVO = this.imagesApiHelper.getConfigurationImage(getConfigurationLogoContentParams._configuration, getConfigurationLogoContentParams.kind);
        ConfigurationImageContentResolver configurationImageContentResolver = new ConfigurationImageContentResolver(this.cyclosProperties, this.internalImageService, configurationImageVO, getConfigurationLogoContentParams.width, getConfigurationLogoContentParams.height);
        configurationImageContentResolver.write(httpServletRequest, httpServletResponse);
        return null;
    }

    public ResponseEntity<InputStream> getCurrentLogoContent(LogoKind logoKind, Integer n, Integer n2) throws IOException {
        HttpServletRequest httpServletRequest = ServletHelper.getRequest();
        HttpServletResponse httpServletResponse = ServletHelper.getResponse();
        ServletHelper.forceGuest(httpServletRequest);
        ConfigurationImageVO configurationImageVO = this.imagesApiHelper.getConfigurationImage(null, logoKind);
        ConfigurationImageContentResolver configurationImageContentResolver = new ConfigurationImageContentResolver(this.cyclosProperties, this.internalImageService, configurationImageVO, n, n2);
        configurationImageContentResolver.write(httpServletRequest, httpServletResponse);
        return null;
    }

    public ResponseEntity<InputStream> getCurrentThemeImageContent(ImagesApi.GetCurrentThemeImageContentParams getCurrentThemeImageContentParams) throws IOException {
        HttpServletRequest httpServletRequest = ServletHelper.getRequest();
        HttpServletResponse httpServletResponse = ServletHelper.getResponse();
        ServletHelper.forceGuest(httpServletRequest);
        ThemeImageVO themeImageVO = this.imagesApiHelper.getThemeImage(null, getCurrentThemeImageContentParams.kind, getCurrentThemeImageContentParams.name);
        ThemeImageContentResolver themeImageContentResolver = new ThemeImageContentResolver(this.cyclosProperties, this.internalImageService, themeImageVO, getCurrentThemeImageContentParams.width, getCurrentThemeImageContentParams.height);
        themeImageContentResolver.write(httpServletRequest, httpServletResponse);
        return null;
    }

    public ResponseEntity<InputStream> getImageContent(String string, Integer n, Integer n2) throws Exception {
        HttpServletRequest httpServletRequest = ServletHelper.getRequest();
        HttpServletResponse httpServletResponse = ServletHelper.getResponse();
        ImageContentResolver imageContentResolver = new ImageContentResolver(this.cyclosProperties, this.internalImageService, string, n, n2);
        imageContentResolver.write(httpServletRequest, httpServletResponse);
        return null;
    }

    public ResponseEntity<Map<String, String>> getSvgIcons(List<String> list) throws IOException {
        HttpServletRequest httpServletRequest = ServletHelper.getRequest();
        HttpServletResponse httpServletResponse = ServletHelper.getResponse();
        new IconsContentResolver(this.cyclosProperties, this.jsonConverter, this.iconHandler, list).write(httpServletRequest, httpServletResponse);
        return null;
    }

    public ResponseEntity<SystemImagesListData> getSystemCustomImagesListData(List<String> list) {
        FullSystemImagesListData fullSystemImagesListData = this.systemCustomImageService.getFullListData();
        SystemImagesListData systemImagesListData = this.imagesApiHelper.toSystemImagesListData(fullSystemImagesListData);
        return this.ok(systemImagesListData);
    }

    public ResponseEntity<InputStream> getThemeImageContent(ImagesApi.GetThemeImageContentParams getThemeImageContentParams) throws IOException {
        HttpServletRequest httpServletRequest = ServletHelper.getRequest();
        HttpServletResponse httpServletResponse = ServletHelper.getResponse();
        ServletHelper.forceGuest(httpServletRequest);
        ThemeImageVO themeImageVO = this.imagesApiHelper.getThemeImage(getThemeImageContentParams.theme, getThemeImageContentParams.kind, getThemeImageContentParams.name);
        ThemeImageContentResolver themeImageContentResolver = new ThemeImageContentResolver(this.cyclosProperties, this.internalImageService, themeImageVO, getThemeImageContentParams.width, getThemeImageContentParams.height);
        themeImageContentResolver.write(httpServletRequest, httpServletResponse);
        return null;
    }

    public ResponseEntity<org.cyclos.web.rest.model.ImagesListData> getUserImagesListData(String string, List<String> list, UserImageKind userImageKind) {
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
        ImagesListData imagesListData = this.getUserImagesData(userImageKind, userLocatorVO);
        org.cyclos.web.rest.model.ImagesListData imagesListData2 = this.imagesApiHelper.toImagesListData(imagesListData);
        return this.ok(imagesListData2);
    }

    public ResponseEntity<List<Image>> listAdImages(String string, List<String> list) {
        ImagesListData imagesListData = this.adImageService.getListData((IEntity)((BasicAdVO)ModelHelper.voFromString(BasicAdVO.class, (String)string)));
        org.cyclos.web.rest.model.ImagesListData imagesListData2 = this.imagesApiHelper.toImagesListData(imagesListData);
        return this.ok(imagesListData2.getImages());
    }

    public ResponseEntity<List<Image>> listTempImages(ImagesApi.ListTempImagesParams listTempImagesParams) {
        NewTempImageParams newTempImageParams = new NewTempImageParams();
        newTempImageParams.setGuestKey(listTempImagesParams.guestKey);
        newTempImageParams.setTarget(this.imagesApiHelper.toTempImageTarget(listTempImagesParams.target));
        newTempImageParams.setUser((BasicUserVO)ModelHelper.voFromString(BasicUserVO.class, (String)listTempImagesParams.user));
        newTempImageParams.setCustomField(this.apiHelper.toCustomFieldVO(listTempImagesParams.customField, listTempImagesParams.customFieldKind));
        List list = this.tempImageService.list(newTempImageParams);
        List list2 = list.stream().map(this.imagesApiHelper::toImage).collect(Collectors.toList());
        return this.ok(list2);
    }

    public ResponseEntity<List<Image>> listUserImages(String string, List<String> list, UserImageKind userImageKind) {
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
        ImagesListData imagesListData = this.getUserImagesData(userImageKind, userLocatorVO);
        org.cyclos.web.rest.model.ImagesListData imagesListData2 = this.imagesApiHelper.toImagesListData(imagesListData);
        return this.ok(imagesListData2.getImages());
    }

    public ResponseEntity<Void> reorderAdImages(String string2, List<String> list) {
        BasicAdVO basicAdVO = (BasicAdVO)ModelHelper.voFromString(BasicAdVO.class, (String)string2);
        List list2 = CollectionHelper.map(list, string -> (ImageVO)ModelHelper.voFromString(ImageVO.class, (String)string));
        this.adImageService.saveOrder((IEntity)basicAdVO, list2);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> reorderProfileImages(String string2, List<String> list) {
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string2);
        List list2 = CollectionHelper.map(list, string -> (ImageVO)ModelHelper.voFromString(ImageVO.class, (String)string));
        this.userImageService.saveOrder((IEntity)userLocatorVO, list2);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<String> uploadAdImage(String string, String string2, MultipartFile multipartFile) throws IOException {
        BasicAdVO basicAdVO = (BasicAdVO)ModelHelper.voFromString(BasicAdVO.class, (String)string);
        try (SerializableInputStream serializableInputStream = new SerializableInputStream(multipartFile.getInputStream());){
            string2 = (String)ObjectHelper.defaultValue((Object)StringHelper.trimToNull((Object)string2), (Object)multipartFile.getOriginalFilename());
            ImageVO imageVO = this.adImageService.save((Object)basicAdVO, string2, serializableInputStream, multipartFile.getContentType());
            ResponseEntity<String> responseEntity = this.created(this.imagesApiHelper.imageURI(imageVO), ModelHelper.stringOrIdFromVO((EntityVO)imageVO));
            return responseEntity;
        }
    }

    public ResponseEntity<String> uploadContactInfoImage(String string, String string2, MultipartFile multipartFile) throws IOException {
        try (SerializableInputStream serializableInputStream = new SerializableInputStream(multipartFile.getInputStream());){
            string2 = (String)ObjectHelper.defaultValue((Object)StringHelper.trimToNull((Object)string2), (Object)multipartFile.getOriginalFilename());
            ContactInfoVO contactInfoVO = (ContactInfoVO)ModelHelper.voFromString(ContactInfoVO.class, (String)string);
            ImageVO imageVO = this.contactInfoImageService.save((Object)contactInfoVO, string2, serializableInputStream, multipartFile.getContentType());
            ResponseEntity<String> responseEntity = this.created(this.imagesApiHelper.imageURI(imageVO), ModelHelper.stringOrIdFromVO((EntityVO)imageVO));
            return responseEntity;
        }
    }

    public ResponseEntity<String> uploadSystemCustomImage(String string, String string2, MultipartFile multipartFile) throws IOException {
        string2 = (String)ObjectHelper.defaultValue((Object)StringHelper.trimToNull((Object)string2), (Object)multipartFile.getOriginalFilename());
        try (SerializableInputStream serializableInputStream = new SerializableInputStream(multipartFile.getInputStream());){
            ImageVO imageVO = this.systemCustomImageService.save((Object)((SystemImageCategoryVO)ModelHelper.voFromString(SystemImageCategoryVO.class, (String)string)), string2, serializableInputStream, multipartFile.getContentType());
            ResponseEntity<String> responseEntity = this.created(this.imagesApiHelper.imageURI(imageVO), ModelHelper.stringOrIdFromVO((EntityVO)imageVO));
            return responseEntity;
        }
    }

    public ResponseEntity<String> uploadTempImage(ImagesApi.UploadTempImageParams uploadTempImageParams) throws IOException {
        MultipartFile multipartFile = uploadTempImageParams.image;
        String string = uploadTempImageParams.name;
        string = (String)ObjectHelper.defaultValue((Object)StringHelper.trimToNull((Object)string), (Object)multipartFile.getOriginalFilename());
        try (SerializableInputStream serializableInputStream = new SerializableInputStream(multipartFile.getInputStream());){
            NewTempImageParams newTempImageParams = new NewTempImageParams();
            newTempImageParams.setGuestKey(uploadTempImageParams.guestKey);
            newTempImageParams.setTarget(this.imagesApiHelper.toTempImageTarget(uploadTempImageParams.target));
            newTempImageParams.setUser((BasicUserVO)ModelHelper.voFromString(BasicUserVO.class, (String)uploadTempImageParams.user));
            newTempImageParams.setCustomField(this.apiHelper.toCustomFieldVO(uploadTempImageParams.customField, uploadTempImageParams.customFieldKind));
            ImageVO imageVO = this.tempImageService.save((Object)newTempImageParams, string, serializableInputStream, multipartFile.getContentType());
            ResponseEntity<String> responseEntity = this.created(this.imagesApiHelper.imageURI(imageVO), ModelHelper.stringOrIdFromVO((EntityVO)imageVO));
            return responseEntity;
        }
    }

    public ResponseEntity<String> uploadUserImage(ImagesApi.UploadUserImageParams uploadUserImageParams) throws IOException {
        MultipartFile multipartFile = uploadUserImageParams.image;
        try (SerializableInputStream serializableInputStream = new SerializableInputStream(multipartFile.getInputStream());){
            UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)uploadUserImageParams.user);
            String string = (String)ObjectHelper.defaultValue((Object)StringHelper.trimToNull((Object)uploadUserImageParams.name), (Object)multipartFile.getOriginalFilename());
            ImageVO imageVO = uploadUserImageParams.kind == UserImageKind.CUSTOM ? this.userCustomImageService.save((Object)userLocatorVO, string, serializableInputStream, multipartFile.getContentType()) : this.userImageService.save((Object)userLocatorVO, string, serializableInputStream, multipartFile.getContentType());
            ResponseEntity<String> responseEntity = this.created(this.imagesApiHelper.imageURI(imageVO), ModelHelper.stringOrIdFromVO((EntityVO)imageVO));
            return responseEntity;
        }
    }

    public ResponseEntity<ImageView> viewImage(String string, List<String> list) {
        ImageVO imageVO = this.internalImageService.loadByKey(string);
        ImageView imageView = this.imagesApiHelper.toImageView(imageVO);
        return this.ok(imageView);
    }

    public ResponseEntity<String> viewSvgIcon(String string, List<String> list) {
        String string2 = this.iconHandler.icon(string);
        return this.ok(string2);
    }

    private ImagesListData getUserImagesData(UserImageKind userImageKind, UserLocatorVO userLocatorVO) {
        if (userImageKind == UserImageKind.CUSTOM) {
            return this.userCustomImageService.getListData((IEntity)userLocatorVO);
        }
        return this.userImageService.getListData((IEntity)userLocatorVO);
    }
}

