/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.utils.DateTime;
import org.cyclos.web.rest.api.ImportsApiImpl;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.GeneralImportedFileContextEnum;
import org.cyclos.web.rest.model.GeneralImportedFileKind;
import org.cyclos.web.rest.model.ImportedFileDataForEdit;
import org.cyclos.web.rest.model.ImportedFileDataForNew;
import org.cyclos.web.rest.model.ImportedFileDataForSearch;
import org.cyclos.web.rest.model.ImportedFileEdit;
import org.cyclos.web.rest.model.ImportedFileKind;
import org.cyclos.web.rest.model.ImportedFileNew;
import org.cyclos.web.rest.model.ImportedFileResult;
import org.cyclos.web.rest.model.ImportedFileStatusEnum;
import org.cyclos.web.rest.model.ImportedFileView;
import org.cyclos.web.rest.model.ImportedLineDataForEdit;
import org.cyclos.web.rest.model.ImportedLineDataForSearch;
import org.cyclos.web.rest.model.ImportedLineEdit;
import org.cyclos.web.rest.model.ImportedLineResult;
import org.cyclos.web.rest.model.ImportedLineStatusEnum;
import org.cyclos.web.rest.model.ImportedLineView;
import org.cyclos.web.rest.model.UserImportedFileContextEnum;
import org.cyclos.web.rest.model.UserImportedFileKind;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(produces={"application/json"})
public class ImportsApi {
    @Autowired
    private ImportsApiImpl impl;
    public static final String ABORT_IMPORTED_FILE = "/imported-file/{id}/abort";
    public static final String DELETE_IMPORTED_FILE = "/imported-file/{id}";
    public static final String GET_GENERAL_IMPORTED_FILE_DATA_FOR_NEW = "/imported-files/{kind}/data-for-new";
    public static final String GET_GENERAL_IMPORTED_FILES_DATA_FOR_SEARCH = "/imported-files/{context}/data-for-search";
    public static final String GET_IMPORTED_FILE_DATA_FOR_EDIT = "/imported-file/{id}/data-for-edit";
    public static final String GET_IMPORTED_LINE_DATA_FOR_EDIT = "/imported-line/{id}/data-for-edit";
    public static final String GET_IMPORTED_LINES_DATA_FOR_SEARCH = "/imported-file/{id}/lines/data-for-search";
    public static final String GET_USER_IMPORTED_FILE_DATA_FOR_NEW = "/{user}/imported-files/{kind}/data-for-new";
    public static final String GET_USER_IMPORTED_FILES_DATA_FOR_SEARCH = "/{user}/imported-files/{context}/data-for-search";
    public static final String IMPORT_GENERAL_FILE = "/imported-files/{kind}";
    public static final String IMPORT_USER_FILE = "/{user}/imported-files/{kind}";
    public static final String INCLUDE_IMPORTED_LINES = "/imported-file/{id}/include";
    public static final String PROCESS_IMPORTED_FILE = "/imported-file/{id}/process";
    public static final String SEARCH_GENERAL_IMPORTED_FILES = "/imported-files/{context}";
    public static final String SEARCH_IMPORTED_LINES = "/imported-file/{id}/lines";
    public static final String SEARCH_USER_IMPORTED_FILES = "/{user}/imported-files/{context}";
    public static final String SKIP_IMPORTED_LINES = "/imported-file/{id}/skip";
    public static final String UPDATE_IMPORTED_FILE = "/imported-file/{id}";
    public static final String UPDATE_IMPORTED_LINE = "/imported-line/{id}";
    public static final String VIEW_IMPORTED_FILE = "/imported-file/{id}";
    public static final String VIEW_IMPORTED_LINE = "/imported-line/{id}";

    @RequestMapping(value={"/api/imported-file/{id}/abort"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> abortImportedFile(@PathVariable(value="id") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /imported-file/{id}/abort");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.abortImportedFile(string);
    }

    @RequestMapping(value={"/api/imported-file/{id}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteImportedFile(@PathVariable(value="id") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /imported-file/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.deleteImportedFile(string);
    }

    @RequestMapping(value={"/api/imported-files/{kind}/data-for-new"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ImportedFileDataForNew> getGeneralImportedFileDataForNew(@PathVariable(value="kind") GeneralImportedFileKind generalImportedFileKind, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /imported-files/{kind}/data-for-new");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getGeneralImportedFileDataForNew(generalImportedFileKind, list);
    }

    @RequestMapping(value={"/api/imported-files/{context}/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ImportedFileDataForSearch> getGeneralImportedFilesDataForSearch(@PathVariable(value="context") GeneralImportedFileContextEnum generalImportedFileContextEnum, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /imported-files/{context}/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getGeneralImportedFilesDataForSearch(generalImportedFileContextEnum, list);
    }

    @RequestMapping(value={"/api/imported-file/{id}/data-for-edit"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ImportedFileDataForEdit> getImportedFileDataForEdit(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /imported-file/{id}/data-for-edit");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getImportedFileDataForEdit(string, list);
    }

    @RequestMapping(value={"/api/imported-line/{id}/data-for-edit"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ImportedLineDataForEdit> getImportedLineDataForEdit(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /imported-line/{id}/data-for-edit");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getImportedLineDataForEdit(string, list);
    }

    @RequestMapping(value={"/api/imported-file/{id}/lines/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ImportedLineDataForSearch> getImportedLinesDataForSearch(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /imported-file/{id}/lines/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getImportedLinesDataForSearch(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/imported-files/{kind}/data-for-new"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ImportedFileDataForNew> getUserImportedFileDataForNew(@PathVariable(value="user") String string, @PathVariable(value="kind") UserImportedFileKind userImportedFileKind, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/imported-files/{kind}/data-for-new");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserImportedFileDataForNew(string, userImportedFileKind, list);
    }

    @RequestMapping(value={"/api/{user:.*}/imported-files/{context}/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ImportedFileDataForSearch> getUserImportedFilesDataForSearch(@PathVariable(value="user") String string, @PathVariable(value="context") UserImportedFileContextEnum userImportedFileContextEnum, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/imported-files/{context}/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserImportedFilesDataForSearch(string, userImportedFileContextEnum, list);
    }

    @RequestMapping(value={"/api/imported-files/{kind}"}, produces={"text/plain", "application/json"}, consumes={"multipart/form-data"}, method={RequestMethod.POST})
    public ResponseEntity<String> importGeneralFile(@PathVariable(value="kind") GeneralImportedFileKind generalImportedFileKind, @RequestHeader(value="confirmationPassword", required=false) String string, @RequestPart(value="params", required=false) ImportedFileNew importedFileNew, @RequestPart(value="file", required=false) MultipartFile multipartFile, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /imported-files/{kind}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        ImportGeneralFileParams importGeneralFileParams = new ImportGeneralFileParams();
        importGeneralFileParams.kind = generalImportedFileKind;
        importGeneralFileParams.confirmationPassword = string;
        importGeneralFileParams.params = importedFileNew;
        importGeneralFileParams.file = multipartFile;
        return this.impl.importGeneralFile(importGeneralFileParams);
    }

    @RequestMapping(value={"/api/{user:.*}/imported-files/{kind}"}, produces={"text/plain", "application/json"}, consumes={"multipart/form-data"}, method={RequestMethod.POST})
    public ResponseEntity<String> importUserFile(@PathVariable(value="user") String string, @PathVariable(value="kind") UserImportedFileKind userImportedFileKind, @RequestHeader(value="confirmationPassword", required=false) String string2, @RequestPart(value="params", required=false) ImportedFileNew importedFileNew, @RequestPart(value="file", required=false) MultipartFile multipartFile, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/imported-files/{kind}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        ImportUserFileParams importUserFileParams = new ImportUserFileParams();
        importUserFileParams.user = string;
        importUserFileParams.kind = userImportedFileKind;
        importUserFileParams.confirmationPassword = string2;
        importUserFileParams.params = importedFileNew;
        importUserFileParams.file = multipartFile;
        return this.impl.importUserFile(importUserFileParams);
    }

    @RequestMapping(value={"/api/imported-file/{id}/include"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> includeImportedLines(@PathVariable(value="id") String string, @RequestParam(value="lines", required=true) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /imported-file/{id}/include");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.includeImportedLines(string, list);
    }

    @RequestMapping(value={"/api/imported-file/{id}/process"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> processImportedFile(@PathVariable(value="id") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /imported-file/{id}/process");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.processImportedFile(string);
    }

    @RequestMapping(value={"/api/imported-files/{context}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<ImportedFileResult>> searchGeneralImportedFiles(@PathVariable(value="context") GeneralImportedFileContextEnum generalImportedFileContextEnum, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="creationPeriod", required=false) List<DateTime> list2, @RequestParam(value="kinds", required=false) List<ImportedFileKind> list3, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl, @RequestParam(value="statuses", required=false) List<ImportedFileStatusEnum> list4, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /imported-files/{context}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchGeneralImportedFilesParams searchGeneralImportedFilesParams = new SearchGeneralImportedFilesParams();
        searchGeneralImportedFilesParams.context = generalImportedFileContextEnum;
        searchGeneralImportedFilesParams.fields = list;
        searchGeneralImportedFilesParams.creationPeriod = list2;
        searchGeneralImportedFilesParams.kinds = list3;
        searchGeneralImportedFilesParams.page = n;
        searchGeneralImportedFilesParams.pageSize = n2;
        searchGeneralImportedFilesParams.skipTotalCount = bl;
        searchGeneralImportedFilesParams.statuses = list4;
        return this.impl.searchGeneralImportedFiles(searchGeneralImportedFilesParams);
    }

    @RequestMapping(value={"/api/imported-file/{id}/lines"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<ImportedLineResult>> searchImportedLines(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="keywords", required=false) String string2, @RequestParam(value="lineNumbers", required=false) List<Integer> list2, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl, @RequestParam(value="statuses", required=false) List<ImportedLineStatusEnum> list3, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /imported-file/{id}/lines");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchImportedLinesParams searchImportedLinesParams = new SearchImportedLinesParams();
        searchImportedLinesParams.id = string;
        searchImportedLinesParams.fields = list;
        searchImportedLinesParams.keywords = string2;
        searchImportedLinesParams.lineNumbers = list2;
        searchImportedLinesParams.page = n;
        searchImportedLinesParams.pageSize = n2;
        searchImportedLinesParams.skipTotalCount = bl;
        searchImportedLinesParams.statuses = list3;
        return this.impl.searchImportedLines(searchImportedLinesParams);
    }

    @RequestMapping(value={"/api/{user:.*}/imported-files/{context}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<ImportedFileResult>> searchUserImportedFiles(@PathVariable(value="user") String string, @PathVariable(value="context") UserImportedFileContextEnum userImportedFileContextEnum, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="creationPeriod", required=false) List<DateTime> list2, @RequestParam(value="kinds", required=false) List<ImportedFileKind> list3, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl, @RequestParam(value="statuses", required=false) List<ImportedFileStatusEnum> list4, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/imported-files/{context}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchUserImportedFilesParams searchUserImportedFilesParams = new SearchUserImportedFilesParams();
        searchUserImportedFilesParams.user = string;
        searchUserImportedFilesParams.context = userImportedFileContextEnum;
        searchUserImportedFilesParams.fields = list;
        searchUserImportedFilesParams.creationPeriod = list2;
        searchUserImportedFilesParams.kinds = list3;
        searchUserImportedFilesParams.page = n;
        searchUserImportedFilesParams.pageSize = n2;
        searchUserImportedFilesParams.skipTotalCount = bl;
        searchUserImportedFilesParams.statuses = list4;
        return this.impl.searchUserImportedFiles(searchUserImportedFilesParams);
    }

    @RequestMapping(value={"/api/imported-file/{id}/skip"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> skipImportedLines(@PathVariable(value="id") String string, @RequestParam(value="lines", required=true) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /imported-file/{id}/skip");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.skipImportedLines(string, list);
    }

    @RequestMapping(value={"/api/imported-file/{id}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> updateImportedFile(@PathVariable(value="id") String string, @RequestBody(required=true) ImportedFileEdit importedFileEdit, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /imported-file/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.updateImportedFile(string, importedFileEdit);
    }

    @RequestMapping(value={"/api/imported-line/{id}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> updateImportedLine(@PathVariable(value="id") String string, @RequestBody(required=true) ImportedLineEdit importedLineEdit, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /imported-line/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.updateImportedLine(string, importedLineEdit);
    }

    @RequestMapping(value={"/api/imported-file/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ImportedFileView> viewImportedFile(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /imported-file/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.viewImportedFile(string, list);
    }

    @RequestMapping(value={"/api/imported-line/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ImportedLineView> viewImportedLine(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /imported-line/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.viewImportedLine(string, list);
    }

    public static class ImportGeneralFileParams {
        public GeneralImportedFileKind kind;
        public static final String KIND = "kind";
        public String confirmationPassword;
        public static final String CONFIRMATION_PASSWORD = "confirmationPassword";
        public ImportedFileNew params;
        public static final String PARAMS = "params";
        public MultipartFile file;
        public static final String FILE = "file";
    }

    public static class ImportUserFileParams {
        public String user;
        public static final String USER = "user";
        public UserImportedFileKind kind;
        public static final String KIND = "kind";
        public String confirmationPassword;
        public static final String CONFIRMATION_PASSWORD = "confirmationPassword";
        public ImportedFileNew params;
        public static final String PARAMS = "params";
        public MultipartFile file;
        public static final String FILE = "file";
    }

    public static class SearchGeneralImportedFilesParams {
        public GeneralImportedFileContextEnum context;
        public static final String CONTEXT = "context";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<DateTime> creationPeriod;
        public static final String CREATION_PERIOD = "creationPeriod";
        public List<ImportedFileKind> kinds;
        public static final String KINDS = "kinds";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<ImportedFileStatusEnum> statuses;
        public static final String STATUSES = "statuses";
    }

    public static class SearchImportedLinesParams {
        public String id;
        public static final String ID = "id";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String keywords;
        public static final String KEYWORDS = "keywords";
        public List<Integer> lineNumbers;
        public static final String LINE_NUMBERS = "lineNumbers";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<ImportedLineStatusEnum> statuses;
        public static final String STATUSES = "statuses";
    }

    public static class SearchUserImportedFilesParams {
        public String user;
        public static final String USER = "user";
        public UserImportedFileContextEnum context;
        public static final String CONTEXT = "context";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<DateTime> creationPeriod;
        public static final String CREATION_PERIOD = "creationPeriod";
        public List<ImportedFileKind> kinds;
        public static final String KINDS = "kinds";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<ImportedFileStatusEnum> statuses;
        public static final String STATUSES = "statuses";
    }
}

