/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.IOException;
import java.util.List;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.system.imports.ImportSearchContext;
import org.cyclos.model.system.imports.ImportType;
import org.cyclos.model.system.imports.ImportedFileDTO;
import org.cyclos.model.system.imports.ImportedFileData;
import org.cyclos.model.system.imports.ImportedFileDataParams;
import org.cyclos.model.system.imports.ImportedFileQuery;
import org.cyclos.model.system.imports.ImportedFileSearchData;
import org.cyclos.model.system.imports.ImportedLineDTO;
import org.cyclos.model.system.imports.ImportedLineData;
import org.cyclos.model.system.imports.ImportedLineQuery;
import org.cyclos.model.system.imports.ImportedLineSearchData;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.system.ImportService;
import org.cyclos.utils.Page;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.ImportsApi;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.ImportsApiHelper;
import org.cyclos.web.rest.model.GeneralImportedFileContextEnum;
import org.cyclos.web.rest.model.GeneralImportedFileKind;
import org.cyclos.web.rest.model.ImportedFileDataForEdit;
import org.cyclos.web.rest.model.ImportedFileDataForNew;
import org.cyclos.web.rest.model.ImportedFileDataForSearch;
import org.cyclos.web.rest.model.ImportedFileEdit;
import org.cyclos.web.rest.model.ImportedFileNew;
import org.cyclos.web.rest.model.ImportedFileQueryFilters;
import org.cyclos.web.rest.model.ImportedFileResult;
import org.cyclos.web.rest.model.ImportedFileView;
import org.cyclos.web.rest.model.ImportedLineDataForEdit;
import org.cyclos.web.rest.model.ImportedLineDataForSearch;
import org.cyclos.web.rest.model.ImportedLineEdit;
import org.cyclos.web.rest.model.ImportedLineQueryFilters;
import org.cyclos.web.rest.model.ImportedLineResult;
import org.cyclos.web.rest.model.ImportedLineView;
import org.cyclos.web.rest.model.UserImportedFileContextEnum;
import org.cyclos.web.rest.model.UserImportedFileKind;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class ImportsApiImpl
extends BaseApiImpl {
    @Autowired
    private ImportService importService;
    @Autowired
    private ImportsApiHelper importsApiHelper;
    @Autowired
    private ApiHelper apiHelper;

    public ResponseEntity<Boolean> abortImportedFile(String string) {
        return this.ok(this.importService.abort(this.apiHelper.fromId(string)));
    }

    public ResponseEntity<Void> deleteImportedFile(String string) {
        this.importService.remove(this.apiHelper.fromId(string));
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<ImportedFileDataForNew> getGeneralImportedFileDataForNew(GeneralImportedFileKind generalImportedFileKind, List<String> list) {
        return this.doGetDataForNew(this.importsApiHelper.toImportType(generalImportedFileKind), null);
    }

    public ResponseEntity<ImportedFileDataForSearch> getGeneralImportedFilesDataForSearch(GeneralImportedFileContextEnum generalImportedFileContextEnum, List<String> list) {
        return this.doGetDataForSearch(this.importsApiHelper.toImportSearchContext(generalImportedFileContextEnum), null);
    }

    public ResponseEntity<ImportedFileDataForEdit> getImportedFileDataForEdit(String string, List<String> list) {
        ImportedFileData importedFileData = (ImportedFileData)this.importService.getData(this.apiHelper.fromId(string));
        ImportedFileDataForEdit importedFileDataForEdit = this.importsApiHelper.toImportedFileDataForEdit(importedFileData);
        return this.ok(importedFileDataForEdit);
    }

    public ResponseEntity<ImportedLineDataForEdit> getImportedLineDataForEdit(String string, List<String> list) {
        ImportedLineData importedLineData = this.importService.getImportedLineData(this.apiHelper.fromId(string));
        ImportedLineDataForEdit importedLineDataForEdit = this.importsApiHelper.toImportedLineDataForEdit(importedLineData);
        return this.ok(importedLineDataForEdit);
    }

    public ResponseEntity<ImportedLineDataForSearch> getImportedLinesDataForSearch(String string, List<String> list) {
        ImportedLineSearchData importedLineSearchData = this.importService.getLineSearchData(this.apiHelper.fromId(string));
        ImportedLineDataForSearch importedLineDataForSearch = this.importsApiHelper.toImportedLineDataForSearch(importedLineSearchData);
        return this.ok(importedLineDataForSearch);
    }

    public ResponseEntity<ImportedFileDataForNew> getUserImportedFileDataForNew(String string, UserImportedFileKind userImportedFileKind, List<String> list) {
        return this.doGetDataForNew(this.importsApiHelper.toImportType(userImportedFileKind), string);
    }

    public ResponseEntity<ImportedFileDataForSearch> getUserImportedFilesDataForSearch(String string, UserImportedFileContextEnum userImportedFileContextEnum, List<String> list) {
        return this.doGetDataForSearch(this.importsApiHelper.toImportSearchContext(userImportedFileContextEnum), string);
    }

    public ResponseEntity<String> importGeneralFile(ImportsApi.ImportGeneralFileParams importGeneralFileParams) throws IOException {
        return this.doImport(this.importsApiHelper.toImportType(importGeneralFileParams.kind), null, importGeneralFileParams.params, importGeneralFileParams.file, importGeneralFileParams.confirmationPassword);
    }

    public ResponseEntity<String> importUserFile(ImportsApi.ImportUserFileParams importUserFileParams) throws IOException {
        return this.doImport(this.importsApiHelper.toImportType(importUserFileParams.kind), importUserFileParams.user, importUserFileParams.params, importUserFileParams.file, importUserFileParams.confirmationPassword);
    }

    public ResponseEntity<Void> includeImportedLines(String string, List<String> list) {
        this.importService.markAsSkipped(this.apiHelper.fromId(string), this.apiHelper.fromIds(list), false);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> processImportedFile(String string) {
        this.importService.process(this.apiHelper.fromId(string));
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<List<ImportedFileResult>> searchGeneralImportedFiles(ImportsApi.SearchGeneralImportedFilesParams searchGeneralImportedFilesParams) {
        return this.doSearch(this.importsApiHelper.toImportSearchContext(searchGeneralImportedFilesParams.context), (ImportedFileQueryFilters)ClassHelper.convert((Object)searchGeneralImportedFilesParams, ImportedFileQueryFilters.class), null);
    }

    public ResponseEntity<List<ImportedLineResult>> searchImportedLines(ImportsApi.SearchImportedLinesParams searchImportedLinesParams) {
        ImportedLineQueryFilters importedLineQueryFilters = (ImportedLineQueryFilters)ClassHelper.convert((Object)searchImportedLinesParams, ImportedLineQueryFilters.class);
        ImportedLineQuery importedLineQuery = this.importsApiHelper.toImportedLineQuery(searchImportedLinesParams.id, importedLineQueryFilters);
        Page page = this.importService.searchImportedLines(importedLineQuery);
        return this.pageResponse(page, this.importsApiHelper::toImportedLineResult);
    }

    public ResponseEntity<List<ImportedFileResult>> searchUserImportedFiles(ImportsApi.SearchUserImportedFilesParams searchUserImportedFilesParams) {
        return this.doSearch(this.importsApiHelper.toImportSearchContext(searchUserImportedFilesParams.context), (ImportedFileQueryFilters)ClassHelper.convert((Object)searchUserImportedFilesParams, ImportedFileQueryFilters.class), searchUserImportedFilesParams.user);
    }

    public ResponseEntity<Void> skipImportedLines(String string, List<String> list) {
        this.importService.markAsSkipped(this.apiHelper.fromId(string), this.apiHelper.fromIds(list), true);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> updateImportedFile(String string, ImportedFileEdit importedFileEdit) {
        ImportedFileDTO importedFileDTO = this.importsApiHelper.toImportedFileDTO(string, importedFileEdit);
        this.importService.save((EntityDTO)importedFileDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> updateImportedLine(String string, ImportedLineEdit importedLineEdit) {
        ImportedLineDTO importedLineDTO = this.importsApiHelper.toImportedLineDTO(string, importedLineEdit);
        this.importService.saveImportedLine(importedLineDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<ImportedFileView> viewImportedFile(String string, List<String> list) {
        ImportedFileData importedFileData = (ImportedFileData)this.importService.getData(this.apiHelper.fromId(string));
        ImportedFileView importedFileView = this.importsApiHelper.toImportedFileView(importedFileData);
        return this.ok(importedFileView);
    }

    public ResponseEntity<ImportedLineView> viewImportedLine(String string, List<String> list) {
        ImportedLineData importedLineData = this.importService.getImportedLineData(this.apiHelper.fromId(string));
        ImportedLineView importedLineView = this.importsApiHelper.toImportedLineView(importedLineData);
        return this.ok(importedLineView);
    }

    private ResponseEntity<ImportedFileDataForNew> doGetDataForNew(ImportType importType, String string) {
        ImportedFileDataParams importedFileDataParams = this.importsApiHelper.toImportedFileDataParams(importType, string);
        ImportedFileData importedFileData = (ImportedFileData)this.importService.getDataForNew((Object)importedFileDataParams);
        ImportedFileDataForNew importedFileDataForNew = this.importsApiHelper.toImportedFileDataForNew(importedFileData);
        return this.ok(importedFileDataForNew);
    }

    private ResponseEntity<ImportedFileDataForSearch> doGetDataForSearch(ImportSearchContext importSearchContext, String string) {
        ImportedFileSearchData importedFileSearchData = this.importService.getSearchData(importSearchContext, ModelHelper.userLocator((String)string));
        ImportedFileDataForSearch importedFileDataForSearch = this.importsApiHelper.toImportedFileDataForSearch(importedFileSearchData);
        return this.ok(importedFileDataForSearch);
    }

    private ResponseEntity<String> doImport(ImportType importType, String string, ImportedFileNew importedFileNew, MultipartFile multipartFile, String string2) throws IOException {
        ImportedFileDTO importedFileDTO = this.importsApiHelper.toImportedFileDTO(importType, importedFileNew, string);
        importedFileDTO.setFileName(multipartFile.getOriginalFilename());
        Long l = this.importService.upload(importedFileDTO, new SerializableInputStream(multipartFile.getInputStream()), string2);
        return this.created(this.apiHelper.uriFromApi("imports", l), l);
    }

    private ResponseEntity<List<ImportedFileResult>> doSearch(ImportSearchContext importSearchContext, ImportedFileQueryFilters importedFileQueryFilters, String string) {
        ImportedFileQuery importedFileQuery = this.importsApiHelper.toImportedFileQuery(importSearchContext, importedFileQueryFilters, string);
        Page page = this.importService.search(importedFileQuery);
        return this.pageResponse(page, this.importsApiHelper::toImportedFileResult);
    }
}

