/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.util.List;
import org.cyclos.model.banking.transactions.InstallmentActionDTO;
import org.cyclos.model.banking.transactions.InstallmentOverviewQuery;
import org.cyclos.model.banking.transactions.InstallmentOverviewSearchData;
import org.cyclos.model.banking.transactions.InstallmentQuery;
import org.cyclos.model.banking.transactions.InstallmentSearchData;
import org.cyclos.model.banking.transfers.TransferVO;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.services.banking.TransactionService;
import org.cyclos.utils.Page;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.InstallmentsApi;
import org.cyclos.web.rest.helpers.InstallmentsApiHelper;
import org.cyclos.web.rest.helpers.TransfersApiHelper;
import org.cyclos.web.rest.model.InstallmentDataForSearch;
import org.cyclos.web.rest.model.InstallmentOverviewDataForSearch;
import org.cyclos.web.rest.model.InstallmentOverviewQueryFilters;
import org.cyclos.web.rest.model.InstallmentOverviewResult;
import org.cyclos.web.rest.model.InstallmentQueryFilters;
import org.cyclos.web.rest.model.InstallmentResult;
import org.cyclos.web.rest.model.Transfer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class InstallmentsApiImpl
extends BaseApiImpl {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private InstallmentsApiHelper installmentsApiHelper;
    @Autowired
    private TransfersApiHelper transfersApiHelper;

    public ResponseEntity<InputStream> exportInstallments(InstallmentsApi.ExportInstallmentsParams exportInstallmentsParams) {
        InstallmentQueryFilters installmentQueryFilters = (InstallmentQueryFilters)ClassHelper.convert((Object)exportInstallmentsParams, InstallmentQueryFilters.class);
        InstallmentQuery installmentQuery = this.installmentsApiHelper.toInstallmentQuery(exportInstallmentsParams.owner, installmentQueryFilters);
        ExportFormatVO exportFormatVO = (ExportFormatVO)ModelHelper.voFromString(ExportFormatVO.class, (String)exportInstallmentsParams.format);
        FileInfo fileInfo = this.transactionService.exportInstallments(exportFormatVO, installmentQuery);
        return this.writeFile(fileInfo);
    }

    public ResponseEntity<InputStream> exportInstallmentsOverview(InstallmentsApi.ExportInstallmentsOverviewParams exportInstallmentsOverviewParams) {
        InstallmentOverviewQueryFilters installmentOverviewQueryFilters = (InstallmentOverviewQueryFilters)ClassHelper.convert((Object)exportInstallmentsOverviewParams, InstallmentOverviewQueryFilters.class);
        InstallmentOverviewQuery installmentOverviewQuery = this.installmentsApiHelper.toInstallmentOverviewQuery(installmentOverviewQueryFilters);
        ExportFormatVO exportFormatVO = (ExportFormatVO)ModelHelper.voFromString(ExportFormatVO.class, (String)exportInstallmentsOverviewParams.format);
        FileInfo fileInfo = this.transactionService.exportInstallmentsOverview(exportFormatVO, installmentOverviewQuery);
        return this.writeFile(fileInfo);
    }

    public ResponseEntity<InstallmentDataForSearch> getInstallmentsDataForSearch(String string, List<String> list) {
        InstallmentSearchData installmentSearchData = this.transactionService.getInstallmentsSearchData(ModelHelper.accountOwner((String)string));
        InstallmentDataForSearch installmentDataForSearch = this.installmentsApiHelper.toInstallmentDataForSearch(installmentSearchData);
        return this.ok(installmentDataForSearch);
    }

    public ResponseEntity<InstallmentOverviewDataForSearch> getInstallmentsOverviewDataForSearch(List<String> list) {
        InstallmentOverviewSearchData installmentOverviewSearchData = this.transactionService.getInstallmentsOverviewSearchData();
        InstallmentOverviewDataForSearch installmentOverviewDataForSearch = this.installmentsApiHelper.toInstallmentOverviewDataForSearch(installmentOverviewSearchData);
        return this.ok(installmentOverviewDataForSearch);
    }

    public ResponseEntity<Transfer> processInstallment(String string, List<String> list, String string2) {
        InstallmentActionDTO installmentActionDTO = this.installmentsApiHelper.toInstallmentActionDTO(string, string2);
        TransferVO transferVO = this.transactionService.processInstallment(installmentActionDTO);
        Transfer transfer = this.transfersApiHelper.toTransfer(transferVO);
        return this.ok(transfer);
    }

    public ResponseEntity<List<InstallmentResult>> searchInstallments(InstallmentsApi.SearchInstallmentsParams searchInstallmentsParams) {
        InstallmentQueryFilters installmentQueryFilters = (InstallmentQueryFilters)ClassHelper.convert((Object)searchInstallmentsParams, InstallmentQueryFilters.class);
        InstallmentQuery installmentQuery = this.installmentsApiHelper.toInstallmentQuery(searchInstallmentsParams.owner, installmentQueryFilters);
        Page page = this.transactionService.searchInstallments(installmentQuery);
        return this.pageResponse(page, this.installmentsApiHelper::toInstallmentResult);
    }

    public ResponseEntity<List<InstallmentOverviewResult>> searchInstallmentsOverview(InstallmentsApi.SearchInstallmentsOverviewParams searchInstallmentsOverviewParams) {
        InstallmentOverviewQueryFilters installmentOverviewQueryFilters = (InstallmentOverviewQueryFilters)ClassHelper.convert((Object)searchInstallmentsOverviewParams, InstallmentOverviewQueryFilters.class);
        InstallmentOverviewQuery installmentOverviewQuery = this.installmentsApiHelper.toInstallmentOverviewQuery(installmentOverviewQueryFilters);
        Page page = this.transactionService.searchInstallmentsOverview(installmentOverviewQuery);
        return this.pageResponse(page, this.installmentsApiHelper::toInstallmentOverviewResult);
    }

    public ResponseEntity<Void> settleInstallment(String string, String string2) {
        InstallmentActionDTO installmentActionDTO = this.installmentsApiHelper.toInstallmentActionDTO(string, string2);
        this.transactionService.settleInstallment(installmentActionDTO);
        return ResponseEntity.noContent().build();
    }
}

