/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.utils.DateTime;
import org.cyclos.web.rest.api.MarketplaceApiImpl;
import org.cyclos.web.rest.model.AdAddressResultEnum;
import org.cyclos.web.rest.model.AdDataForEdit;
import org.cyclos.web.rest.model.AdDataForNew;
import org.cyclos.web.rest.model.AdDataForSearch;
import org.cyclos.web.rest.model.AdEdit;
import org.cyclos.web.rest.model.AdKind;
import org.cyclos.web.rest.model.AdNew;
import org.cyclos.web.rest.model.AdOrderByEnum;
import org.cyclos.web.rest.model.AdResult;
import org.cyclos.web.rest.model.AdStatusEnum;
import org.cyclos.web.rest.model.AdView;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.UserAdsDataForSearch;
import org.cyclos.web.rest.model.UserFavoriteAdsListData;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class MarketplaceApi {
    @Autowired
    private MarketplaceApiImpl impl;
    public static final String APPROVE_AD = "/marketplace/{ad}/approve";
    public static final String CREATE_AD = "/{user}/marketplace";
    public static final String DELETE_AD = "/marketplace/{ad}";
    public static final String EXPORT_AD = "/marketplace/{ad}/export/{format}";
    public static final String GET_AD_DATA_FOR_EDIT = "/marketplace/{ad}/data-for-edit";
    public static final String GET_AD_DATA_FOR_NEW = "/{user}/marketplace/data-for-new";
    public static final String GET_AD_DATA_FOR_SEARCH = "/marketplace/data-for-search";
    public static final String GET_USER_ADS_DATA_FOR_SEARCH = "/{user}/marketplace/data-for-search";
    public static final String GET_USER_FAVORITE_ADS_LIST_DATA = "/{user}/marketplace/list-favorites-data";
    public static final String HIDE_AD = "/marketplace/{ad}/hide";
    public static final String MARK_AS_FAVORITE = "/marketplace/{ad}/mark-as-favorite";
    public static final String REJECT_AD = "/marketplace/{ad}/reject";
    public static final String SEARCH_ADS = "/marketplace";
    public static final String SEARCH_USER_ADS = "/{user}/marketplace";
    public static final String SET_AD_AS_DRAFT = "/marketplace/{ad}/set-as-draft";
    public static final String SUBMIT_AD_FOR_AUTHORIZATION = "/marketplace/{ad}/request-authorization";
    public static final String UNHIDE_AD = "/marketplace/{ad}/unhide";
    public static final String UNMARK_AS_FAVORITE = "/marketplace/{ad}/unmark-as-favorite";
    public static final String UPDATE_AD = "/marketplace/{ad}";
    public static final String VIEW_AD = "/marketplace/{ad}";

    @RequestMapping(value={"/api/marketplace/{ad:.*}/approve"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> approveAd(@PathVariable(value="ad") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /marketplace/{ad}/approve");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.approveAd(string);
    }

    @RequestMapping(value={"/api/{user:.*}/marketplace"}, produces={"text/plain", "application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> createAd(@PathVariable(value="user") String string, @RequestBody(required=true) AdNew adNew, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/marketplace");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.createAd(string, adNew);
    }

    @RequestMapping(value={"/api/marketplace/{ad:.*}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteAd(@PathVariable(value="ad") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /marketplace/{ad}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.deleteAd(string);
    }

    @RequestMapping(value={"/api/marketplace/{ad:.*}/export/{format}"}, produces={"*/*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> exportAd(@PathVariable(value="ad") String string, @PathVariable(value="format") String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /marketplace/{ad}/export/{format}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.exportAd(string, string2);
    }

    @RequestMapping(value={"/api/marketplace/{ad:.*}/data-for-edit"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<AdDataForEdit> getAdDataForEdit(@PathVariable(value="ad") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /marketplace/{ad}/data-for-edit");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getAdDataForEdit(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/marketplace/data-for-new"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<AdDataForNew> getAdDataForNew(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="basedOnId", required=false) String string2, @RequestParam(value="kind", required=false) AdKind adKind, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/marketplace/data-for-new");
        httpServletRequest.setAttribute("errorType", Error.class);
        GetAdDataForNewParams getAdDataForNewParams = new GetAdDataForNewParams();
        getAdDataForNewParams.user = string;
        getAdDataForNewParams.fields = list;
        getAdDataForNewParams.basedOnId = string2;
        getAdDataForNewParams.kind = adKind;
        return this.impl.getAdDataForNew(getAdDataForNewParams);
    }

    @RequestMapping(value={"/api/marketplace/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<AdDataForSearch> getAdDataForSearch(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="kind", required=false) AdKind adKind, @RequestParam(value="brokered", required=false) Boolean bl, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /marketplace/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getAdDataForSearch(list, adKind, bl);
    }

    @RequestMapping(value={"/api/{user:.*}/marketplace/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UserAdsDataForSearch> getUserAdsDataForSearch(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="kind", required=false) AdKind adKind, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/marketplace/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getUserAdsDataForSearch(string, list, adKind);
    }

    @RequestMapping(value={"/api/{user:.*}/marketplace/list-favorites-data"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UserFavoriteAdsListData> getUserFavoriteAdsListData(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/marketplace/list-favorites-data");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserFavoriteAdsListData(string, list);
    }

    @RequestMapping(value={"/api/marketplace/{ad:.*}/hide"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> hideAd(@PathVariable(value="ad") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /marketplace/{ad}/hide");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.hideAd(string);
    }

    @RequestMapping(value={"/api/marketplace/{ad:.*}/mark-as-favorite"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> markAsFavorite(@PathVariable(value="ad") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /marketplace/{ad}/mark-as-favorite");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.markAsFavorite(string);
    }

    @RequestMapping(value={"/api/marketplace/{ad:.*}/reject"}, produces={"application/json"}, consumes={"text/plain"}, method={RequestMethod.POST})
    public ResponseEntity<Void> rejectAd(@PathVariable(value="ad") String string, @RequestBody(required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /marketplace/{ad}/reject");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.rejectAd(string, string2);
    }

    @RequestMapping(value={"/api/marketplace"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<AdResult>> searchAds(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="addressResult", required=false) AdAddressResultEnum adAddressResultEnum, @RequestParam(value="brokers", required=false) List<String> list2, @RequestParam(value="category", required=false) String string, @RequestParam(value="currency", required=false) String string2, @RequestParam(value="customFields", required=false) List<String> list3, @RequestParam(value="expirationPeriod", required=false) List<DateTime> list4, @RequestParam(value="favoriteFor", required=false) String string3, @RequestParam(value="groups", required=false) List<String> list5, @RequestParam(value="hasImages", required=false) Boolean bl, @RequestParam(value="keywords", required=false) String string4, @RequestParam(value="kind", required=false) AdKind adKind, @RequestParam(value="latitude", required=false) Double d, @RequestParam(value="longitude", required=false) Double d2, @RequestParam(value="maxDistance", required=false) Double d3, @RequestParam(value="orderBy", required=false) AdOrderByEnum adOrderByEnum, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="priceRange", required=false) List<BigDecimal> list6, @RequestParam(value="productNumber", required=false) String string5, @RequestParam(value="profileFields", required=false) List<String> list7, @RequestParam(value="publicationPeriod", required=false) List<DateTime> list8, @RequestParam(value="returnEditable", required=false) Boolean bl2, @RequestParam(value="skipTotalCount", required=false) Boolean bl3, @RequestParam(value="statuses", required=false) List<AdStatusEnum> list9, @RequestParam(value="user", required=false) String string6, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /marketplace");
        httpServletRequest.setAttribute("errorType", Error.class);
        SearchAdsParams searchAdsParams = new SearchAdsParams();
        searchAdsParams.fields = list;
        searchAdsParams.addressResult = adAddressResultEnum;
        searchAdsParams.brokers = list2;
        searchAdsParams.category = string;
        searchAdsParams.currency = string2;
        searchAdsParams.customFields = list3;
        searchAdsParams.expirationPeriod = list4;
        searchAdsParams.favoriteFor = string3;
        searchAdsParams.groups = list5;
        searchAdsParams.hasImages = bl;
        searchAdsParams.keywords = string4;
        searchAdsParams.kind = adKind;
        searchAdsParams.latitude = d;
        searchAdsParams.longitude = d2;
        searchAdsParams.maxDistance = d3;
        searchAdsParams.orderBy = adOrderByEnum;
        searchAdsParams.page = n;
        searchAdsParams.pageSize = n2;
        searchAdsParams.priceRange = list6;
        searchAdsParams.productNumber = string5;
        searchAdsParams.profileFields = list7;
        searchAdsParams.publicationPeriod = list8;
        searchAdsParams.returnEditable = bl2;
        searchAdsParams.skipTotalCount = bl3;
        searchAdsParams.statuses = list9;
        searchAdsParams.user = string6;
        return this.impl.searchAds(searchAdsParams);
    }

    @RequestMapping(value={"/api/{user:.*}/marketplace"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<AdResult>> searchUserAds(@PathVariable(value="user") String string, @RequestParam(value="addressResult", required=false) AdAddressResultEnum adAddressResultEnum, @RequestParam(value="category", required=false) String string2, @RequestParam(value="currency", required=false) String string3, @RequestParam(value="customFields", required=false) List<String> list, @RequestParam(value="expirationPeriod", required=false) List<DateTime> list2, @RequestParam(value="favoriteFor", required=false) String string4, @RequestParam(value="hasImages", required=false) Boolean bl, @RequestParam(value="keywords", required=false) String string5, @RequestParam(value="kind", required=false) AdKind adKind, @RequestParam(value="latitude", required=false) Double d, @RequestParam(value="longitude", required=false) Double d2, @RequestParam(value="maxDistance", required=false) Double d3, @RequestParam(value="orderBy", required=false) AdOrderByEnum adOrderByEnum, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="priceRange", required=false) List<BigDecimal> list3, @RequestParam(value="productNumber", required=false) String string6, @RequestParam(value="profileFields", required=false) List<String> list4, @RequestParam(value="publicationPeriod", required=false) List<DateTime> list5, @RequestParam(value="skipTotalCount", required=false) Boolean bl2, @RequestParam(value="statuses", required=false) List<AdStatusEnum> list6, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/marketplace");
        httpServletRequest.setAttribute("errorType", Error.class);
        SearchUserAdsParams searchUserAdsParams = new SearchUserAdsParams();
        searchUserAdsParams.user = string;
        searchUserAdsParams.addressResult = adAddressResultEnum;
        searchUserAdsParams.category = string2;
        searchUserAdsParams.currency = string3;
        searchUserAdsParams.customFields = list;
        searchUserAdsParams.expirationPeriod = list2;
        searchUserAdsParams.favoriteFor = string4;
        searchUserAdsParams.hasImages = bl;
        searchUserAdsParams.keywords = string5;
        searchUserAdsParams.kind = adKind;
        searchUserAdsParams.latitude = d;
        searchUserAdsParams.longitude = d2;
        searchUserAdsParams.maxDistance = d3;
        searchUserAdsParams.orderBy = adOrderByEnum;
        searchUserAdsParams.page = n;
        searchUserAdsParams.pageSize = n2;
        searchUserAdsParams.priceRange = list3;
        searchUserAdsParams.productNumber = string6;
        searchUserAdsParams.profileFields = list4;
        searchUserAdsParams.publicationPeriod = list5;
        searchUserAdsParams.skipTotalCount = bl2;
        searchUserAdsParams.statuses = list6;
        return this.impl.searchUserAds(searchUserAdsParams);
    }

    @RequestMapping(value={"/api/marketplace/{ad:.*}/set-as-draft"}, produces={"application/json"}, consumes={"text/plain"}, method={RequestMethod.POST})
    public ResponseEntity<Void> setAdAsDraft(@PathVariable(value="ad") String string, @RequestBody(required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /marketplace/{ad}/set-as-draft");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.setAdAsDraft(string, string2);
    }

    @RequestMapping(value={"/api/marketplace/{ad:.*}/request-authorization"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> submitAdForAuthorization(@PathVariable(value="ad") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /marketplace/{ad}/request-authorization");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.submitAdForAuthorization(string);
    }

    @RequestMapping(value={"/api/marketplace/{ad:.*}/unhide"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> unhideAd(@PathVariable(value="ad") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /marketplace/{ad}/unhide");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.unhideAd(string);
    }

    @RequestMapping(value={"/api/marketplace/{ad:.*}/unmark-as-favorite"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> unmarkAsFavorite(@PathVariable(value="ad") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /marketplace/{ad}/unmark-as-favorite");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.unmarkAsFavorite(string);
    }

    @RequestMapping(value={"/api/marketplace/{ad:.*}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> updateAd(@PathVariable(value="ad") String string, @RequestBody(required=true) AdEdit adEdit, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /marketplace/{ad}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.updateAd(string, adEdit);
    }

    @RequestMapping(value={"/api/marketplace/{ad:.*}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<AdView> viewAd(@PathVariable(value="ad") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /marketplace/{ad}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.viewAd(string, list);
    }

    public static class GetAdDataForNewParams {
        public String user;
        public static final String USER = "user";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String basedOnId;
        public static final String BASED_ON_ID = "basedOnId";
        public AdKind kind;
        public static final String KIND = "kind";
    }

    public static class SearchAdsParams {
        public List<String> fields;
        public static final String FIELDS = "fields";
        public AdAddressResultEnum addressResult;
        public static final String ADDRESS_RESULT = "addressResult";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String category;
        public static final String CATEGORY = "category";
        public String currency;
        public static final String CURRENCY = "currency";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public List<DateTime> expirationPeriod;
        public static final String EXPIRATION_PERIOD = "expirationPeriod";
        public String favoriteFor;
        public static final String FAVORITE_FOR = "favoriteFor";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Boolean hasImages;
        public static final String HAS_IMAGES = "hasImages";
        public String keywords;
        public static final String KEYWORDS = "keywords";
        public AdKind kind;
        public static final String KIND = "kind";
        public Double latitude;
        public static final String LATITUDE = "latitude";
        public Double longitude;
        public static final String LONGITUDE = "longitude";
        public Double maxDistance;
        public static final String MAX_DISTANCE = "maxDistance";
        public AdOrderByEnum orderBy;
        public static final String ORDER_BY = "orderBy";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public List<BigDecimal> priceRange;
        public static final String PRICE_RANGE = "priceRange";
        public String productNumber;
        public static final String PRODUCT_NUMBER = "productNumber";
        public List<String> profileFields;
        public static final String PROFILE_FIELDS = "profileFields";
        public List<DateTime> publicationPeriod;
        public static final String PUBLICATION_PERIOD = "publicationPeriod";
        public Boolean returnEditable;
        public static final String RETURN_EDITABLE = "returnEditable";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<AdStatusEnum> statuses;
        public static final String STATUSES = "statuses";
        public String user;
        public static final String USER = "user";
    }

    public static class SearchUserAdsParams {
        public String user;
        public static final String USER = "user";
        public AdAddressResultEnum addressResult;
        public static final String ADDRESS_RESULT = "addressResult";
        public String category;
        public static final String CATEGORY = "category";
        public String currency;
        public static final String CURRENCY = "currency";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public List<DateTime> expirationPeriod;
        public static final String EXPIRATION_PERIOD = "expirationPeriod";
        public String favoriteFor;
        public static final String FAVORITE_FOR = "favoriteFor";
        public Boolean hasImages;
        public static final String HAS_IMAGES = "hasImages";
        public String keywords;
        public static final String KEYWORDS = "keywords";
        public AdKind kind;
        public static final String KIND = "kind";
        public Double latitude;
        public static final String LATITUDE = "latitude";
        public Double longitude;
        public static final String LONGITUDE = "longitude";
        public Double maxDistance;
        public static final String MAX_DISTANCE = "maxDistance";
        public AdOrderByEnum orderBy;
        public static final String ORDER_BY = "orderBy";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public List<BigDecimal> priceRange;
        public static final String PRICE_RANGE = "priceRange";
        public String productNumber;
        public static final String PRODUCT_NUMBER = "productNumber";
        public List<String> profileFields;
        public static final String PROFILE_FIELDS = "profileFields";
        public List<DateTime> publicationPeriod;
        public static final String PUBLICATION_PERIOD = "publicationPeriod";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<AdStatusEnum> statuses;
        public static final String STATUSES = "statuses";
    }
}

