/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.util.List;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.marketplace.advertisements.AdDataParams;
import org.cyclos.model.marketplace.advertisements.AdDetailsData;
import org.cyclos.model.marketplace.advertisements.AdSearchData;
import org.cyclos.model.marketplace.advertisements.AdViewData;
import org.cyclos.model.marketplace.advertisements.BasicAdDTO;
import org.cyclos.model.marketplace.advertisements.BasicAdQuery;
import org.cyclos.model.marketplace.advertisements.BasicAdVO;
import org.cyclos.model.marketplace.advertisements.UserAdsSearchData;
import org.cyclos.model.marketplace.advertisements.UserFavoriteAdsListData;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.services.marketplace.AdService;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.MarketplaceApi;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.MarketplaceApiHelper;
import org.cyclos.web.rest.model.AdDataForEdit;
import org.cyclos.web.rest.model.AdDataForNew;
import org.cyclos.web.rest.model.AdDataForSearch;
import org.cyclos.web.rest.model.AdEdit;
import org.cyclos.web.rest.model.AdKind;
import org.cyclos.web.rest.model.AdNew;
import org.cyclos.web.rest.model.AdQueryFilters;
import org.cyclos.web.rest.model.AdResult;
import org.cyclos.web.rest.model.AdView;
import org.cyclos.web.rest.model.UserAdsDataForSearch;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class MarketplaceApiImpl
extends BaseApiImpl {
    @Autowired
    private AdService adService;
    @Autowired
    private MarketplaceApiHelper marketplaceApiHelper;

    public ResponseEntity<Void> approveAd(String string) {
        BasicAdVO basicAdVO = (BasicAdVO)ModelHelper.voFromString(BasicAdVO.class, (String)string);
        this.adService.approve(basicAdVO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<String> createAd(String string, AdNew adNew) {
        BasicAdDTO basicAdDTO = this.marketplaceApiHelper.toBasicAdDTO(adNew, adNew.getKind());
        basicAdDTO.setOwner((UserVO)ModelHelper.voFromString(UserVO.class, (String)string));
        String string2 = ApiHelper.toId(this.adService.save((EntityDTO)basicAdDTO));
        return this.created(this.apiHelper.uriFromApi("marketplace", string2), string2);
    }

    public ResponseEntity<Void> deleteAd(String string) {
        this.adService.remove(this.getAdId(string));
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<InputStream> exportAd(String string, String string2) {
        ExportFormatVO exportFormatVO = (ExportFormatVO)ModelHelper.voFromString(ExportFormatVO.class, (String)string2);
        BasicAdVO basicAdVO = (BasicAdVO)ModelHelper.voFromString(BasicAdVO.class, (String)string);
        FileInfo fileInfo = this.adService.exportAd(exportFormatVO, basicAdVO);
        return this.writeFile(fileInfo);
    }

    public ResponseEntity<AdDataForEdit> getAdDataForEdit(String string, List<String> list) {
        AdDetailsData adDetailsData = (AdDetailsData)this.adService.getData(this.getAdId(string));
        AdDataForEdit adDataForEdit = this.marketplaceApiHelper.toAdDataForEdit(adDetailsData);
        return this.ok(adDataForEdit);
    }

    public ResponseEntity<AdDataForNew> getAdDataForNew(MarketplaceApi.GetAdDataForNewParams getAdDataForNewParams) {
        AdDataParams adDataParams = new AdDataParams();
        adDataParams.setUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)getAdDataForNewParams.user));
        adDataParams.setType(this.marketplaceApiHelper.toAdType((AdKind)ObjectHelper.defaultValue((Object)getAdDataForNewParams.kind, (Object)AdKind.SIMPLE)));
        adDataParams.setBasedOnId(this.apiHelper.fromId(getAdDataForNewParams.basedOnId));
        AdDetailsData adDetailsData = (AdDetailsData)this.adService.getDataForNew((Object)adDataParams);
        AdDataForNew adDataForNew = this.marketplaceApiHelper.toAdDataForNew(adDetailsData);
        return this.ok(adDataForNew);
    }

    public ResponseEntity<AdDataForSearch> getAdDataForSearch(List<String> list, AdKind adKind, Boolean bl) {
        AdSearchData adSearchData = this.adService.getAdSearchData(this.marketplaceApiHelper.toAdType(adKind), Boolean.TRUE.equals(bl));
        AdDataForSearch adDataForSearch = this.marketplaceApiHelper.toAdDataForSearch(adSearchData);
        return this.ok(adDataForSearch);
    }

    public ResponseEntity<UserAdsDataForSearch> getUserAdsDataForSearch(String string, List<String> list, AdKind adKind) {
        UserAdsSearchData userAdsSearchData = this.adService.getUserAdsSearchData((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string), this.marketplaceApiHelper.toAdType(adKind));
        UserAdsDataForSearch userAdsDataForSearch = this.marketplaceApiHelper.toUserAdsDataForSearch(userAdsSearchData);
        return this.ok(userAdsDataForSearch);
    }

    public ResponseEntity<org.cyclos.web.rest.model.UserFavoriteAdsListData> getUserFavoriteAdsListData(String string, List<String> list) {
        UserFavoriteAdsListData userFavoriteAdsListData = this.adService.getFavoritesListData((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        org.cyclos.web.rest.model.UserFavoriteAdsListData userFavoriteAdsListData2 = this.marketplaceApiHelper.toUserFavoriteAdsListData(userFavoriteAdsListData);
        return this.ok(userFavoriteAdsListData2);
    }

    public ResponseEntity<Void> hideAd(String string) {
        this.hide(string, true);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> markAsFavorite(String string) {
        this.markAsFavorite(string, true);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> rejectAd(String string, String string2) {
        BasicAdVO basicAdVO = (BasicAdVO)ModelHelper.voFromString(BasicAdVO.class, (String)string);
        this.adService.reject(basicAdVO, string2);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<List<AdResult>> searchAds(MarketplaceApi.SearchAdsParams searchAdsParams) {
        AdQueryFilters adQueryFilters = (AdQueryFilters)ClassHelper.convert((Object)searchAdsParams, AdQueryFilters.class);
        BasicAdQuery basicAdQuery = this.marketplaceApiHelper.toBasicAdQuery(adQueryFilters);
        Page page = this.adService.search(basicAdQuery);
        return this.pageResponse(page, this.marketplaceApiHelper::toAdResult);
    }

    public ResponseEntity<List<AdResult>> searchUserAds(MarketplaceApi.SearchUserAdsParams searchUserAdsParams) {
        MarketplaceApi.SearchAdsParams searchAdsParams = (MarketplaceApi.SearchAdsParams)ClassHelper.convert((Object)searchUserAdsParams, MarketplaceApi.SearchAdsParams.class);
        searchAdsParams.user = searchUserAdsParams.user;
        searchAdsParams.returnEditable = true;
        return this.searchAds(searchAdsParams);
    }

    public ResponseEntity<Void> setAdAsDraft(String string, String string2) {
        this.adService.setAsDraft((BasicAdVO)ModelHelper.voFromString(BasicAdVO.class, (String)string), string2);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> submitAdForAuthorization(String string) {
        BasicAdVO basicAdVO = (BasicAdVO)ModelHelper.voFromString(BasicAdVO.class, (String)string);
        this.adService.submitForAuthorization(basicAdVO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> unhideAd(String string) {
        this.hide(string, false);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> unmarkAsFavorite(String string) {
        this.markAsFavorite(string, false);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> updateAd(String string, AdEdit adEdit) {
        BasicAdVO basicAdVO = this.adService.loadVO((BasicAdVO)ModelHelper.voFromString(BasicAdVO.class, (String)string));
        BasicAdDTO basicAdDTO = this.marketplaceApiHelper.toBasicAdDTO(adEdit, this.marketplaceApiHelper.toAdKind(basicAdVO.getType()));
        basicAdDTO.setId(this.apiHelper.fromId(string));
        this.adService.save((EntityDTO)basicAdDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<AdView> viewAd(String string, List<String> list) {
        AdViewData adViewData = this.adService.getViewData((BasicAdVO)ModelHelper.voFromString(BasicAdVO.class, (String)string));
        AdView adView = this.marketplaceApiHelper.toAdView(adViewData);
        return this.ok(adView);
    }

    private Long getAdId(String string) {
        BasicAdVO basicAdVO = (BasicAdVO)ModelHelper.voFromString(BasicAdVO.class, (String)string);
        return basicAdVO.getId() == null ? this.adService.loadVO(basicAdVO).getId() : basicAdVO.getId();
    }

    private void hide(String string, boolean bl) {
        BasicAdVO basicAdVO = (BasicAdVO)ModelHelper.voFromString(BasicAdVO.class, (String)string);
        this.adService.setHidden(basicAdVO, bl);
    }

    private void markAsFavorite(String string, boolean bl) {
        BasicAdVO basicAdVO = (BasicAdVO)ModelHelper.voFromString(BasicAdVO.class, (String)string);
        this.adService.markAsFavorite(basicAdVO, bl);
    }
}

