/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.utils.DateTime;
import org.cyclos.web.rest.api.MessagesApiImpl;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.MessageBoxEnum;
import org.cyclos.web.rest.model.MessageDataForReply;
import org.cyclos.web.rest.model.MessageDataForSearch;
import org.cyclos.web.rest.model.MessageDataForSend;
import org.cyclos.web.rest.model.MessageDestinationEnum;
import org.cyclos.web.rest.model.MessageResult;
import org.cyclos.web.rest.model.MessageView;
import org.cyclos.web.rest.model.MessagesStatus;
import org.cyclos.web.rest.model.ReplyMessage;
import org.cyclos.web.rest.model.SendMessage;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class MessagesApi {
    @Autowired
    private MessagesApiImpl impl;
    public static final String DELETE_MESSAGE = "/messages/{id}";
    public static final String GET_MESSAGE_DATA_FOR_REPLY = "/messages/{id}/data-for-reply";
    public static final String GET_MESSAGE_DATA_FOR_SEARCH = "/messages/data-for-search";
    public static final String GET_MESSAGE_DATA_FOR_SEND = "/messages/data-for-send";
    public static final String MARK_MESSAGES_AS_READ = "/messages/mark-as-read";
    public static final String MARK_MESSAGES_AS_UNREAD = "/messages/mark-as-unread";
    public static final String MESSAGES_STATUS = "/messages/status";
    public static final String MOVE_MESSAGES_TO_TRASH = "/messages/move-to-trash";
    public static final String REPLY_MESSAGE = "/messages/{id}/reply";
    public static final String RESTORE_MESSAGES_FROM_TRASH = "/messages/restore-from-trash";
    public static final String SEARCH_MESSAGES = "/messages";
    public static final String SEND_MESSAGE = "/messages";
    public static final String UPDATE_LAST_VIEW_DATE_FOR_MESSAGES = "/messages/viewed";
    public static final String VIEW_MESSAGE = "/messages/{id}";

    @RequestMapping(value={"/api/messages/{id}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteMessage(@PathVariable(value="id") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /messages/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.deleteMessage(string);
    }

    @RequestMapping(value={"/api/messages/{id}/data-for-reply"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<MessageDataForReply> getMessageDataForReply(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /messages/{id}/data-for-reply");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getMessageDataForReply(string, list);
    }

    @RequestMapping(value={"/api/messages/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<MessageDataForSearch> getMessageDataForSearch(@RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /messages/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getMessageDataForSearch(list);
    }

    @RequestMapping(value={"/api/messages/data-for-send"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<MessageDataForSend> getMessageDataForSend(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="user", required=false) String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /messages/data-for-send");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getMessageDataForSend(list, string);
    }

    @RequestMapping(value={"/api/messages/mark-as-read"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> markMessagesAsRead(@RequestParam(value="ids", required=true) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /messages/mark-as-read");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.markMessagesAsRead(list);
    }

    @RequestMapping(value={"/api/messages/mark-as-unread"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> markMessagesAsUnread(@RequestParam(value="ids", required=true) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /messages/mark-as-unread");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.markMessagesAsUnread(list);
    }

    @RequestMapping(value={"/api/messages/status"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<MessagesStatus> messagesStatus(HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /messages/status");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.messagesStatus();
    }

    @RequestMapping(value={"/api/messages/move-to-trash"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> moveMessagesToTrash(@RequestParam(value="ids", required=true) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /messages/move-to-trash");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.moveMessagesToTrash(list);
    }

    @RequestMapping(value={"/api/messages/{id}/reply"}, produces={"text/plain", "application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> replyMessage(@PathVariable(value="id") String string, @RequestBody(required=true) ReplyMessage replyMessage, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /messages/{id}/reply");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.replyMessage(string, replyMessage);
    }

    @RequestMapping(value={"/api/messages/restore-from-trash"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> restoreMessagesFromTrash(@RequestParam(value="ids", required=true) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /messages/restore-from-trash");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.restoreMessagesFromTrash(list);
    }

    @RequestMapping(value={"/api/messages"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<MessageResult>> searchMessages(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="category", required=false) String string, @RequestParam(value="destination", required=false) MessageDestinationEnum messageDestinationEnum, @RequestParam(value="keywords", required=false) String string2, @RequestParam(value="messageBox", required=false) MessageBoxEnum messageBoxEnum, @RequestParam(value="onlyUnread", required=false) Boolean bl, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="period", required=false) List<DateTime> list2, @RequestParam(value="skipTotalCount", required=false) Boolean bl2, @RequestParam(value="user", required=false) String string3, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /messages");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchMessagesParams searchMessagesParams = new SearchMessagesParams();
        searchMessagesParams.fields = list;
        searchMessagesParams.category = string;
        searchMessagesParams.destination = messageDestinationEnum;
        searchMessagesParams.keywords = string2;
        searchMessagesParams.messageBox = messageBoxEnum;
        searchMessagesParams.onlyUnread = bl;
        searchMessagesParams.page = n;
        searchMessagesParams.pageSize = n2;
        searchMessagesParams.period = list2;
        searchMessagesParams.skipTotalCount = bl2;
        searchMessagesParams.user = string3;
        return this.impl.searchMessages(searchMessagesParams);
    }

    @RequestMapping(value={"/api/messages"}, produces={"text/plain", "application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> sendMessage(@RequestBody(required=true) SendMessage sendMessage, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /messages");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.sendMessage(sendMessage);
    }

    @RequestMapping(value={"/api/messages/viewed"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> updateLastViewDateForMessages(HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /messages/viewed");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.updateLastViewDateForMessages();
    }

    @RequestMapping(value={"/api/messages/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<MessageView> viewMessage(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /messages/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.viewMessage(string, list);
    }

    public static class SearchMessagesParams {
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String category;
        public static final String CATEGORY = "category";
        public MessageDestinationEnum destination;
        public static final String DESTINATION = "destination";
        public String keywords;
        public static final String KEYWORDS = "keywords";
        public MessageBoxEnum messageBox;
        public static final String MESSAGE_BOX = "messageBox";
        public Boolean onlyUnread;
        public static final String ONLY_UNREAD = "onlyUnread";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public List<DateTime> period;
        public static final String PERIOD = "period";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public String user;
        public static final String USER = "user";
    }
}

