/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.cyclos.model.messaging.messages.MessageData;
import org.cyclos.model.messaging.messages.MessageQuery;
import org.cyclos.model.messaging.messages.MessageSearchData;
import org.cyclos.model.messaging.messages.MessageVO;
import org.cyclos.model.messaging.messages.MessagesStatusVO;
import org.cyclos.model.messaging.messages.SendMessageData;
import org.cyclos.model.users.users.UserActivityType;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.services.messaging.MessageService;
import org.cyclos.services.users.BasicUserService;
import org.cyclos.utils.Page;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.MessagesApi;
import org.cyclos.web.rest.helpers.MessagesApiHelper;
import org.cyclos.web.rest.model.MessageDataForReply;
import org.cyclos.web.rest.model.MessageDataForSearch;
import org.cyclos.web.rest.model.MessageDataForSend;
import org.cyclos.web.rest.model.MessageQueryFilters;
import org.cyclos.web.rest.model.MessageResult;
import org.cyclos.web.rest.model.MessageView;
import org.cyclos.web.rest.model.MessagesStatus;
import org.cyclos.web.rest.model.ReplyMessage;
import org.cyclos.web.rest.model.SendMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class MessagesApiImpl
extends BaseApiImpl {
    @Autowired
    private MessagesApiHelper messagesApiHelper;
    @Autowired
    private MessageService messageService;
    @Autowired
    private BasicUserService basicUserService;

    public ResponseEntity<Void> deleteMessage(String string) {
        this.messageService.removeAll(Collections.singleton(this.apiHelper.fromId(string)));
        return this.okOrNoContent(Optional.empty());
    }

    public ResponseEntity<MessageDataForReply> getMessageDataForReply(String string, List<String> list) {
        SendMessageData sendMessageData = this.messageService.getSendData(this.apiHelper.fromId(string), null);
        return this.ok(this.messagesApiHelper.toMessageDataForReply(sendMessageData));
    }

    public ResponseEntity<MessageDataForSearch> getMessageDataForSearch(List<String> list) {
        MessageSearchData messageSearchData = this.messageService.getSearchData();
        return this.ok(this.messagesApiHelper.toMessageDataForSearch(messageSearchData));
    }

    public ResponseEntity<MessageDataForSend> getMessageDataForSend(List<String> list, String string) {
        SendMessageData sendMessageData = this.messageService.getSendData(null, (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        return this.ok(this.messagesApiHelper.toMessageDataForSend(sendMessageData));
    }

    public ResponseEntity<Void> markMessagesAsRead(List<String> list) {
        this.messageService.markAsRead(this.apiHelper.fromIdsAsSet(list), true);
        return this.okOrNoContent(Optional.empty());
    }

    public ResponseEntity<Void> markMessagesAsUnread(List<String> list) {
        this.messageService.markAsRead(this.apiHelper.fromIdsAsSet(list), false);
        return this.okOrNoContent(Optional.empty());
    }

    public ResponseEntity<MessagesStatus> messagesStatus() {
        MessagesStatusVO messagesStatusVO = this.messageService.getMessagesStatus();
        return this.ok(this.messagesApiHelper.toMessagesStatus(messagesStatusVO));
    }

    public ResponseEntity<Void> moveMessagesToTrash(List<String> list) {
        this.messageService.moveToTrash(this.apiHelper.fromIdsAsSet(list));
        return this.okOrNoContent(Optional.empty());
    }

    public ResponseEntity<String> replyMessage(String string, ReplyMessage replyMessage) {
        long l = this.messageService.send(this.messagesApiHelper.toSendMessageDto(replyMessage, string));
        return this.created(this.apiHelper.uriFromApi("messages", l), l);
    }

    public ResponseEntity<Void> restoreMessagesFromTrash(List<String> list) {
        this.messageService.restoreAll(this.apiHelper.fromIdsAsSet(list));
        return this.okOrNoContent(Optional.empty());
    }

    public ResponseEntity<List<MessageResult>> searchMessages(MessagesApi.SearchMessagesParams searchMessagesParams) {
        MessageQueryFilters messageQueryFilters = (MessageQueryFilters)ClassHelper.convert((Object)searchMessagesParams, MessageQueryFilters.class);
        MessageQuery messageQuery = this.messagesApiHelper.toMessageQuery(messageQueryFilters);
        Page page = this.messageService.search(messageQuery);
        return this.pageResponse(page, messageVO -> this.messagesApiHelper.toMessageResult((MessageVO)messageVO));
    }

    public ResponseEntity<String> sendMessage(SendMessage sendMessage) {
        long l = this.messageService.send(this.messagesApiHelper.toSendMessageDto(sendMessage, null));
        return this.created(this.apiHelper.uriFromApi("messages", l), l);
    }

    public ResponseEntity<Void> updateLastViewDateForMessages() {
        this.basicUserService.updateUserActivity(UserActivityType.MESSAGE);
        return this.okOrNoContent(Optional.empty());
    }

    public ResponseEntity<MessageView> viewMessage(String string, List<String> list) {
        MessageData messageData = this.messageService.getData(this.apiHelper.fromId(string));
        return this.ok(this.messagesApiHelper.toMessageView(messageData));
    }
}

