/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.NotificationsApiImpl;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.Notification;
import org.cyclos.web.rest.model.NotificationsStatus;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class NotificationsApi {
    @Autowired
    private NotificationsApiImpl impl;
    public static final String DELETE_NOTIFICATION = "/notifications/{id}";
    public static final String MARK_NOTIFICATIONS_AS_READ = "/notifications/mark-as-read";
    public static final String NOTIFICATIONS_STATUS = "/notifications/status";
    public static final String SEARCH_NOTIFICATIONS = "/notifications";
    public static final String UPDATE_LAST_VIEW_DATE_FOR_NOTIFICATIONS = "/notifications/viewed";
    public static final String VIEW_NOTIFICATION = "/notifications/{id}";

    @RequestMapping(value={"/api/notifications/{id}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteNotification(@PathVariable(value="id") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /notifications/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.deleteNotification(string);
    }

    @RequestMapping(value={"/api/notifications/mark-as-read"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> markNotificationsAsRead(@RequestParam(value="ids", required=true) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /notifications/mark-as-read");
        return this.impl.markNotificationsAsRead(list);
    }

    @RequestMapping(value={"/api/notifications/status"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<NotificationsStatus> notificationsStatus(HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /notifications/status");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.notificationsStatus();
    }

    @RequestMapping(value={"/api/notifications"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Notification>> searchNotifications(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="onlyNew", required=false) Boolean bl, @RequestParam(value="onlyUnread", required=false) Boolean bl2, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl3, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /notifications");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchNotificationsParams searchNotificationsParams = new SearchNotificationsParams();
        searchNotificationsParams.fields = list;
        searchNotificationsParams.onlyNew = bl;
        searchNotificationsParams.onlyUnread = bl2;
        searchNotificationsParams.page = n;
        searchNotificationsParams.pageSize = n2;
        searchNotificationsParams.skipTotalCount = bl3;
        return this.impl.searchNotifications(searchNotificationsParams);
    }

    @RequestMapping(value={"/api/notifications/viewed"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> updateLastViewDateForNotifications(HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /notifications/viewed");
        return this.impl.updateLastViewDateForNotifications();
    }

    @RequestMapping(value={"/api/notifications/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<Notification> viewNotification(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /notifications/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.viewNotification(string, list);
    }

    public static class SearchNotificationsParams {
        public List<String> fields;
        public static final String FIELDS = "fields";
        public Boolean onlyNew;
        public static final String ONLY_NEW = "onlyNew";
        public Boolean onlyUnread;
        public static final String ONLY_UNREAD = "onlyUnread";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
    }
}

