/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.text.StringEscapeUtils;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.LoginException;
import org.cyclos.model.access.oidcclients.ResponseMode;
import org.cyclos.model.utils.AuthorizationData;
import org.cyclos.server.model.access.oidc.AuthorizeRequest;
import org.cyclos.server.model.access.oidc.AuthorizeResponse;
import org.cyclos.server.model.access.oidc.RegisterRequest;
import org.cyclos.server.model.access.oidc.RegisterResponse;
import org.cyclos.server.model.access.oidc.RevokeRequest;
import org.cyclos.server.model.access.oidc.TokenRequest;
import org.cyclos.server.model.access.oidc.TokenResponse;
import org.cyclos.services.access.OidcException;
import org.cyclos.services.access.OidcService;
import org.cyclos.services.contentmanagement.InternalTranslationMessageService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.OidcApi;
import org.cyclos.web.rest.helpers.OidcApiHelper;
import org.cyclos.web.rest.model.OidcAuthorizeResult;
import org.cyclos.web.rest.model.OidcError;
import org.cyclos.web.rest.model.OidcRegisterParams;
import org.cyclos.web.rest.model.OidcRegisterResult;
import org.cyclos.web.rest.model.OidcTokenResult;
import org.cyclos.web.utils.RequestHelper;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class OidcApiImpl
extends BaseApiImpl {
    @Autowired
    private OidcService oidcService;
    @Autowired
    private OidcApiHelper oidcApiHelper;
    @Autowired
    protected InternalTranslationMessageService internalTranslationMessageService;

    public ResponseEntity<?> oidcAuthorize(OidcApi.OidcAuthorizeParams oidcAuthorizeParams) {
        AuthorizeResponse authorizeResponse;
        AuthorizeRequest authorizeRequest = this.oidcApiHelper.toAuthorizationRequest(oidcAuthorizeParams);
        try {
            authorizeResponse = this.oidcService.authorize(authorizeRequest);
        }
        catch (Exception exception) {
            if (exception instanceof OidcException) {
                authorizeResponse = ((OidcException)exception).getResponse();
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("state", authorizeRequest.getState());
            hashMap.put("error", "server_error");
            if (StringHelper.isNotBlank((Object)exception.getMessage())) {
                hashMap.put("error_description", exception.getMessage());
            }
            authorizeResponse = new AuthorizeResponse(null, ResponseMode.of((String)authorizeRequest.getResponseMode()), hashMap);
        }
        return this.toResponseEntity(authorizeResponse);
    }

    public ResponseEntity<?> oidcJwks() {
        Object object = this.oidcService.getPublicKeys();
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).contentType(MediaType.APPLICATION_JSON).body((Object)object.toString());
    }

    public ResponseEntity<OidcRegisterResult> oidcRegister(OidcRegisterParams oidcRegisterParams) {
        RegisterRequest registerRequest = this.oidcApiHelper.toRegisterRequest(oidcRegisterParams);
        RegisterResponse registerResponse = this.oidcService.register(registerRequest);
        OidcRegisterResult oidcRegisterResult = this.oidcApiHelper.toOidcRegisterResult(registerResponse);
        return this.ok(oidcRegisterResult);
    }

    public ResponseEntity<Void> oidcRevoke(String string, String string2, String string3) {
        HttpServletRequest httpServletRequest = ServletHelper.getRequest();
        ServletHelper.forceGuest(httpServletRequest);
        AuthorizationData authorizationData = RequestHelper.getAuthorization(httpServletRequest);
        if (authorizationData != null) {
            if (!authorizationData.isBasic()) {
                throw new LoginException();
            }
            string2 = authorizationData.getPrincipal();
            string3 = authorizationData.getPassword();
        }
        RevokeRequest revokeRequest = this.oidcApiHelper.toRevokeRequest(string2, string3, string);
        this.oidcService.revoke(revokeRequest);
        return ResponseEntity.ok().build();
    }

    public ResponseEntity<?> oidcToken(OidcApi.OidcTokenParams oidcTokenParams) {
        HttpServletResponse httpServletResponse = ServletHelper.getResponse();
        httpServletResponse.setHeader("Cache-Control", "no-store");
        httpServletResponse.setHeader("Pragma", "no-cache");
        HttpServletRequest httpServletRequest = ServletHelper.getRequest();
        ServletHelper.forceGuest(httpServletRequest);
        AuthorizationData authorizationData = RequestHelper.getAuthorization(httpServletRequest);
        if (authorizationData != null) {
            if (!authorizationData.isBasic()) {
                throw new LoginException();
            }
            oidcTokenParams.clientId = authorizationData.getPrincipal();
            oidcTokenParams.clientSecret = authorizationData.getPassword();
        }
        TokenRequest tokenRequest = this.oidcApiHelper.toTokenRequest(oidcTokenParams);
        try {
            TokenResponse tokenResponse = this.oidcService.token(tokenRequest);
            OidcTokenResult oidcTokenResult = this.oidcApiHelper.toOidcTokenResult(tokenResponse);
            return this.ok(oidcTokenResult);
        }
        catch (Exception exception) {
            HttpStatus httpStatus;
            OidcError oidcError = new OidcError();
            if (exception instanceof OidcException) {
                Map map = ((OidcException)exception).getResponse().getParameters();
                oidcError.setError((String)map.get("error"));
                oidcError.setErrorDescription((String)map.get("error_description"));
                httpStatus = HttpStatus.BAD_REQUEST;
            } else {
                oidcError.setError("server_error");
                if (StringHelper.isNotBlank((Object)exception.getMessage())) {
                    oidcError.setErrorDescription(exception.getMessage());
                }
                httpStatus = HttpStatus.INTERNAL_SERVER_ERROR;
            }
            return ResponseEntity.status((HttpStatus)httpStatus).contentType(MediaType.APPLICATION_JSON).body((Object)oidcError);
        }
    }

    public ResponseEntity<Object> oidcUserInfoGet() {
        Map map = this.oidcService.userInfo();
        return this.ok(map);
    }

    public ResponseEntity<Object> oidcUserInfoPost() {
        return this.oidcUserInfoGet();
    }

    protected ResponseEntity<?> toResponseEntity(AuthorizeResponse authorizeResponse) {
        if (StringHelper.isBlank((Object)authorizeResponse.getUrl())) {
            return ResponseEntity.badRequest().contentType(MediaType.APPLICATION_FORM_URLENCODED).body((Object)StringHelper.urlEncode((Map)authorizeResponse.getParameters()));
        }
        ResponseMode responseMode = (ResponseMode)ObjectHelper.defaultValue((Object)authorizeResponse.getResponseMode(), (Object)ResponseMode.QUERY);
        OidcAuthorizeResult oidcAuthorizeResult = this.oidcApiHelper.toOidcAuthorizeResult(authorizeResponse);
        if (responseMode == ResponseMode.FORM_POST) {
            return this.formPost(oidcAuthorizeResult.getUrl(), oidcAuthorizeResult.getPostData());
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create(oidcAuthorizeResult.getUrl()))).build();
    }

    private ResponseEntity<?> formPost(String string3, Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder("<!DOCTYPE html>\n").append("<html><head>\n").append("<meta charset='utf-8'>\n").append("<body><form id='form-post' method='POST' enctype='multipart/form-data' action='").append(StringEscapeUtils.escapeXml11((String)string3)).append("'>\n");
        if (CollectionHelper.isNotEmpty(map)) {
            map.forEach((string, string2) -> stringBuilder.append("<input type='hidden' name='").append((String)string).append("' value='").append((String)string2).append("'>\n"));
        }
        stringBuilder.append("<noscript><div>");
        stringBuilder.append(this.internalTranslationMessageService.message(AccessKeys.OidcConsent.FORM_POST_NO_SCRIPT, new Object[0]));
        stringBuilder.append("</div>\n<button type='submit'>");
        stringBuilder.append(this.internalTranslationMessageService.message(AccessKeys.OidcConsent.FORM_POST_CONTINUE, new Object[0]));
        stringBuilder.append("</button></noscript>\n");
        stringBuilder.append("<script>document.getElementById('form-post').submit();</script>\n");
        stringBuilder.append("</form></body></html>");
        return this.html(stringBuilder.toString());
    }
}

