/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.util.List;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.marketplace.webshoporders.OrderDTO;
import org.cyclos.model.marketplace.webshoporders.OrderData;
import org.cyclos.model.marketplace.webshoporders.OrderQuery;
import org.cyclos.model.marketplace.webshoporders.OrderSearchData;
import org.cyclos.model.marketplace.webshoporders.OrderStatus;
import org.cyclos.model.marketplace.webshoporders.OrderVO;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.services.marketplace.InternalOrderService;
import org.cyclos.services.marketplace.OrderService;
import org.cyclos.utils.Page;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.OrdersApi;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.OrdersApiHelper;
import org.cyclos.web.rest.model.AcceptOrderByBuyer;
import org.cyclos.web.rest.model.AcceptOrderBySeller;
import org.cyclos.web.rest.model.OrderDataForAcceptByBuyer;
import org.cyclos.web.rest.model.OrderDataForEdit;
import org.cyclos.web.rest.model.OrderDataForNew;
import org.cyclos.web.rest.model.OrderDataForSearch;
import org.cyclos.web.rest.model.OrderDataForSetDeliveryMethod;
import org.cyclos.web.rest.model.OrderEdit;
import org.cyclos.web.rest.model.OrderNew;
import org.cyclos.web.rest.model.OrderQueryFilters;
import org.cyclos.web.rest.model.OrderView;
import org.cyclos.web.rest.model.RejectOrder;
import org.cyclos.web.rest.model.SetDeliveryMethod;
import org.cyclos.web.rest.model.UserOrderResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class OrdersApiImpl
extends BaseApiImpl {
    @Autowired
    private OrderService orderService;
    @Autowired
    private InternalOrderService internalOrderService;
    @Autowired
    private OrdersApiHelper ordersApiHelper;

    public ResponseEntity<Void> acceptOrderByBuyer(String string, String string2, AcceptOrderByBuyer acceptOrderByBuyer) {
        this.internalOrderService.acceptByBuyer(this.ordersApiHelper.toAcceptOrderParams(string, string2, acceptOrderByBuyer));
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> acceptOrderBySeller(String string, AcceptOrderBySeller acceptOrderBySeller) {
        this.internalOrderService.acceptBySeller(this.ordersApiHelper.toAcceptOrderParams(string, acceptOrderBySeller));
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<String> createOrder(String string, OrderNew orderNew) {
        OrderDTO orderDTO = this.ordersApiHelper.toOrderDTO(orderNew);
        orderDTO.setSeller((UserVO)ModelHelper.voFromString(UserVO.class, (String)string));
        String string2 = this.saveAsDraftOrSendToBuyer(orderDTO);
        return this.created(this.apiHelper.uriFromApi("orders", string2), string2);
    }

    public ResponseEntity<Void> deleteOrder(String string) {
        this.orderService.remove(Long.valueOf(this.getOrderId(string)));
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<InputStream> exportOrder(String string, String string2) {
        ExportFormatVO exportFormatVO = (ExportFormatVO)ModelHelper.voFromString(ExportFormatVO.class, (String)string2);
        OrderVO orderVO = (OrderVO)ModelHelper.voFromString(OrderVO.class, (String)string);
        FileInfo fileInfo = this.orderService.exportOrder(exportFormatVO, orderVO);
        return this.writeFile(fileInfo);
    }

    public ResponseEntity<OrderDataForSetDeliveryMethod> getDataForSetDeliveryMethod(String string, List<String> list) {
        OrderData orderData = this.orderService.getOrderData((OrderVO)ModelHelper.voFromString(OrderVO.class, (String)string));
        OrderDataForSetDeliveryMethod orderDataForSetDeliveryMethod = this.ordersApiHelper.toOrderDataForSetDeliveryMethod(orderData);
        return this.ok(orderDataForSetDeliveryMethod);
    }

    public ResponseEntity<OrderDataForAcceptByBuyer> getOrderDataForAcceptByBuyer(String string, List<String> list) {
        OrderData orderData = this.orderService.getOrderData((OrderVO)ModelHelper.voFromString(OrderVO.class, (String)string));
        OrderDataForAcceptByBuyer orderDataForAcceptByBuyer = this.ordersApiHelper.toOrderDataForAcceptByBuyer(orderData);
        return this.ok(orderDataForAcceptByBuyer);
    }

    public ResponseEntity<OrderDataForEdit> getOrderDataForEdit(String string, List<String> list) {
        OrderData orderData = this.orderService.getOrderData((OrderVO)ModelHelper.voFromString(OrderVO.class, (String)string));
        OrderDataForEdit orderDataForEdit = this.ordersApiHelper.toOrderDataForEdit(orderData);
        return this.ok(orderDataForEdit);
    }

    public ResponseEntity<OrderDataForNew> getOrderDataForNew(OrdersApi.GetOrderDataForNewParams getOrderDataForNewParams) {
        String string = getOrderDataForNewParams.user;
        String string2 = getOrderDataForNewParams.buyer;
        String string3 = getOrderDataForNewParams.currency;
        OrderData orderData = (OrderData)this.orderService.getDataForNew((Object)this.ordersApiHelper.toOrderDataParams(string, string2, string3));
        OrderDataForNew orderDataForNew = this.ordersApiHelper.toOrderDataForNew(orderData);
        return this.ok(orderDataForNew);
    }

    public ResponseEntity<OrderDataForSearch> getOrderDataForSearch(String string, List<String> list, Boolean bl) {
        OrderSearchData orderSearchData = this.orderService.getSearchData((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string), Boolean.TRUE.equals(bl));
        OrderDataForSearch orderDataForSearch = this.ordersApiHelper.toOrderDataForSearch(orderSearchData);
        return this.ok(orderDataForSearch);
    }

    public ResponseEntity<Void> rejectOrder(String string, RejectOrder rejectOrder) {
        this.orderService.reject(this.ordersApiHelper.toRejectOrderParams(string, rejectOrder));
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<List<UserOrderResult>> searchUserOrders(OrdersApi.SearchUserOrdersParams searchUserOrdersParams) {
        OrderQueryFilters orderQueryFilters = (OrderQueryFilters)ClassHelper.convert((Object)searchUserOrdersParams, OrderQueryFilters.class);
        OrderQuery orderQuery = this.ordersApiHelper.toOrderQuery(searchUserOrdersParams.user, orderQueryFilters);
        Page page = this.orderService.search(orderQuery);
        return this.pageResponse(page, orderVO -> this.ordersApiHelper.toUserOrderResult((OrderVO)orderVO, orderQuery.isSales()));
    }

    public ResponseEntity<Void> setDeliveryMethod(String string, SetDeliveryMethod setDeliveryMethod) {
        this.orderService.setDeliveryMethod(this.ordersApiHelper.toSetDeliveryMethodParams(string, setDeliveryMethod));
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> updateOrder(String string, OrderEdit orderEdit) {
        OrderDTO orderDTO = this.ordersApiHelper.toOrderDTO(orderEdit);
        orderDTO.setId(Long.valueOf(this.getOrderId(string)));
        this.saveAsDraftOrSendToBuyer(orderDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<OrderView> viewOrder(String string, List<String> list) {
        OrderData orderData = this.orderService.getOrderData((OrderVO)ModelHelper.voFromString(OrderVO.class, (String)string));
        OrderView orderView = this.ordersApiHelper.toOrderView(orderData);
        return this.ok(orderView);
    }

    private long getOrderId(String string) {
        OrderVO orderVO = (OrderVO)ModelHelper.voFromString(OrderVO.class, (String)string);
        return orderVO.getId() == null ? this.orderService.getOrderId(orderVO) : orderVO.getId().longValue();
    }

    private String saveAsDraftOrSendToBuyer(OrderDTO orderDTO) {
        if (orderDTO.getStatus() == OrderStatus.DRAFT) {
            return ApiHelper.toId(this.orderService.save((EntityDTO)orderDTO));
        }
        return ApiHelper.toId(this.orderService.submitToBuyer(orderDTO));
    }
}

