/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cyclos.model.banking.transactions.TransactionResultVO;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.users.references.ReferenceStatisticsParams;
import org.cyclos.model.users.references.ReferenceStatisticsVO;
import org.cyclos.model.users.references.TransactionFeedbackData;
import org.cyclos.model.users.references.TransactionFeedbackQuery;
import org.cyclos.model.users.references.TransactionFeedbackSearchData;
import org.cyclos.model.users.references.TransactionFeedbackUpdateDTO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.services.users.TransactionFeedbackService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.PaymentFeedbacksApi;
import org.cyclos.web.rest.helpers.PaymentFeedbacksApiHelper;
import org.cyclos.web.rest.helpers.ReferencesApiHelper;
import org.cyclos.web.rest.helpers.TransactionsApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.PaymentFeedbackDataForEdit;
import org.cyclos.web.rest.model.PaymentFeedbackDataForGive;
import org.cyclos.web.rest.model.PaymentFeedbackDataForReply;
import org.cyclos.web.rest.model.PaymentFeedbackDataForSearch;
import org.cyclos.web.rest.model.PaymentFeedbackEdit;
import org.cyclos.web.rest.model.PaymentFeedbackGive;
import org.cyclos.web.rest.model.PaymentFeedbackResult;
import org.cyclos.web.rest.model.PaymentFeedbackView;
import org.cyclos.web.rest.model.ReferenceStatistics;
import org.cyclos.web.rest.model.TransactionResult;
import org.cyclos.web.rest.model.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class PaymentFeedbacksApiImpl
extends BaseApiImpl {
    @Autowired
    private PaymentFeedbacksApiHelper paymentFeedbacksApiHelper;
    @Autowired
    private ReferencesApiHelper referencesApiHelper;
    @Autowired
    private TransactionsApiHelper tranactionsApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private TransactionFeedbackService tranactionFeedbackService;

    public ResponseEntity<Void> addPaymentFeedbackIgnoredUser(String string, String string2) {
        return this.markAsIgnored(string2, true);
    }

    public ResponseEntity<PaymentFeedbackDataForEdit> getPaymentFeedbackDataForEdit(String string, List<String> list) {
        TransactionFeedbackData transactionFeedbackData = this.tranactionFeedbackService.getDataFromTransaction(this.asTrasaction(string));
        PaymentFeedbackDataForEdit paymentFeedbackDataForEdit = this.paymentFeedbacksApiHelper.toPaymentFeedbackDataForEdit(transactionFeedbackData);
        return this.ok(paymentFeedbackDataForEdit);
    }

    public ResponseEntity<PaymentFeedbackDataForGive> getPaymentFeedbacksDataForGive(String string, List<String> list) {
        TransactionFeedbackData transactionFeedbackData = this.tranactionFeedbackService.getGiveData(this.asTrasaction(string));
        PaymentFeedbackDataForGive paymentFeedbackDataForGive = this.paymentFeedbacksApiHelper.toPaymentFeedbackDataForGive(transactionFeedbackData);
        return this.ok(paymentFeedbackDataForGive);
    }

    public ResponseEntity<PaymentFeedbackDataForReply> getPaymentFeedbacksDataForReply(String string, List<String> list) {
        TransactionFeedbackData transactionFeedbackData = this.tranactionFeedbackService.getReplyData(this.asTrasaction(string));
        PaymentFeedbackDataForReply paymentFeedbackDataForReply = this.paymentFeedbacksApiHelper.toPaymentFeedbackDataForReply(transactionFeedbackData);
        return this.ok(paymentFeedbackDataForReply);
    }

    public ResponseEntity<PaymentFeedbackDataForSearch> getPaymentFeedbacksDataForSearch(String string, List<String> list) {
        TransactionFeedbackSearchData transactionFeedbackSearchData = this.tranactionFeedbackService.getSearchData((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        PaymentFeedbackDataForSearch paymentFeedbackDataForSearch = this.paymentFeedbacksApiHelper.toPaymentFeedbackDataForSearch(transactionFeedbackSearchData);
        return this.ok(paymentFeedbackDataForSearch);
    }

    public ResponseEntity<ReferenceStatistics> getPaymentFeedbackStatistics(PaymentFeedbacksApi.GetPaymentFeedbackStatisticsParams getPaymentFeedbackStatisticsParams) {
        ReferenceStatisticsParams referenceStatisticsParams = this.referencesApiHelper.statisticParamsBuilder().buildFrom(getPaymentFeedbackStatisticsParams);
        ReferenceStatisticsVO referenceStatisticsVO = this.tranactionFeedbackService.getStatistics(referenceStatisticsParams);
        ReferenceStatistics referenceStatistics = this.referencesApiHelper.toReferenceStatistics(referenceStatisticsVO);
        return this.ok(referenceStatistics);
    }

    public ResponseEntity<Void> givePaymentFeedback(String string, PaymentFeedbackGive paymentFeedbackGive) {
        this.tranactionFeedbackService.comment(this.asTrasaction(string), this.referencesApiHelper.toReferenceLevel(paymentFeedbackGive.getLevel()), paymentFeedbackGive.getComments());
        return ResponseEntity.noContent().location(this.apiHelper.uriFromApi("payment-feedbacks", string)).build();
    }

    public ResponseEntity<List<User>> listPaymentFeedbackIgnoredUsers(String string, List<String> list) {
        List list2 = this.tranactionFeedbackService.listIgnoredUsers();
        return this.ok(CollectionHelper.orEmpty((List)list2).stream().map(this.usersApiHelper::toUser).collect(Collectors.toList()));
    }

    public ResponseEntity<Void> removePaymentFeedback(String string) {
        this.tranactionFeedbackService.removeFromTransaction(this.asTrasaction(string));
        return this.okOrNoContent(Optional.empty());
    }

    public ResponseEntity<Void> removePaymentFeedbackIgnoredUser(String string, String string2) {
        return this.markAsIgnored(string2, false);
    }

    public ResponseEntity<Void> replyPaymentFeedback(String string, String string2) {
        this.tranactionFeedbackService.reply(this.asTrasaction(string), string2);
        return ResponseEntity.noContent().location(this.apiHelper.uriFromApi("payment-feedbacks", string)).build();
    }

    public ResponseEntity<List<TransactionResult>> searchPaymentAwaitingFeedback(PaymentFeedbacksApi.SearchPaymentAwaitingFeedbackParams searchPaymentAwaitingFeedbackParams) {
        Page page = this.tranactionFeedbackService.searchTransactionsAwaitingFeedback(this.paymentFeedbacksApiHelper.toTransactionAwaitingFeedbackQuery(searchPaymentAwaitingFeedbackParams));
        return this.pageResponse(page, transactionResultVO -> this.tranactionsApiHelper.toTransactionResult((TransactionResultVO)transactionResultVO, true));
    }

    public ResponseEntity<List<PaymentFeedbackResult>> searchPaymentFeedbacks(PaymentFeedbacksApi.SearchPaymentFeedbacksParams searchPaymentFeedbacksParams) {
        TransactionFeedbackQuery transactionFeedbackQuery = this.paymentFeedbacksApiHelper.toTransactionFeedbackQuery(searchPaymentFeedbacksParams);
        Page page = this.tranactionFeedbackService.search(transactionFeedbackQuery);
        return this.pageResponse(page, this.paymentFeedbacksApiHelper::toPaymentFeedbackResult);
    }

    public ResponseEntity<Void> updatePaymentFeedback(String string, PaymentFeedbackEdit paymentFeedbackEdit) {
        TransactionFeedbackUpdateDTO transactionFeedbackUpdateDTO = this.paymentFeedbacksApiHelper.toTranactionFeedbackUpdateDTO(paymentFeedbackEdit);
        this.tranactionFeedbackService.updateFeedbackFromTransaction(this.asTrasaction(string), transactionFeedbackUpdateDTO);
        return ResponseEntity.noContent().location(this.apiHelper.uriFromApi("payment-feedbacks", string)).build();
    }

    public ResponseEntity<PaymentFeedbackView> viewPaymentFeedback(String string, List<String> list) {
        TransactionFeedbackData transactionFeedbackData = this.tranactionFeedbackService.getDataFromTransaction(this.asTrasaction(string));
        PaymentFeedbackView paymentFeedbackView = this.paymentFeedbacksApiHelper.toPaymentFeedbackView(transactionFeedbackData);
        return this.ok(paymentFeedbackView);
    }

    private TransactionVO asTrasaction(String string) {
        return (TransactionVO)ModelHelper.voFromString(TransactionVO.class, (String)string);
    }

    private ResponseEntity<Void> markAsIgnored(String string, boolean bl) {
        this.tranactionFeedbackService.markAsIgnored((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string), bl);
        return this.okOrNoContent(Optional.empty());
    }
}

