/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.PaymentLimitsApiImpl;
import org.cyclos.web.rest.model.AccountPaymentLimitsData;
import org.cyclos.web.rest.model.DataForPaymentLimitsSearch;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.GeneralAccountPaymentLimitsResult;
import org.cyclos.web.rest.model.SetAccountPaymentLimits;
import org.cyclos.web.rest.model.UserAccountPaymentLimitsListData;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class PaymentLimitsApi {
    @Autowired
    private PaymentLimitsApiImpl impl;
    public static final String EXPORT_ACCOUNT_PAYMENT_LIMITS = "/accounts/payment-limits/export/{format}";
    public static final String GET_ACCOUNT_PAYMENT_LIMITS = "/{user}/accounts/{accountType}/payment-limits";
    public static final String GET_ACCOUNT_PAYMENT_LIMITS_DATA = "/accounts/data-for-payment-limits";
    public static final String GET_DATA_FOR_USER_PAYMENT_LIMITS = "/{user}/accounts/data-for-payment-limits";
    public static final String SEARCH_ACCOUNT_PAYMENT_LIMITS = "/accounts/payment-limits";
    public static final String SET_ACCOUNT_PAYMENT_LIMITS = "/{user}/accounts/{accountType}/payment-limits";

    @RequestMapping(value={"/api/accounts/payment-limits/export/{format}"}, produces={"*/*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> exportAccountPaymentLimits(@PathVariable(value="format") String string, @RequestParam(value="accountType", required=false) String string2, @RequestParam(value="brokers", required=false) List<String> list, @RequestParam(value="by", required=false) String string3, @RequestParam(value="currency", required=false) String string4, @RequestParam(value="customAmountLimit", required=false) Boolean bl, @RequestParam(value="customAmountLimitRange", required=false) List<BigDecimal> list2, @RequestParam(value="customAmountPerDayLimit", required=false) Boolean bl2, @RequestParam(value="customAmountPerDayLimitRange", required=false) List<BigDecimal> list3, @RequestParam(value="customAmountPerMonthLimit", required=false) Boolean bl3, @RequestParam(value="customAmountPerMonthLimitRange", required=false) List<BigDecimal> list4, @RequestParam(value="customAmountPerWeekLimit", required=false) Boolean bl4, @RequestParam(value="customAmountPerWeekLimitRange", required=false) List<BigDecimal> list5, @RequestParam(value="customAmountPerYearLimit", required=false) Boolean bl5, @RequestParam(value="customAmountPerYearLimitRange", required=false) List<BigDecimal> list6, @RequestParam(value="groups", required=false) List<String> list7, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl6, @RequestParam(value="user", required=false) String string5, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /accounts/payment-limits/export/{format}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        ExportAccountPaymentLimitsParams exportAccountPaymentLimitsParams = new ExportAccountPaymentLimitsParams();
        exportAccountPaymentLimitsParams.format = string;
        exportAccountPaymentLimitsParams.accountType = string2;
        exportAccountPaymentLimitsParams.brokers = list;
        exportAccountPaymentLimitsParams.by = string3;
        exportAccountPaymentLimitsParams.currency = string4;
        exportAccountPaymentLimitsParams.customAmountLimit = bl;
        exportAccountPaymentLimitsParams.customAmountLimitRange = list2;
        exportAccountPaymentLimitsParams.customAmountPerDayLimit = bl2;
        exportAccountPaymentLimitsParams.customAmountPerDayLimitRange = list3;
        exportAccountPaymentLimitsParams.customAmountPerMonthLimit = bl3;
        exportAccountPaymentLimitsParams.customAmountPerMonthLimitRange = list4;
        exportAccountPaymentLimitsParams.customAmountPerWeekLimit = bl4;
        exportAccountPaymentLimitsParams.customAmountPerWeekLimitRange = list5;
        exportAccountPaymentLimitsParams.customAmountPerYearLimit = bl5;
        exportAccountPaymentLimitsParams.customAmountPerYearLimitRange = list6;
        exportAccountPaymentLimitsParams.groups = list7;
        exportAccountPaymentLimitsParams.page = n;
        exportAccountPaymentLimitsParams.pageSize = n2;
        exportAccountPaymentLimitsParams.skipTotalCount = bl6;
        exportAccountPaymentLimitsParams.user = string5;
        return this.impl.exportAccountPaymentLimits(exportAccountPaymentLimitsParams);
    }

    @RequestMapping(value={"/api/{user:.*}/accounts/{accountType}/payment-limits"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<AccountPaymentLimitsData> getAccountPaymentLimits(@PathVariable(value="user") String string, @PathVariable(value="accountType") String string2, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/accounts/{accountType}/payment-limits");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getAccountPaymentLimits(string, string2, list);
    }

    @RequestMapping(value={"/api/accounts/data-for-payment-limits"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForPaymentLimitsSearch> getAccountPaymentLimitsData(@RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /accounts/data-for-payment-limits");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getAccountPaymentLimitsData(list);
    }

    @RequestMapping(value={"/api/{user:.*}/accounts/data-for-payment-limits"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UserAccountPaymentLimitsListData> getDataForUserPaymentLimits(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/accounts/data-for-payment-limits");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getDataForUserPaymentLimits(string, list);
    }

    @RequestMapping(value={"/api/accounts/payment-limits"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<GeneralAccountPaymentLimitsResult>> searchAccountPaymentLimits(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="accountType", required=false) String string, @RequestParam(value="brokers", required=false) List<String> list2, @RequestParam(value="by", required=false) String string2, @RequestParam(value="currency", required=false) String string3, @RequestParam(value="customAmountLimit", required=false) Boolean bl, @RequestParam(value="customAmountLimitRange", required=false) List<BigDecimal> list3, @RequestParam(value="customAmountPerDayLimit", required=false) Boolean bl2, @RequestParam(value="customAmountPerDayLimitRange", required=false) List<BigDecimal> list4, @RequestParam(value="customAmountPerMonthLimit", required=false) Boolean bl3, @RequestParam(value="customAmountPerMonthLimitRange", required=false) List<BigDecimal> list5, @RequestParam(value="customAmountPerWeekLimit", required=false) Boolean bl4, @RequestParam(value="customAmountPerWeekLimitRange", required=false) List<BigDecimal> list6, @RequestParam(value="customAmountPerYearLimit", required=false) Boolean bl5, @RequestParam(value="customAmountPerYearLimitRange", required=false) List<BigDecimal> list7, @RequestParam(value="groups", required=false) List<String> list8, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl6, @RequestParam(value="user", required=false) String string4, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /accounts/payment-limits");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchAccountPaymentLimitsParams searchAccountPaymentLimitsParams = new SearchAccountPaymentLimitsParams();
        searchAccountPaymentLimitsParams.fields = list;
        searchAccountPaymentLimitsParams.accountType = string;
        searchAccountPaymentLimitsParams.brokers = list2;
        searchAccountPaymentLimitsParams.by = string2;
        searchAccountPaymentLimitsParams.currency = string3;
        searchAccountPaymentLimitsParams.customAmountLimit = bl;
        searchAccountPaymentLimitsParams.customAmountLimitRange = list3;
        searchAccountPaymentLimitsParams.customAmountPerDayLimit = bl2;
        searchAccountPaymentLimitsParams.customAmountPerDayLimitRange = list4;
        searchAccountPaymentLimitsParams.customAmountPerMonthLimit = bl3;
        searchAccountPaymentLimitsParams.customAmountPerMonthLimitRange = list5;
        searchAccountPaymentLimitsParams.customAmountPerWeekLimit = bl4;
        searchAccountPaymentLimitsParams.customAmountPerWeekLimitRange = list6;
        searchAccountPaymentLimitsParams.customAmountPerYearLimit = bl5;
        searchAccountPaymentLimitsParams.customAmountPerYearLimitRange = list7;
        searchAccountPaymentLimitsParams.groups = list8;
        searchAccountPaymentLimitsParams.page = n;
        searchAccountPaymentLimitsParams.pageSize = n2;
        searchAccountPaymentLimitsParams.skipTotalCount = bl6;
        searchAccountPaymentLimitsParams.user = string4;
        return this.impl.searchAccountPaymentLimits(searchAccountPaymentLimitsParams);
    }

    @RequestMapping(value={"/api/{user:.*}/accounts/{accountType}/payment-limits"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> setAccountPaymentLimits(@PathVariable(value="user") String string, @PathVariable(value="accountType") String string2, @RequestHeader(value="confirmationPassword", required=false) String string3, @RequestBody(required=false) SetAccountPaymentLimits setAccountPaymentLimits, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /{user}/accounts/{accountType}/payment-limits");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SetAccountPaymentLimitsParams setAccountPaymentLimitsParams = new SetAccountPaymentLimitsParams();
        setAccountPaymentLimitsParams.user = string;
        setAccountPaymentLimitsParams.accountType = string2;
        setAccountPaymentLimitsParams.confirmationPassword = string3;
        setAccountPaymentLimitsParams.setAccountPaymentLimits = setAccountPaymentLimits;
        return this.impl.setAccountPaymentLimits(setAccountPaymentLimitsParams);
    }

    public static class ExportAccountPaymentLimitsParams {
        public String format;
        public static final String FORMAT = "format";
        public String accountType;
        public static final String ACCOUNT_TYPE = "accountType";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String by;
        public static final String BY = "by";
        public String currency;
        public static final String CURRENCY = "currency";
        public Boolean customAmountLimit;
        public static final String CUSTOM_AMOUNT_LIMIT = "customAmountLimit";
        public List<BigDecimal> customAmountLimitRange;
        public static final String CUSTOM_AMOUNT_LIMIT_RANGE = "customAmountLimitRange";
        public Boolean customAmountPerDayLimit;
        public static final String CUSTOM_AMOUNT_PER_DAY_LIMIT = "customAmountPerDayLimit";
        public List<BigDecimal> customAmountPerDayLimitRange;
        public static final String CUSTOM_AMOUNT_PER_DAY_LIMIT_RANGE = "customAmountPerDayLimitRange";
        public Boolean customAmountPerMonthLimit;
        public static final String CUSTOM_AMOUNT_PER_MONTH_LIMIT = "customAmountPerMonthLimit";
        public List<BigDecimal> customAmountPerMonthLimitRange;
        public static final String CUSTOM_AMOUNT_PER_MONTH_LIMIT_RANGE = "customAmountPerMonthLimitRange";
        public Boolean customAmountPerWeekLimit;
        public static final String CUSTOM_AMOUNT_PER_WEEK_LIMIT = "customAmountPerWeekLimit";
        public List<BigDecimal> customAmountPerWeekLimitRange;
        public static final String CUSTOM_AMOUNT_PER_WEEK_LIMIT_RANGE = "customAmountPerWeekLimitRange";
        public Boolean customAmountPerYearLimit;
        public static final String CUSTOM_AMOUNT_PER_YEAR_LIMIT = "customAmountPerYearLimit";
        public List<BigDecimal> customAmountPerYearLimitRange;
        public static final String CUSTOM_AMOUNT_PER_YEAR_LIMIT_RANGE = "customAmountPerYearLimitRange";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public String user;
        public static final String USER = "user";
    }

    public static class SearchAccountPaymentLimitsParams {
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String accountType;
        public static final String ACCOUNT_TYPE = "accountType";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String by;
        public static final String BY = "by";
        public String currency;
        public static final String CURRENCY = "currency";
        public Boolean customAmountLimit;
        public static final String CUSTOM_AMOUNT_LIMIT = "customAmountLimit";
        public List<BigDecimal> customAmountLimitRange;
        public static final String CUSTOM_AMOUNT_LIMIT_RANGE = "customAmountLimitRange";
        public Boolean customAmountPerDayLimit;
        public static final String CUSTOM_AMOUNT_PER_DAY_LIMIT = "customAmountPerDayLimit";
        public List<BigDecimal> customAmountPerDayLimitRange;
        public static final String CUSTOM_AMOUNT_PER_DAY_LIMIT_RANGE = "customAmountPerDayLimitRange";
        public Boolean customAmountPerMonthLimit;
        public static final String CUSTOM_AMOUNT_PER_MONTH_LIMIT = "customAmountPerMonthLimit";
        public List<BigDecimal> customAmountPerMonthLimitRange;
        public static final String CUSTOM_AMOUNT_PER_MONTH_LIMIT_RANGE = "customAmountPerMonthLimitRange";
        public Boolean customAmountPerWeekLimit;
        public static final String CUSTOM_AMOUNT_PER_WEEK_LIMIT = "customAmountPerWeekLimit";
        public List<BigDecimal> customAmountPerWeekLimitRange;
        public static final String CUSTOM_AMOUNT_PER_WEEK_LIMIT_RANGE = "customAmountPerWeekLimitRange";
        public Boolean customAmountPerYearLimit;
        public static final String CUSTOM_AMOUNT_PER_YEAR_LIMIT = "customAmountPerYearLimit";
        public List<BigDecimal> customAmountPerYearLimitRange;
        public static final String CUSTOM_AMOUNT_PER_YEAR_LIMIT_RANGE = "customAmountPerYearLimitRange";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public String user;
        public static final String USER = "user";
    }

    public static class SetAccountPaymentLimitsParams {
        public String user;
        public static final String USER = "user";
        public String accountType;
        public static final String ACCOUNT_TYPE = "accountType";
        public String confirmationPassword;
        public static final String CONFIRMATION_PASSWORD = "confirmationPassword";
        public SetAccountPaymentLimits setAccountPaymentLimits;
        public static final String SET_ACCOUNT_PAYMENT_LIMITS = "setAccountPaymentLimits";
    }
}

