/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.transactions.BaseInternalPaymentPreviewVO;
import org.cyclos.model.banking.transactions.CalculateInstallmentsDTO;
import org.cyclos.model.banking.transactions.PerformBasePaymentDTO;
import org.cyclos.model.banking.transactions.PerformPaymentDTO;
import org.cyclos.model.banking.transactions.PerformPaymentData;
import org.cyclos.model.banking.transactions.PerformPaymentToOwnerData;
import org.cyclos.model.banking.transactions.PerformRecurringPaymentDTO;
import org.cyclos.model.banking.transactions.PerformScheduledPaymentDTO;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.services.banking.PaymentService;
import org.cyclos.services.banking.RecurringPaymentService;
import org.cyclos.services.banking.ScheduledPaymentService;
import org.cyclos.services.banking.TransactionService;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.PaymentsApi;
import org.cyclos.web.rest.helpers.PaymentsApiHelper;
import org.cyclos.web.rest.helpers.ScheduledPaymentsApiHelper;
import org.cyclos.web.rest.helpers.TransactionsApiHelper;
import org.cyclos.web.rest.model.DataForTransaction;
import org.cyclos.web.rest.model.PaymentPreview;
import org.cyclos.web.rest.model.PerformInstallment;
import org.cyclos.web.rest.model.PerformPayment;
import org.cyclos.web.rest.model.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class PaymentsApiImpl
extends BaseApiImpl {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PaymentService paymentService;
    @Autowired
    private ScheduledPaymentService scheduledPaymentService;
    @Autowired
    private RecurringPaymentService recurringPaymentService;
    @Autowired
    @Lazy
    private TransactionsApiHelper transactionsApiHelper;
    @Autowired
    private PaymentsApiHelper paymentsApiHelper;
    @Autowired
    private ScheduledPaymentsApiHelper scheduledPaymentsApiHelper;

    public ResponseEntity<List<PerformInstallment>> calculatePerformPaymentInstallments(PaymentsApi.CalculatePerformPaymentInstallmentsParams calculatePerformPaymentInstallmentsParams) {
        CalculateInstallmentsDTO calculateInstallmentsDTO = this.scheduledPaymentsApiHelper.toCalculateInstallments(calculatePerformPaymentInstallmentsParams);
        List list = this.scheduledPaymentService.calculateInstallments(calculateInstallmentsDTO);
        List list2 = list.stream().map(this.scheduledPaymentsApiHelper::toPerformInstallment).collect(Collectors.toList());
        return this.ok(list2);
    }

    public ResponseEntity<DataForTransaction> dataForPerformPayment(PaymentsApi.DataForPerformPaymentParams dataForPerformPaymentParams) {
        InternalAccountOwner internalAccountOwner = ModelHelper.accountOwner((String)dataForPerformPaymentParams.owner);
        InternalAccountOwner internalAccountOwner2 = ModelHelper.accountOwner((String)dataForPerformPaymentParams.to);
        TransferTypeVO transferTypeVO = (TransferTypeVO)ModelHelper.voFromString(TransferTypeVO.class, (String)dataForPerformPaymentParams.type);
        PerformPaymentData performPaymentData = this.transactionService.getPaymentData(internalAccountOwner, internalAccountOwner2, transferTypeVO);
        DataForTransaction dataForTransaction = this.transactionsApiHelper.toDataForTransaction((PerformPaymentToOwnerData)performPaymentData);
        return this.ok(dataForTransaction);
    }

    public ResponseEntity<Transaction> performPayment(PaymentsApi.PerformPaymentParams performPaymentParams) {
        PerformBasePaymentDTO performBasePaymentDTO = this.paymentsApiHelper.toPerformDTO(performPaymentParams.owner, performPaymentParams.confirmationPassword, performPaymentParams.performPayment);
        Object object = performBasePaymentDTO instanceof PerformScheduledPaymentDTO ? this.scheduledPaymentService.perform((PerformScheduledPaymentDTO)performBasePaymentDTO) : (performBasePaymentDTO instanceof PerformRecurringPaymentDTO ? this.recurringPaymentService.perform((PerformRecurringPaymentDTO)performBasePaymentDTO) : this.paymentService.perform((PerformPaymentDTO)performBasePaymentDTO));
        return this.transactionsApiHelper.toResponseTransaction((TransactionVO)object);
    }

    public ResponseEntity<PaymentPreview> previewPayment(String string, PerformPayment performPayment, List<String> list) {
        PerformBasePaymentDTO performBasePaymentDTO = this.paymentsApiHelper.toPerformDTO(string, null, performPayment);
        Object object = performBasePaymentDTO instanceof PerformScheduledPaymentDTO ? this.scheduledPaymentService.preview((PerformScheduledPaymentDTO)performBasePaymentDTO) : (performBasePaymentDTO instanceof PerformRecurringPaymentDTO ? this.recurringPaymentService.preview((PerformRecurringPaymentDTO)performBasePaymentDTO) : this.paymentService.preview((PerformPaymentDTO)performBasePaymentDTO));
        PaymentPreview paymentPreview = this.paymentsApiHelper.toPaymentPreview((BaseInternalPaymentPreviewVO)object, performPayment.getSubject());
        return this.ok(paymentPreview);
    }
}

