/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import org.cyclos.model.banking.authorizations.TransactionAuthorizationDTO;
import org.cyclos.model.banking.transactions.PaymentAuthorizationLevelData;
import org.cyclos.services.banking.TransactionAuthorizationService;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.PendingPaymentsApi;
import org.cyclos.web.rest.helpers.TransactionsApiHelper;
import org.cyclos.web.rest.model.PendingPaymentActionParams;
import org.cyclos.web.rest.model.TransactionAuthorizationLevelData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class PendingPaymentsApiImpl
extends BaseApiImpl {
    @Autowired
    private TransactionAuthorizationService transactionAuthorizationService;
    @Autowired
    private TransactionsApiHelper transactionsApiHelper;

    public ResponseEntity<TransactionAuthorizationLevelData> authorizePendingPayment(PendingPaymentsApi.AuthorizePendingPaymentParams authorizePendingPaymentParams) {
        TransactionAuthorizationDTO transactionAuthorizationDTO = this.transactionsApiHelper.toTransactionAuthorizationDTO(authorizePendingPaymentParams.key, authorizePendingPaymentParams.pendingPaymentActionParams, authorizePendingPaymentParams.confirmationPassword);
        PaymentAuthorizationLevelData paymentAuthorizationLevelData = this.transactionAuthorizationService.authorize(transactionAuthorizationDTO);
        if (paymentAuthorizationLevelData == null) {
            return ResponseEntity.noContent().build();
        }
        TransactionAuthorizationLevelData transactionAuthorizationLevelData = this.transactionsApiHelper.toTransactionAuthorizationLevelData(paymentAuthorizationLevelData, null);
        return this.ok(transactionAuthorizationLevelData);
    }

    public ResponseEntity<Void> cancelPendingPayment(String string, PendingPaymentActionParams pendingPaymentActionParams, String string2) {
        TransactionAuthorizationDTO transactionAuthorizationDTO = this.transactionsApiHelper.toTransactionAuthorizationDTO(string, pendingPaymentActionParams, string2);
        this.transactionAuthorizationService.cancel(transactionAuthorizationDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> denyPendingPayment(String string, PendingPaymentActionParams pendingPaymentActionParams, String string2) {
        TransactionAuthorizationDTO transactionAuthorizationDTO = this.transactionsApiHelper.toTransactionAuthorizationDTO(string, pendingPaymentActionParams, string2);
        this.transactionAuthorizationService.deny(transactionAuthorizationDTO);
        return ResponseEntity.noContent().build();
    }
}

